/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v388.serializer;

import com.nukkitx.nbt.NbtUtils;
import com.nukkitx.nbt.stream.NBTInputStream;
import com.nukkitx.nbt.stream.NBTOutputStream;
import com.nukkitx.nbt.tag.ListTag;
import com.nukkitx.nbt.tag.Tag;
import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.data.GamePublishSetting;
import com.nukkitx.protocol.bedrock.packet.StartGamePacket;
import com.nukkitx.protocol.bedrock.v388.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StartGameSerializer_v388
implements PacketSerializer<StartGamePacket> {
    public static final StartGameSerializer_v388 INSTANCE = new StartGameSerializer_v388();
    private static final InternalLogger log = InternalLoggerFactory.getInstance(StartGameSerializer_v388.class);

    public void serialize(ByteBuf buffer, StartGamePacket packet) {
        VarInts.writeLong((ByteBuf)buffer, (long)packet.getUniqueEntityId());
        VarInts.writeUnsignedLong((ByteBuf)buffer, (long)packet.getRuntimeEntityId());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getPlayerGamemode());
        BedrockUtils.writeVector3f(buffer, packet.getPlayerPosition());
        BedrockUtils.writeVector2f(buffer, packet.getRotation());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getSeed());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getDimensionId());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getGeneratorId());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getLevelGamemode());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getDifficulty());
        BedrockUtils.writeBlockPosition(buffer, packet.getDefaultSpawn());
        buffer.writeBoolean(packet.isAchievementsDisabled());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getTime());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getEduEditionOffers());
        buffer.writeBoolean(packet.isEduFeaturesEnabled());
        buffer.writeFloatLE(packet.getRainLevel());
        buffer.writeFloatLE(packet.getLightningLevel());
        buffer.writeBoolean(packet.isPlatformLockedContentConfirmed());
        buffer.writeBoolean(packet.isMultiplayerGame());
        buffer.writeBoolean(packet.isBroadcastingToLan());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getXblBroadcastMode().ordinal());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getPlatformBroadcastMode().ordinal());
        buffer.writeBoolean(packet.isCommandsEnabled());
        buffer.writeBoolean(packet.isTexturePacksRequired());
        BedrockUtils.writeArray(buffer, packet.getGamerules(), BedrockUtils::writeGameRule);
        buffer.writeBoolean(packet.isBonusChestEnabled());
        buffer.writeBoolean(packet.isStartingWithMap());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getDefaultPlayerPermission());
        buffer.writeIntLE(packet.getServerChunkTickRange());
        buffer.writeBoolean(packet.isBehaviorPackLocked());
        buffer.writeBoolean(packet.isResourcePackLocked());
        buffer.writeBoolean(packet.isFromLockedWorldTemplate());
        buffer.writeBoolean(packet.isUsingMsaGamertagsOnly());
        buffer.writeBoolean(packet.isFromWorldTemplate());
        buffer.writeBoolean(packet.isWorldTemplateOptionLocked());
        buffer.writeBoolean(packet.isOnlySpawningV1Villagers());
        BedrockUtils.writeString(buffer, packet.getVanillaVersion());
        BedrockUtils.writeString(buffer, packet.getLevelId());
        BedrockUtils.writeString(buffer, packet.getWorldName());
        BedrockUtils.writeString(buffer, packet.getPremiumWorldTemplateId());
        buffer.writeBoolean(packet.isTrial());
        buffer.writeBoolean(packet.isMovementServerAuthoritative());
        buffer.writeLongLE(packet.getCurrentTick());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getEnchantmentSeed());
        try (NBTOutputStream stream = NbtUtils.createNetworkWriter((OutputStream)new ByteBufOutputStream(buffer));){
            stream.write((Tag)packet.getBlockPalette());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        BedrockUtils.writeArray(buffer, packet.getItemEntries(), (buf, entry) -> {
            BedrockUtils.writeString(buf, entry.getIdentifier());
            buf.writeShortLE((int)entry.getId());
        });
        BedrockUtils.writeString(buffer, packet.getMultiplayerCorrelationId());
    }

    public void deserialize(ByteBuf buffer, StartGamePacket packet) {
        packet.setUniqueEntityId(VarInts.readLong((ByteBuf)buffer));
        packet.setRuntimeEntityId(VarInts.readUnsignedLong((ByteBuf)buffer));
        packet.setPlayerGamemode(VarInts.readInt((ByteBuf)buffer));
        packet.setPlayerPosition(BedrockUtils.readVector3f(buffer));
        packet.setRotation(BedrockUtils.readVector2f(buffer));
        packet.setSeed(VarInts.readInt((ByteBuf)buffer));
        packet.setDimensionId(VarInts.readInt((ByteBuf)buffer));
        packet.setGeneratorId(VarInts.readInt((ByteBuf)buffer));
        packet.setLevelGamemode(VarInts.readInt((ByteBuf)buffer));
        packet.setDifficulty(VarInts.readInt((ByteBuf)buffer));
        packet.setDefaultSpawn(BedrockUtils.readBlockPosition(buffer));
        packet.setAchievementsDisabled(buffer.readBoolean());
        packet.setTime(VarInts.readInt((ByteBuf)buffer));
        packet.setEduEditionOffers(VarInts.readInt((ByteBuf)buffer));
        packet.setEduFeaturesEnabled(buffer.readBoolean());
        packet.setRainLevel(buffer.readFloatLE());
        packet.setLightningLevel(buffer.readFloatLE());
        packet.setPlatformLockedContentConfirmed(buffer.readBoolean());
        packet.setMultiplayerGame(buffer.readBoolean());
        packet.setBroadcastingToLan(buffer.readBoolean());
        packet.setXblBroadcastMode(GamePublishSetting.byId((int)VarInts.readInt((ByteBuf)buffer)));
        packet.setPlatformBroadcastMode(GamePublishSetting.byId((int)VarInts.readInt((ByteBuf)buffer)));
        packet.setCommandsEnabled(buffer.readBoolean());
        packet.setTexturePacksRequired(buffer.readBoolean());
        BedrockUtils.readArray(buffer, packet.getGamerules(), BedrockUtils::readGameRule);
        packet.setBonusChestEnabled(buffer.readBoolean());
        packet.setStartingWithMap(buffer.readBoolean());
        packet.setDefaultPlayerPermission(VarInts.readInt((ByteBuf)buffer));
        packet.setServerChunkTickRange(buffer.readIntLE());
        packet.setBehaviorPackLocked(buffer.readBoolean());
        packet.setResourcePackLocked(buffer.readBoolean());
        packet.setFromLockedWorldTemplate(buffer.readBoolean());
        packet.setUsingMsaGamertagsOnly(buffer.readBoolean());
        packet.setFromWorldTemplate(buffer.readBoolean());
        packet.setWorldTemplateOptionLocked(buffer.readBoolean());
        packet.setOnlySpawningV1Villagers(buffer.readBoolean());
        packet.setVanillaVersion(BedrockUtils.readString(buffer));
        packet.setLevelId(BedrockUtils.readString(buffer));
        packet.setWorldName(BedrockUtils.readString(buffer));
        packet.setPremiumWorldTemplateId(BedrockUtils.readString(buffer));
        packet.setTrial(buffer.readBoolean());
        packet.setMovementServerAuthoritative(buffer.readBoolean());
        packet.setCurrentTick(buffer.readLongLE());
        packet.setEnchantmentSeed(VarInts.readInt((ByteBuf)buffer));
        try (NBTInputStream stream = NbtUtils.createNetworkReader((InputStream)new ByteBufInputStream(buffer));){
            packet.setBlockPalette((ListTag)stream.readTag());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        BedrockUtils.readArray(buffer, packet.getItemEntries(), buf -> {
            String identifier = BedrockUtils.readString(buf);
            short id = buf.readShortLE();
            return new StartGamePacket.ItemEntry(identifier, id);
        });
        packet.setMultiplayerCorrelationId(BedrockUtils.readString(buffer));
    }

    private StartGameSerializer_v388() {
    }
}

