/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v388.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.packet.PlayerListPacket;
import com.nukkitx.protocol.bedrock.v388.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;

public class PlayerListSerializer_v388
implements PacketSerializer<PlayerListPacket> {
    public static final PlayerListSerializer_v388 INSTANCE = new PlayerListSerializer_v388();

    public void serialize(ByteBuf buffer, PlayerListPacket packet) {
        buffer.writeByte(packet.getType().ordinal());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)packet.getEntries().size());
        for (PlayerListPacket.Entry entry : packet.getEntries()) {
            BedrockUtils.writeUuid(buffer, entry.getUuid());
            if (packet.getType() != PlayerListPacket.Type.ADD) continue;
            VarInts.writeLong((ByteBuf)buffer, (long)entry.getEntityId());
            BedrockUtils.writeString(buffer, entry.getName());
            BedrockUtils.writeString(buffer, entry.getXuid());
            BedrockUtils.writeString(buffer, entry.getPlatformChatId());
            buffer.writeIntLE(entry.getBuildPlatform());
            BedrockUtils.writeSkin(buffer, entry.getSkin());
            buffer.writeBoolean(entry.isTeacher());
            buffer.writeBoolean(entry.isHost());
        }
    }

    public void deserialize(ByteBuf buffer, PlayerListPacket packet) {
        PlayerListPacket.Type type = PlayerListPacket.Type.values()[buffer.readUnsignedByte()];
        packet.setType(type);
        int length = VarInts.readUnsignedInt((ByteBuf)buffer);
        for (int i = 0; i < length; ++i) {
            PlayerListPacket.Entry entry = new PlayerListPacket.Entry(BedrockUtils.readUuid(buffer));
            if (type == PlayerListPacket.Type.ADD) {
                entry.setEntityId(VarInts.readLong((ByteBuf)buffer));
                entry.setName(BedrockUtils.readString(buffer));
                entry.setXuid(BedrockUtils.readString(buffer));
                entry.setPlatformChatId(BedrockUtils.readString(buffer));
                entry.setBuildPlatform(buffer.readIntLE());
                entry.setSkin(BedrockUtils.readSkin(buffer));
                entry.setTeacher(buffer.readBoolean());
                entry.setHost(buffer.readBoolean());
            }
            packet.getEntries().add(entry);
        }
    }

    private PlayerListSerializer_v388() {
    }
}

