/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v388.serializer;

import com.nukkitx.protocol.bedrock.packet.BookEditPacket;
import com.nukkitx.protocol.bedrock.v388.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import com.nukkitx.protocol.util.TIntHashBiMap;
import io.netty.buffer.ByteBuf;

public class BookEditSerializer_v388
implements PacketSerializer<BookEditPacket> {
    public static final BookEditSerializer_v388 INSTANCE = new BookEditSerializer_v388();
    private static final TIntHashBiMap<BookEditPacket.Type> types = new TIntHashBiMap();

    public void serialize(ByteBuf buffer, BookEditPacket packet) {
        buffer.writeByte(packet.getType().ordinal());
        buffer.writeByte(packet.getInventorySlot());
        switch (packet.getType()) {
            case REPLACE_PAGE: 
            case ADD_PAGE: {
                buffer.writeByte(packet.getPageNumber());
                BedrockUtils.writeString(buffer, packet.getText());
                BedrockUtils.writeString(buffer, packet.getPhotoName());
                break;
            }
            case DELETE_PAGE: {
                buffer.writeByte(packet.getPageNumber());
                break;
            }
            case SWAP_PAGES: {
                buffer.writeByte(packet.getPageNumber());
                buffer.writeByte(packet.getSecondaryPageNumber());
                break;
            }
            case SIGN_BOOK: {
                BedrockUtils.writeString(buffer, packet.getTitle());
                BedrockUtils.writeString(buffer, packet.getAuthor());
                BedrockUtils.writeString(buffer, packet.getXuid());
            }
        }
    }

    public void deserialize(ByteBuf buffer, BookEditPacket packet) {
        packet.setType((BookEditPacket.Type)types.get((int)buffer.readUnsignedByte()));
        packet.setInventorySlot((int)buffer.readUnsignedByte());
        switch (packet.getType()) {
            case REPLACE_PAGE: 
            case ADD_PAGE: {
                packet.setPageNumber((int)buffer.readUnsignedByte());
                packet.setText(BedrockUtils.readString(buffer));
                packet.setPhotoName(BedrockUtils.readString(buffer));
                break;
            }
            case DELETE_PAGE: {
                packet.setPageNumber((int)buffer.readUnsignedByte());
                break;
            }
            case SWAP_PAGES: {
                packet.setPageNumber((int)buffer.readUnsignedByte());
                packet.setSecondaryPageNumber((int)buffer.readUnsignedByte());
                break;
            }
            case SIGN_BOOK: {
                packet.setTitle(BedrockUtils.readString(buffer));
                packet.setAuthor(BedrockUtils.readString(buffer));
                packet.setXuid(BedrockUtils.readString(buffer));
            }
        }
    }

    private BookEditSerializer_v388() {
    }

    static {
        types.put(0, (Object)BookEditPacket.Type.REPLACE_PAGE);
        types.put(1, (Object)BookEditPacket.Type.ADD_PAGE);
        types.put(2, (Object)BookEditPacket.Type.DELETE_PAGE);
        types.put(3, (Object)BookEditPacket.Type.SWAP_PAGES);
        types.put(4, (Object)BookEditPacket.Type.SIGN_BOOK);
    }
}

