/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v388.serializer;

import com.nukkitx.nbt.NbtUtils;
import com.nukkitx.nbt.stream.NBTInputStream;
import com.nukkitx.nbt.stream.NBTOutputStream;
import com.nukkitx.protocol.bedrock.packet.BlockEntityDataPacket;
import com.nukkitx.protocol.bedrock.v388.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BlockEntityDataSerializer_v388
implements PacketSerializer<BlockEntityDataPacket> {
    public static final BlockEntityDataSerializer_v388 INSTANCE = new BlockEntityDataSerializer_v388();

    public void serialize(ByteBuf buffer, BlockEntityDataPacket packet) {
        BedrockUtils.writeBlockPosition(buffer, packet.getBlockPosition());
        try (NBTOutputStream writer = NbtUtils.createNetworkWriter((OutputStream)new ByteBufOutputStream(buffer));){
            writer.write(packet.getData());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deserialize(ByteBuf buffer, BlockEntityDataPacket packet) {
        packet.setBlockPosition(BedrockUtils.readBlockPosition(buffer));
        try (NBTInputStream reader = NbtUtils.createNetworkReader((InputStream)new ByteBufInputStream(buffer));){
            packet.setData(reader.readTag());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private BlockEntityDataSerializer_v388() {
    }
}

