package com.nukkitx.protocol.bedrock.v388;

import com.nukkitx.protocol.bedrock.BedrockPacketCodec;
import com.nukkitx.protocol.bedrock.packet.*;
import com.nukkitx.protocol.bedrock.v388.serializer.*;
import lombok.experimental.UtilityClass;

@UtilityClass
public class Bedrock_v388 {
    public static BedrockPacketCodec V388_CODEC = BedrockPacketCodec.builder()
            .protocolVersion(388)
            .minecraftVersion("1.13.0")
            .headerSerializer(PacketHeaderSerializer_v388.INSTANCE)
            .registerPacket(LoginPacket.class, LoginSerializer_v388.INSTANCE, 1)
            .registerPacket(PlayStatusPacket.class, PlayStatusSerializer_v388.INSTANCE, 2)
            .registerPacket(ServerToClientHandshakePacket.class, ServerToClientHandshakeSerializer_v388.INSTANCE, 3)
            .registerPacket(ClientToServerHandshakePacket.class, ClientToServerHandshakeSerializer_v388.INSTANCE, 4)
            .registerPacket(DisconnectPacket.class, DisconnectSerializer_v388.INSTANCE, 5)
            .registerPacket(ResourcePacksInfoPacket.class, ResourcePacksInfoSerializer_v388.INSTANCE, 6)
            .registerPacket(ResourcePackStackPacket.class, ResourcePackStackSerializer_v388.INSTANCE, 7)
            .registerPacket(ResourcePackClientResponsePacket.class, ResourcePackClientResponseSerializer_v388.INSTANCE, 8)
            .registerPacket(TextPacket.class, TextSerializer_v388.INSTANCE, 9)
            .registerPacket(SetTimePacket.class, SetTimeSerializer_v388.INSTANCE, 10)
            .registerPacket(StartGamePacket.class, StartGameSerializer_v388.INSTANCE, 11)
            .registerPacket(AddPlayerPacket.class, AddPlayerSerializer_v388.INSTANCE, 12)
            .registerPacket(AddEntityPacket.class, AddEntitySerializer_v388.INSTANCE, 13)
            .registerPacket(RemoveEntityPacket.class, RemoveEntitySerializer_v388.INSTANCE, 14)
            .registerPacket(AddItemEntityPacket.class, AddItemEntitySerializer_v388.INSTANCE, 15)
            .registerPacket(TakeItemEntityPacket.class, TakeItemEntitySerializer_v388.INSTANCE, 17)
            .registerPacket(MoveEntityAbsolutePacket.class, MoveEntityAbsoluteSerializer_v388.INSTANCE, 18)
            .registerPacket(MovePlayerPacket.class, MovePlayerSerializer_v388.INSTANCE, 19)
            .registerPacket(RiderJumpPacket.class, RiderJumpSerializer_v388.INSTANCE, 20)
            .registerPacket(UpdateBlockPacket.class, UpdateBlockSerializer_v388.INSTANCE, 21)
            .registerPacket(AddPaintingPacket.class, AddPaintingSerializer_v388.INSTANCE, 22)
            .registerPacket(TickSyncPacket.class, TickSyncSerializer_v388.INSTANCE, 23)
            .registerPacket(LevelSoundEventPacket.class, LevelSoundEventSerializer_v388.INSTANCE, 24)
            .registerPacket(LevelEventPacket.class, LevelEventSerializer_v388.INSTANCE, 25)
            .registerPacket(BlockEventPacket.class, BlockEventSerializer_v388.INSTANCE, 26)
            .registerPacket(EntityEventPacket.class, EntityEventSerializer_v388.INSTANCE, 27)
            .registerPacket(MobEffectPacket.class, MobEffectSerializer_v388.INSTANCE, 28)
            .registerPacket(UpdateAttributesPacket.class, UpdateAttributesSerializer_v388.INSTANCE, 29)
            .registerPacket(InventoryTransactionPacket.class, InventoryTransactionSerializer_v388.INSTANCE, 30)
            .registerPacket(MobEquipmentPacket.class, MobEquipmentSerializer_v388.INSTANCE, 31)
            .registerPacket(MobArmorEquipmentPacket.class, MobArmorEquipmentSerializer_v388.INSTANCE, 32)
            .registerPacket(InteractPacket.class, InteractSerializer_v388.INSTANCE, 33)
            .registerPacket(BlockPickRequestPacket.class, BlockPickRequestSerializer_v388.INSTANCE, 34)
            .registerPacket(EntityPickRequestPacket.class, EntityPickRequestSerializer_v388.INSTANCE, 35)
            .registerPacket(PlayerActionPacket.class, PlayerActionSerializer_v388.INSTANCE, 36)
            .registerPacket(EntityFallPacket.class, EntityFallSerializer_v388.INSTANCE, 37)
            .registerPacket(HurtArmorPacket.class, HurtArmorSerializer_v388.INSTANCE, 38)
            .registerPacket(SetEntityDataPacket.class, SetEntityDataSerializer_v388.INSTANCE, 39)
            .registerPacket(SetEntityMotionPacket.class, SetEntityMotionSerializer_v388.INSTANCE, 40)
            .registerPacket(SetEntityLinkPacket.class, SetEntityLinkSerializer_v388.INSTANCE, 41)
            .registerPacket(SetHealthPacket.class, SetHealthSerializer_v388.INSTANCE, 42)
            .registerPacket(SetSpawnPositionPacket.class, SetSpawnPositionSerializer_v388.INSTANCE, 43)
            .registerPacket(AnimatePacket.class, AnimateSerializer_v388.INSTANCE, 44)
            .registerPacket(RespawnPacket.class, RespawnSerializer_v388.INSTANCE, 45)
            .registerPacket(ContainerOpenPacket.class, ContainerOpenSerializer_v388.INSTANCE, 46)
            .registerPacket(ContainerClosePacket.class, ContainerCloseSerializer_v388.INSTANCE, 47)
            .registerPacket(PlayerHotbarPacket.class, PlayerHotbarSerializer_v388.INSTANCE, 48)
            .registerPacket(InventoryContentPacket.class, InventoryContentSerializer_v388.INSTANCE, 49)
            .registerPacket(InventorySlotPacket.class, InventorySlotSerializer_v388.INSTANCE, 50)
            .registerPacket(ContainerSetDataPacket.class, ContainerSetDataSerializer_v388.INSTANCE, 51)
            .registerPacket(CraftingDataPacket.class, CraftingDataSerializer_v388.INSTANCE, 52)
            .registerPacket(CraftingEventPacket.class, CraftingEventSerializer_v388.INSTANCE, 53)
            .registerPacket(GuiDataPickItemPacket.class, GuiDataPickItemSerializer_v388.INSTANCE, 54)
            .registerPacket(AdventureSettingsPacket.class, AdventureSettingsSerializer_v388.INSTANCE, 55)
            .registerPacket(BlockEntityDataPacket.class, BlockEntityDataSerializer_v388.INSTANCE, 56)
            .registerPacket(PlayerInputPacket.class, PlayerInputSerializer_v388.INSTANCE, 57)
            .registerPacket(LevelChunkPacket.class, LevelChunkSerializer_v388.INSTANCE, 58)
            .registerPacket(SetCommandsEnabledPacket.class, SetCommandsEnabledSerializer_v388.INSTANCE, 59)
            .registerPacket(SetDifficultyPacket.class, SetDifficultySerializer_v388.INSTANCE, 60)
            .registerPacket(ChangeDimensionPacket.class, ChangeDimensionSerializer_v388.INSTANCE, 61)
            .registerPacket(SetPlayerGameTypePacket.class, SetPlayerGameTypeSerializer_v388.INSTANCE, 62)
            .registerPacket(PlayerListPacket.class, PlayerListSerializer_v388.INSTANCE, 63)
            .registerPacket(SimpleEventPacket.class, SimpleEventSerializer_v388.INSTANCE, 64)
            .registerPacket(EventPacket.class, EventSerializer_v388.INSTANCE, 65)
            .registerPacket(SpawnExperienceOrbPacket.class, SpawnExperienceOrbSerializer_v388.INSTANCE, 66)
            .registerPacket(ClientboundMapItemDataPacket.class, ClientboundMapItemDataSerializer_v388.INSTANCE, 67)
            .registerPacket(MapInfoRequestPacket.class, MapInfoRequestSerializer_v388.INSTANCE, 68)
            .registerPacket(RequestChunkRadiusPacket.class, RequestChunkRadiusSerializer_v388.INSTANCE, 69)
            .registerPacket(ChunkRadiusUpdatedPacket.class, ChunkRadiusUpdatedSerializer_v388.INSTANCE, 70)
            .registerPacket(ItemFrameDropItemPacket.class, ItemFrameDropItemSerializer_v388.INSTANCE, 71)
            .registerPacket(GameRulesChangedPacket.class, GameRulesChangedSerializer_v388.INSTANCE, 72)
            .registerPacket(CameraPacket.class, CameraSerializer_v388.INSTANCE, 73)
            .registerPacket(BossEventPacket.class, BossEventSerializer_v388.INSTANCE, 74)
            .registerPacket(ShowCreditsPacket.class, ShowCreditsSerializer_v388.INSTANCE, 75)
            .registerPacket(AvailableCommandsPacket.class, AvailableCommandsSerializer_v388.INSTANCE, 76)
            .registerPacket(CommandRequestPacket.class, CommandRequestSerializer_v388.INSTANCE, 77)
            .registerPacket(CommandBlockUpdatePacket.class, CommandBlockUpdateSerializer_v388.INSTANCE, 78)
            .registerPacket(CommandOutputPacket.class, CommandOutputSerializer_v388.INSTANCE, 79)
            .registerPacket(UpdateTradePacket.class, UpdateTradeSerializer_v388.INSTANCE, 80)
            .registerPacket(UpdateEquipPacket.class, UpdateEquipSerializer_v388.INSTANCE, 81)
            .registerPacket(ResourcePackDataInfoPacket.class, ResourcePackDataInfoSerializer_v388.INSTANCE, 82)
            .registerPacket(ResourcePackChunkDataPacket.class, ResourcePackChunkDataSerializer_v388.INSTANCE, 83)
            .registerPacket(ResourcePackChunkRequestPacket.class, ResourcePackChunkRequestSerializer_v388.INSTANCE, 84)
            .registerPacket(TransferPacket.class, TransferSerializer_v388.INSTANCE, 85)
            .registerPacket(PlaySoundPacket.class, PlaySoundSerializer_v388.INSTANCE, 86)
            .registerPacket(StopSoundPacket.class, StopSoundSerializer_v388.INSTANCE, 87)
            .registerPacket(SetTitlePacket.class, SetTitleSerializer_v388.INSTANCE, 88)
            .registerPacket(AddBehaviorTreePacket.class, AddBehaviorTreeSerializer_v388.INSTANCE, 89)
            .registerPacket(StructureBlockUpdatePacket.class, StructureBlockUpdateSerializer_v388.INSTANCE, 90)
            .registerPacket(ShowStoreOfferPacket.class, ShowStoreOfferSerializer_v388.INSTANCE, 91)
            .registerPacket(PurchaseReceiptPacket.class, PurchaseReceiptSerializer_v388.INSTANCE, 92)
            .registerPacket(PlayerSkinPacket.class, PlayerSkinSerializer_v388.INSTANCE, 93)
            .registerPacket(SubClientLoginPacket.class, SubClientLoginSerializer_v388.INSTANCE, 94)
            .registerPacket(AutomationClientConnectPacket.class, AutomationClientConnectSerializer_v388.INSTANCE, 95)
            .registerPacket(SetLastHurtByPacket.class, SetLastHurtBySerializer_v388.INSTANCE, 96)
            .registerPacket(BookEditPacket.class, BookEditSerializer_v388.INSTANCE, 97)
            .registerPacket(NpcRequestPacket.class, NpcRequestSerializer_v388.INSTANCE, 98)
            .registerPacket(PhotoTransferPacket.class, PhotoTransferSerializer_v388.INSTANCE, 99)
            .registerPacket(ModalFormRequestPacket.class, ModalFormRequestSerializer_v388.INSTANCE, 100)
            .registerPacket(ModalFormResponsePacket.class, ModalFormResponseSerializer_v388.INSTANCE, 101)
            .registerPacket(ServerSettingsRequestPacket.class, ServerSettingsRequestSerializer_v388.INSTANCE, 102)
            .registerPacket(ServerSettingsResponsePacket.class, ServerSettingsResponseSerializer_v388.INSTANCE, 103)
            .registerPacket(ShowProfilePacket.class, ShowProfileSerializer_v388.INSTANCE, 104)
            .registerPacket(SetDefaultGameTypePacket.class, SetDefaultGameTypeSerializer_v388.INSTANCE, 105)
            .registerPacket(RemoveObjectivePacket.class, RemoveObjectiveSerializer_v388.INSTANCE, 106)
            .registerPacket(SetDisplayObjectivePacket.class, SetDisplayObjectiveSerializer_v388.INSTANCE, 107)
            .registerPacket(SetScorePacket.class, SetScoreSerializer_v388.INSTANCE, 108)
            .registerPacket(LabTablePacket.class, LabTableSerializer_v388.INSTANCE, 109)
            .registerPacket(UpdateBlockSyncedPacket.class, UpdateBlockSyncedSerializer_v388.INSTANCE, 110)
            .registerPacket(MoveEntityDeltaPacket.class, MoveEntityDeltaSerializer_v388.INSTANCE, 111)
            .registerPacket(SetScoreboardIdentityPacket.class, SetScoreboardIdentitySerializer_v388.INSTANCE, 112)
            .registerPacket(SetLocalPlayerAsInitializedPacket.class, SetLocalPlayerAsInitializedSerializer_v388.INSTANCE, 113)
            .registerPacket(UpdateSoftEnumPacket.class, UpdateSoftEnumSerializer_v388.INSTANCE, 114)
            .registerPacket(NetworkStackLatencyPacket.class, NetworkStackLatencySerializer_v388.INSTANCE, 115)
            .registerPacket(ScriptCustomEventPacket.class, ScriptCustomEventSerializer_v388.INSTANCE, 117)
            .registerPacket(SpawnParticleEffectPacket.class, SpawnParticleEffectSerializer_v388.INSTANCE, 118)
            .registerPacket(AvailableEntityIdentifiersPacket.class, AvailableEntityIdentifiersSerializer_v388.INSTANCE, 119)
            .registerPacket(LevelSoundEvent2Packet.class, LevelSoundEvent2Serializer_v388.INSTANCE, 120)
            .registerPacket(NetworkChunkPublisherUpdatePacket.class, NetworkChunkPublisherUpdateSerializer_v388.INSTANCE, 121)
            .registerPacket(BiomeDefinitionListPacket.class, BiomeDefinitionListSerializer_v388.INSTANCE, 122)
            .registerPacket(LevelSoundEvent3Packet.class, LevelSoundEvent3Serializer_v388.INSTANCE, 123)
            .registerPacket(LevelEventGenericPacket.class, LevelEventGenericSerializer_v388.INSTANCE, 124)
            .registerPacket(LecternUpdatePacket.class, LecternUpdateSerializer_v388.INSTANCE, 125)
            .registerPacket(VideoStreamConnectPacket.class, VideoStreamConnectSerializer_v388.INSTANCE, 126)
            // AddEntityPacket 127
            // RemoveEntityPacket 128
            .registerPacket(ClientCacheStatusPacket.class, ClientCacheStatusSerializer_v388.INSTANCE, 129)
            .registerPacket(OnScreenTextureAnimationPacket.class, OnScreenTextureAnimationSerializer_v388.INSTANCE, 130)
            .registerPacket(MapCreateLockedCopyPacket.class, MapCreateLockedCopySerializer_v388.INSTANCE, 131)
            .registerPacket(StructureTemplateDataExportRequestPacket.class, StructureTemplateDataExportRequestSerializer_v388.INSTANCE, 132)
            .registerPacket(StructureTemplateDataExportResponsePacket.class, StructureTemplateDataExportResponseSerializer_v388.INSTANCE, 133)
            .registerPacket(UpdateBlockPropertiesPacket.class, UpdateBlockPropertiesSerializer_v388.INSTANCE, 134)
            .registerPacket(ClientCacheBlobStatusPacket.class, ClientCacheBlobStatusSerializer_v388.INSTANCE, 135)
            .registerPacket(ClientCacheMissResponsePacket.class, ClientCacheMissResponseSerializer_v388.INSTANCE, 136)
            .registerPacket(EducationSettingsPacket.class, EducationSettingsSerializer_v388.INSTANCE, 137)
            .registerPacket(EmotePacket.class, EmoteSerializer_v388.INSTANCE, 138)
            .registerPacket(MultiplayerSettingsPacket.class, MultiplayerSettingsSerializer_v388.INSTANCE, 139)
            .registerPacket(SettingsCommandPacket.class, SettingsCommandSerializer_v388.INSTANCE, 140)
            .registerPacket(AnvilDamagePacket.class, AnvilDamageSerializer_v388.INSTANCE, 141)
            .registerPacket(CompletedUsingItemPacket.class, CompletedUsingItemSerializer_v388.INSTANCE, 142)
            .registerPacket(NetworkSettingsPacket.class, NetworkSettingsSerializer_v388.INSTANCE, 143)
            .registerPacket(PlayerAuthInputPacket.class, PlayerAuthInputSerializer_v388.INSTANCE, 144)
            .build();
}
