/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v361.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.data.CraftingData;
import com.nukkitx.protocol.bedrock.data.CraftingType;
import com.nukkitx.protocol.bedrock.data.ItemData;
import com.nukkitx.protocol.bedrock.packet.CraftingDataPacket;
import com.nukkitx.protocol.bedrock.v361.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.UUID;

public class CraftingDataSerializer_v361
implements PacketSerializer<CraftingDataPacket> {
    public static final CraftingDataSerializer_v361 INSTANCE = new CraftingDataSerializer_v361();
    private static final InternalLogger log = InternalLoggerFactory.getInstance(CraftingDataSerializer_v361.class);

    public void serialize(ByteBuf buffer, CraftingDataPacket packet) {
        BedrockUtils.writeArray(buffer, packet.getCraftingData(), (buf, craftingData) -> {
            VarInts.writeInt((ByteBuf)buf, (int)craftingData.getType().ordinal());
            switch (craftingData.getType()) {
                case SHAPELESS: 
                case SHAPELESS_CHEMISTRY: 
                case SHULKER_BOX: {
                    BedrockUtils.writeString(buf, craftingData.getRecipeId());
                    BedrockUtils.writeArray(buf, craftingData.getInputs(), BedrockUtils::writeRecipeIngredient);
                    BedrockUtils.writeArray(buf, craftingData.getOutputs(), BedrockUtils::writeItemData);
                    BedrockUtils.writeUuid(buf, craftingData.getUuid());
                    BedrockUtils.writeString(buf, craftingData.getCraftingTag());
                    VarInts.writeInt((ByteBuf)buf, (int)craftingData.getPriority());
                    break;
                }
                case SHAPED: 
                case SHAPED_CHEMISTRY: {
                    BedrockUtils.writeString(buf, craftingData.getRecipeId());
                    VarInts.writeInt((ByteBuf)buf, (int)craftingData.getWidth());
                    VarInts.writeInt((ByteBuf)buf, (int)craftingData.getHeight());
                    int count = craftingData.getWidth() * craftingData.getHeight();
                    ItemData[] inputs = craftingData.getInputs();
                    for (int i = 0; i < count; ++i) {
                        BedrockUtils.writeRecipeIngredient(buf, inputs[i]);
                    }
                    BedrockUtils.writeArray(buf, craftingData.getOutputs(), BedrockUtils::writeItemData);
                    BedrockUtils.writeUuid(buf, craftingData.getUuid());
                    BedrockUtils.writeString(buf, craftingData.getCraftingTag());
                    VarInts.writeInt((ByteBuf)buf, (int)craftingData.getPriority());
                    break;
                }
                case FURNACE: 
                case FURNACE_DATA: {
                    VarInts.writeInt((ByteBuf)buf, (int)craftingData.getInputId());
                    if (craftingData.getType() == CraftingType.FURNACE_DATA) {
                        VarInts.writeInt((ByteBuf)buf, (int)craftingData.getInputDamage());
                    }
                    BedrockUtils.writeItemData(buf, craftingData.getOutputs()[0]);
                    BedrockUtils.writeString(buf, craftingData.getCraftingTag());
                    break;
                }
                case MULTI: {
                    BedrockUtils.writeUuid(buf, craftingData.getUuid());
                }
            }
        });
        buffer.writeBoolean(packet.isCleanRecipes());
    }

    public void deserialize(ByteBuf buffer, CraftingDataPacket packet) {
        BedrockUtils.readArray(buffer, packet.getCraftingData(), buf -> {
            int typeInt = VarInts.readInt((ByteBuf)buf);
            CraftingType type = CraftingType.byId((int)typeInt);
            if (type == null) {
                throw new IllegalArgumentException("Unknown crafting type: " + typeInt);
            }
            switch (type) {
                case SHAPELESS: 
                case SHAPELESS_CHEMISTRY: 
                case SHULKER_BOX: {
                    String recipeId = BedrockUtils.readString(buf);
                    int inputCount = VarInts.readUnsignedInt((ByteBuf)buf);
                    ItemData[] inputs = new ItemData[inputCount];
                    for (int i = 0; i < inputCount; ++i) {
                        inputs[i] = BedrockUtils.readRecipeIngredient(buf);
                    }
                    int outputCount = VarInts.readUnsignedInt((ByteBuf)buf);
                    ItemData[] outputs = new ItemData[outputCount];
                    for (int i = 0; i < outputCount; ++i) {
                        outputs[i] = BedrockUtils.readItemData(buf);
                    }
                    UUID uuid = BedrockUtils.readUuid(buf);
                    String craftingTag = BedrockUtils.readString(buf);
                    int priority = VarInts.readInt((ByteBuf)buf);
                    return new CraftingData(type, recipeId, -1, -1, -1, -1, inputs, outputs, uuid, craftingTag, priority);
                }
                case SHAPED: 
                case SHAPED_CHEMISTRY: {
                    int i;
                    String recipeId = BedrockUtils.readString(buf);
                    int width = VarInts.readInt((ByteBuf)buf);
                    int height = VarInts.readInt((ByteBuf)buf);
                    int inputCount = width * height;
                    ItemData[] inputs = new ItemData[inputCount];
                    for (i = 0; i < inputCount; ++i) {
                        inputs[i] = BedrockUtils.readRecipeIngredient(buf);
                    }
                    int outputCount = VarInts.readUnsignedInt((ByteBuf)buf);
                    ItemData[] outputs = new ItemData[outputCount];
                    for (i = 0; i < outputCount; ++i) {
                        outputs[i] = BedrockUtils.readItemData(buf);
                    }
                    UUID uuid = BedrockUtils.readUuid(buf);
                    String craftingTag = BedrockUtils.readString(buf);
                    int priority = VarInts.readInt((ByteBuf)buf);
                    return new CraftingData(type, recipeId, width, height, -1, -1, inputs, outputs, uuid, craftingTag, priority);
                }
                case FURNACE: 
                case FURNACE_DATA: {
                    int inputId = VarInts.readInt((ByteBuf)buf);
                    int inputDamage = type == CraftingType.FURNACE_DATA ? VarInts.readInt((ByteBuf)buf) : -1;
                    ItemData[] output = new ItemData[]{BedrockUtils.readItemData(buf)};
                    String craftingTag = BedrockUtils.readString(buf);
                    return new CraftingData(type, null, -1, -1, inputId, inputDamage, null, output, null, craftingTag, -1);
                }
                case MULTI: {
                    UUID uuid = BedrockUtils.readUuid(buf);
                    return CraftingData.fromMulti((UUID)uuid);
                }
            }
            throw new IllegalArgumentException("Unhandled crafting data type: " + type);
        });
        packet.setCleanRecipes(buffer.readBoolean());
    }

    private CraftingDataSerializer_v361() {
    }
}

