/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v361.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.packet.ClientCacheBlobStatusPacket;
import com.nukkitx.protocol.serializer.PacketSerializer;
import gnu.trove.list.TLongList;
import io.netty.buffer.ByteBuf;

public class ClientCacheBlobStatusSerializer_v361
implements PacketSerializer<ClientCacheBlobStatusPacket> {
    public static final ClientCacheBlobStatusSerializer_v361 INSTANCE = new ClientCacheBlobStatusSerializer_v361();

    public void serialize(ByteBuf buffer, ClientCacheBlobStatusPacket packet) {
        TLongList acks = packet.getAcks();
        TLongList nacks = packet.getNaks();
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)acks.size());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)nacks.size());
        acks.forEach(blobId -> {
            buffer.writeLongLE(blobId);
            return true;
        });
        nacks.forEach(blobId -> {
            buffer.writeLongLE(blobId);
            return true;
        });
    }

    public void deserialize(ByteBuf buffer, ClientCacheBlobStatusPacket packet) {
        int acksLength = VarInts.readUnsignedInt((ByteBuf)buffer);
        int naksLength = VarInts.readUnsignedInt((ByteBuf)buffer);
        TLongList acks = packet.getAcks();
        for (int i = 0; i < acksLength; ++i) {
            acks.add(buffer.readLongLE());
        }
        TLongList naks = packet.getNaks();
        for (int i = 0; i < naksLength; ++i) {
            naks.add(buffer.readLongLE());
        }
    }

    private ClientCacheBlobStatusSerializer_v361() {
    }
}

