/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v361.serializer;

import com.nukkitx.protocol.bedrock.data.ImageData;
import com.nukkitx.protocol.bedrock.data.SerializedSkin;
import com.nukkitx.protocol.bedrock.packet.PlayerSkinPacket;
import com.nukkitx.protocol.bedrock.v361.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;

public class PlayerSkinSerializer_v361
implements PacketSerializer<PlayerSkinPacket> {
    public static final PlayerSkinSerializer_v361 INSTANCE = new PlayerSkinSerializer_v361();

    public void serialize(ByteBuf buffer, PlayerSkinPacket packet) {
        BedrockUtils.writeUuid(buffer, packet.getUuid());
        SerializedSkin skin = packet.getSkin();
        BedrockUtils.writeString(buffer, skin.getSkinId());
        BedrockUtils.writeString(buffer, "");
        BedrockUtils.writeString(buffer, "");
        skin.getSkinData().checkLegacySkinSize();
        BedrockUtils.writeByteArray(buffer, skin.getSkinData().getImage());
        skin.getCapeData().checkLegacyCapeSize();
        BedrockUtils.writeByteArray(buffer, skin.getCapeData().getImage());
        BedrockUtils.writeString(buffer, skin.getSkinResourcePatch());
        BedrockUtils.writeString(buffer, skin.getGeometryData());
        buffer.writeBoolean(skin.isPremium());
    }

    public void deserialize(ByteBuf buffer, PlayerSkinPacket packet) {
        packet.setUuid(BedrockUtils.readUuid(buffer));
        String skinId = BedrockUtils.readString(buffer);
        BedrockUtils.readString(buffer);
        BedrockUtils.readString(buffer);
        ImageData skinData = ImageData.of((byte[])BedrockUtils.readByteArray(buffer));
        ImageData capeData = ImageData.of((long)64L, (long)32L, (byte[])BedrockUtils.readByteArray(buffer));
        String geometryName = BedrockUtils.readString(buffer);
        String geometryData = BedrockUtils.readString(buffer);
        boolean premium = buffer.readBoolean();
        packet.setSkin(SerializedSkin.of((String)skinId, (ImageData)skinData, (ImageData)capeData, (String)geometryName, (String)geometryData, (boolean)premium));
    }

    private PlayerSkinSerializer_v361() {
    }
}

