/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v361.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.data.ImageData;
import com.nukkitx.protocol.bedrock.data.SerializedSkin;
import com.nukkitx.protocol.bedrock.packet.PlayerListPacket;
import com.nukkitx.protocol.bedrock.v361.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;

public class PlayerListSerializer_v361
implements PacketSerializer<PlayerListPacket> {
    public static final PlayerListSerializer_v361 INSTANCE = new PlayerListSerializer_v361();

    public void serialize(ByteBuf buffer, PlayerListPacket packet) {
        buffer.writeByte(packet.getType().ordinal());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)packet.getEntries().size());
        for (PlayerListPacket.Entry entry : packet.getEntries()) {
            BedrockUtils.writeUuid(buffer, entry.getUuid());
            if (packet.getType() != PlayerListPacket.Type.ADD) continue;
            VarInts.writeLong((ByteBuf)buffer, (long)entry.getEntityId());
            BedrockUtils.writeString(buffer, entry.getName());
            SerializedSkin skin = entry.getSkin();
            BedrockUtils.writeString(buffer, skin.getSkinId());
            skin.getSkinData().checkLegacySkinSize();
            BedrockUtils.writeByteArray(buffer, skin.getSkinData().getImage());
            skin.getCapeData().checkLegacyCapeSize();
            BedrockUtils.writeByteArray(buffer, skin.getCapeData().getImage());
            BedrockUtils.writeString(buffer, skin.getSkinResourcePatch());
            BedrockUtils.writeString(buffer, skin.getGeometryData());
            BedrockUtils.writeString(buffer, entry.getXuid());
            BedrockUtils.writeString(buffer, entry.getPlatformChatId());
        }
    }

    public void deserialize(ByteBuf buffer, PlayerListPacket packet) {
        PlayerListPacket.Type type = PlayerListPacket.Type.values()[buffer.readUnsignedByte()];
        packet.setType(type);
        int length = VarInts.readUnsignedInt((ByteBuf)buffer);
        for (int i = 0; i < length; ++i) {
            PlayerListPacket.Entry entry = new PlayerListPacket.Entry(BedrockUtils.readUuid(buffer));
            if (type == PlayerListPacket.Type.ADD) {
                entry.setEntityId(VarInts.readLong((ByteBuf)buffer));
                entry.setName(BedrockUtils.readString(buffer));
                String skinId = BedrockUtils.readString(buffer);
                ImageData skinData = ImageData.of((byte[])BedrockUtils.readByteArray(buffer));
                ImageData capeData = ImageData.of((long)64L, (long)32L, (byte[])BedrockUtils.readByteArray(buffer));
                String geometryName = BedrockUtils.readString(buffer);
                String geometryData = BedrockUtils.readString(buffer);
                entry.setSkin(SerializedSkin.of((String)skinId, (ImageData)skinData, (ImageData)capeData, (String)geometryName, (String)geometryData, (boolean)false));
                entry.setXuid(BedrockUtils.readString(buffer));
                entry.setPlatformChatId(BedrockUtils.readString(buffer));
            }
            packet.getEntries().add(entry);
        }
    }

    private PlayerListSerializer_v361() {
    }
}

