/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v361.serializer;

import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.packet.MoveEntityDeltaPacket;
import com.nukkitx.protocol.bedrock.v361.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;

public class MoveEntityDeltaSerializer_v361
implements PacketSerializer<MoveEntityDeltaPacket> {
    public static final MoveEntityDeltaSerializer_v361 INSTANCE = new MoveEntityDeltaSerializer_v361();
    private static final int HAS_X = 1;
    private static final int HAS_Y = 2;
    private static final int HAS_Z = 4;
    private static final int HAS_PITCH = 8;
    private static final int HAS_YAW = 16;
    private static final int HAS_ROLL = 32;

    public void serialize(ByteBuf buffer, MoveEntityDeltaPacket packet) {
        VarInts.writeUnsignedLong((ByteBuf)buffer, (long)packet.getRuntimeEntityId());
        byte flags = 0;
        Vector3i movementDelta = packet.getMovementDelta();
        Vector3f rotationDelta = packet.getRotationDelta();
        flags = (byte)(flags | (movementDelta.getX() != 0 ? 1 : 0));
        flags = (byte)(flags | (movementDelta.getY() != 0 ? 2 : 0));
        flags = (byte)(flags | (movementDelta.getZ() != 0 ? 4 : 0));
        flags = (byte)(flags | (rotationDelta.getX() != 0.0f ? 8 : 0));
        flags = (byte)(flags | (rotationDelta.getY() != 0.0f ? 16 : 0));
        flags = (byte)(flags | (rotationDelta.getZ() != 0.0f ? 32 : 0));
        buffer.writeByte((int)flags);
        if ((flags & 1) != 0) {
            VarInts.writeInt((ByteBuf)buffer, (int)movementDelta.getX());
        }
        if ((flags & 2) != 0) {
            VarInts.writeInt((ByteBuf)buffer, (int)movementDelta.getY());
        }
        if ((flags & 4) != 0) {
            VarInts.writeInt((ByteBuf)buffer, (int)movementDelta.getZ());
        }
        if ((flags & 8) != 0) {
            BedrockUtils.writeByteAngle(buffer, rotationDelta.getX());
        }
        if ((flags & 0x10) != 0) {
            BedrockUtils.writeByteAngle(buffer, rotationDelta.getY());
        }
        if ((flags & 0x20) != 0) {
            BedrockUtils.writeByteAngle(buffer, rotationDelta.getZ());
        }
    }

    public void deserialize(ByteBuf buffer, MoveEntityDeltaPacket packet) {
        packet.setRuntimeEntityId(VarInts.readUnsignedLong((ByteBuf)buffer));
        byte flags = buffer.readByte();
        int x = 0;
        int y = 0;
        int z = 0;
        float pitch = 0.0f;
        float yaw = 0.0f;
        float roll = 0.0f;
        if ((flags & 1) != 0) {
            x = VarInts.readInt((ByteBuf)buffer);
        }
        if ((flags & 2) != 0) {
            y = VarInts.readInt((ByteBuf)buffer);
        }
        if ((flags & 4) != 0) {
            z = VarInts.readInt((ByteBuf)buffer);
        }
        if ((flags & 8) != 0) {
            pitch = BedrockUtils.readByteAngle(buffer);
        }
        if ((flags & 0x10) != 0) {
            yaw = BedrockUtils.readByteAngle(buffer);
        }
        if ((flags & 0x20) != 0) {
            roll = BedrockUtils.readByteAngle(buffer);
        }
        packet.setMovementDelta(Vector3i.from((int)x, (int)y, (int)z));
        packet.setRotationDelta(Vector3f.from((float)pitch, (float)yaw, (float)roll));
    }

    private MoveEntityDeltaSerializer_v361() {
    }
}

