/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v361.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.packet.LevelChunkPacket;
import com.nukkitx.protocol.bedrock.v361.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import gnu.trove.list.TLongList;
import io.netty.buffer.ByteBuf;

public class LevelChunkSerializer_v361
implements PacketSerializer<LevelChunkPacket> {
    public static final LevelChunkSerializer_v361 INSTANCE = new LevelChunkSerializer_v361();

    public void serialize(ByteBuf buffer, LevelChunkPacket packet) {
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getChunkX());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getChunkZ());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)packet.getSubChunksLength());
        buffer.writeBoolean(packet.isCachingEnabled());
        if (packet.isCachingEnabled()) {
            TLongList blobIds = packet.getBlobIds();
            VarInts.writeUnsignedInt((ByteBuf)buffer, (long)blobIds.size());
            blobIds.forEach(blobId -> {
                buffer.writeLongLE(blobId);
                return true;
            });
        }
        BedrockUtils.writeByteArray(buffer, packet.getData());
    }

    public void deserialize(ByteBuf buffer, LevelChunkPacket packet) {
        packet.setChunkX(VarInts.readInt((ByteBuf)buffer));
        packet.setChunkZ(VarInts.readInt((ByteBuf)buffer));
        packet.setSubChunksLength(VarInts.readUnsignedInt((ByteBuf)buffer));
        packet.setCachingEnabled(buffer.readBoolean());
        if (packet.isCachingEnabled()) {
            TLongList blobIds = packet.getBlobIds();
            int length = VarInts.readUnsignedInt((ByteBuf)buffer);
            for (int i = 0; i < length; ++i) {
                blobIds.add(buffer.readLongLE());
            }
        }
        packet.setData(BedrockUtils.readByteArray(buffer));
    }

    private LevelChunkSerializer_v361() {
    }
}

