/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v361.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.packet.CommandOutputPacket;
import com.nukkitx.protocol.bedrock.v361.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;

public class CommandOutputSerializer_v361
implements PacketSerializer<CommandOutputPacket> {
    public static final CommandOutputSerializer_v361 INSTANCE = new CommandOutputSerializer_v361();

    public void serialize(ByteBuf buffer, CommandOutputPacket packet) {
        BedrockUtils.writeCommandOriginData(buffer, packet.getCommandOriginData());
        buffer.writeByte(packet.getOutputType());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)packet.getSuccessCount());
        BedrockUtils.writeArray(buffer, packet.getMessages(), BedrockUtils::writeCommandOutputMessage);
        if (packet.getOutputType() == 4) {
            BedrockUtils.writeString(buffer, packet.getData());
        }
    }

    public void deserialize(ByteBuf buffer, CommandOutputPacket packet) {
        packet.setCommandOriginData(BedrockUtils.readCommandOriginData(buffer));
        packet.setOutputType((int)buffer.readUnsignedByte());
        packet.setSuccessCount(VarInts.readUnsignedInt((ByteBuf)buffer));
        BedrockUtils.readArray(buffer, packet.getMessages(), BedrockUtils::readCommandOutputMessage);
        if (packet.getOutputType() == 4) {
            packet.setData(BedrockUtils.readString(buffer));
        }
    }

    private CommandOutputSerializer_v361() {
    }
}

