package com.nukkitx.protocol.bedrock.v361;

import com.nukkitx.protocol.bedrock.BedrockPacketCodec;
import com.nukkitx.protocol.bedrock.packet.*;
import com.nukkitx.protocol.bedrock.v361.serializer.*;
import lombok.experimental.UtilityClass;

@UtilityClass
public class Bedrock_v361 {
    public static BedrockPacketCodec V361_CODEC = BedrockPacketCodec.builder()
            .protocolVersion(361)
            .minecraftVersion("1.12.0")
            .headerSerializer(PacketHeaderSerializer_v361.INSTANCE)
            .registerPacket(LoginPacket.class, LoginSerializer_v361.INSTANCE, 1)
            .registerPacket(PlayStatusPacket.class, PlayStatusSerializer_v361.INSTANCE, 2)
            .registerPacket(ServerToClientHandshakePacket.class, ServerToClientHandshakeSerializer_v361.INSTANCE, 3)
            .registerPacket(ClientToServerHandshakePacket.class, ClientToServerHandshakeSerializer_v361.INSTANCE, 4)
            .registerPacket(DisconnectPacket.class, DisconnectSerializer_v361.INSTANCE, 5)
            .registerPacket(ResourcePacksInfoPacket.class, ResourcePacksInfoSerializer_v361.INSTANCE, 6)
            .registerPacket(ResourcePackStackPacket.class, ResourcePackStackSerializer_v361.INSTANCE, 7)
            .registerPacket(ResourcePackClientResponsePacket.class, ResourcePackClientResponseSerializer_v361.INSTANCE, 8)
            .registerPacket(TextPacket.class, TextSerializer_v361.INSTANCE, 9)
            .registerPacket(SetTimePacket.class, SetTimeSerializer_v361.INSTANCE, 10)
            .registerPacket(StartGamePacket.class, StartGameSerializer_v361.INSTANCE, 11)
            .registerPacket(AddPlayerPacket.class, AddPlayerSerializer_v361.INSTANCE, 12)
            .registerPacket(AddEntityPacket.class, AddEntitySerializer_v361.INSTANCE, 13)
            .registerPacket(RemoveEntityPacket.class, RemoveEntitySerializer_v361.INSTANCE, 14)
            .registerPacket(AddItemEntityPacket.class, AddItemEntitySerializer_v361.INSTANCE, 15)
            .registerPacket(TakeItemEntityPacket.class, TakeItemEntitySerializer_v361.INSTANCE, 17)
            .registerPacket(MoveEntityAbsolutePacket.class, MoveEntityAbsoluteSerializer_v361.INSTANCE, 18)
            .registerPacket(MovePlayerPacket.class, MovePlayerSerializer_v361.INSTANCE, 19)
            .registerPacket(RiderJumpPacket.class, RiderJumpSerializer_v361.INSTANCE, 20)
            .registerPacket(UpdateBlockPacket.class, UpdateBlockSerializer_v361.INSTANCE, 21)
            .registerPacket(AddPaintingPacket.class, AddPaintingSerializer_v361.INSTANCE, 22)
            .registerPacket(ExplodePacket.class, ExplodeSerializer_v361.INSTANCE, 23)
            .registerPacket(LevelSoundEventPacket.class, LevelSoundEventSerializer_v361.INSTANCE, 24)
            .registerPacket(LevelEventPacket.class, LevelEventSerializer_v361.INSTANCE, 25)
            .registerPacket(BlockEventPacket.class, BlockEventSerializer_v361.INSTANCE, 26)
            .registerPacket(EntityEventPacket.class, EntityEventSerializer_v361.INSTANCE, 27)
            .registerPacket(MobEffectPacket.class, MobEffectSerializer_v361.INSTANCE, 28)
            .registerPacket(UpdateAttributesPacket.class, UpdateAttributesSerializer_v361.INSTANCE, 29)
            .registerPacket(InventoryTransactionPacket.class, InventoryTransactionSerializer_v361.INSTANCE, 30)
            .registerPacket(MobEquipmentPacket.class, MobEquipmentSerializer_v361.INSTANCE, 31)
            .registerPacket(MobArmorEquipmentPacket.class, MobArmorEquipmentSerializer_v361.INSTANCE, 32)
            .registerPacket(InteractPacket.class, InteractSerializer_v361.INSTANCE, 33)
            .registerPacket(BlockPickRequestPacket.class, BlockPickRequestSerializer_v361.INSTANCE, 34)
            .registerPacket(EntityPickRequestPacket.class, EntityPickRequestSerializer_v361.INSTANCE, 35)
            .registerPacket(PlayerActionPacket.class, PlayerActionSerializer_v361.INSTANCE, 36)
            .registerPacket(EntityFallPacket.class, EntityFallSerializer_v361.INSTANCE, 37)
            .registerPacket(HurtArmorPacket.class, HurtArmorSerializer_v361.INSTANCE, 38)
            .registerPacket(SetEntityDataPacket.class, SetEntityDataSerializer_v361.INSTANCE, 39)
            .registerPacket(SetEntityMotionPacket.class, SetEntityMotionSerializer_v361.INSTANCE, 40)
            .registerPacket(SetEntityLinkPacket.class, SetEntityLinkSerializer_v361.INSTANCE, 41)
            .registerPacket(SetHealthPacket.class, SetHealthSerializer_v361.INSTANCE, 42)
            .registerPacket(SetSpawnPositionPacket.class, SetSpawnPositionSerializer_v361.INSTANCE, 43)
            .registerPacket(AnimatePacket.class, AnimateSerializer_v361.INSTANCE, 44)
            .registerPacket(RespawnPacket.class, RespawnSerializer_v361.INSTANCE, 45)
            .registerPacket(ContainerOpenPacket.class, ContainerOpenSerializer_v361.INSTANCE, 46)
            .registerPacket(ContainerClosePacket.class, ContainerCloseSerializer_v361.INSTANCE, 47)
            .registerPacket(PlayerHotbarPacket.class, PlayerHotbarSerializer_v361.INSTANCE, 48)
            .registerPacket(InventoryContentPacket.class, InventoryContentSerializer_v361.INSTANCE, 49)
            .registerPacket(InventorySlotPacket.class, InventorySlotSerializer_v361.INSTANCE, 50)
            .registerPacket(ContainerSetDataPacket.class, ContainerSetDataSerializer_v361.INSTANCE, 51)
            .registerPacket(CraftingDataPacket.class, CraftingDataSerializer_v361.INSTANCE, 52)
            .registerPacket(CraftingEventPacket.class, CraftingEventSerializer_v361.INSTANCE, 53)
            .registerPacket(GuiDataPickItemPacket.class, GuiDataPickItemSerializer_v361.INSTANCE, 54)
            .registerPacket(AdventureSettingsPacket.class, AdventureSettingsSerializer_v361.INSTANCE, 55)
            .registerPacket(BlockEntityDataPacket.class, BlockEntityDataSerializer_v361.INSTANCE, 56)
            .registerPacket(PlayerInputPacket.class, PlayerInputSerializer_v361.INSTANCE, 57)
            .registerPacket(LevelChunkPacket.class, LevelChunkSerializer_v361.INSTANCE, 58)
            .registerPacket(SetCommandsEnabledPacket.class, SetCommandsEnabledSerializer_v361.INSTANCE, 59)
            .registerPacket(SetDifficultyPacket.class, SetDifficultySerializer_v361.INSTANCE, 60)
            .registerPacket(ChangeDimensionPacket.class, ChangeDimensionSerializer_v361.INSTANCE, 61)
            .registerPacket(SetPlayerGameTypePacket.class, SetPlayerGameTypeSerializer_v361.INSTANCE, 62)
            .registerPacket(PlayerListPacket.class, PlayerListSerializer_v361.INSTANCE, 63)
            .registerPacket(SimpleEventPacket.class, SimpleEventSerializer_v361.INSTANCE, 64)
            .registerPacket(EventPacket.class, EventSerializer_v361.INSTANCE, 65)
            .registerPacket(SpawnExperienceOrbPacket.class, SpawnExperienceOrbSerializer_v361.INSTANCE, 66)
            .registerPacket(ClientboundMapItemDataPacket.class, ClientboundMapItemDataSerializer_v361.INSTANCE, 67)
            .registerPacket(MapInfoRequestPacket.class, MapInfoRequestSerializer_v361.INSTANCE, 68)
            .registerPacket(RequestChunkRadiusPacket.class, RequestChunkRadiusSerializer_v361.INSTANCE, 69)
            .registerPacket(ChunkRadiusUpdatedPacket.class, ChunkRadiusUpdatedSerializer_v361.INSTANCE, 70)
            .registerPacket(ItemFrameDropItemPacket.class, ItemFrameDropItemSerializer_v361.INSTANCE, 71)
            .registerPacket(GameRulesChangedPacket.class, GameRulesChangedSerializer_v361.INSTANCE, 72)
            .registerPacket(CameraPacket.class, CameraSerializer_v361.INSTANCE, 73)
            .registerPacket(BossEventPacket.class, BossEventSerializer_v361.INSTANCE, 74)
            .registerPacket(ShowCreditsPacket.class, ShowCreditsSerializer_v361.INSTANCE, 75)
            .registerPacket(AvailableCommandsPacket.class, AvailableCommandsSerializer_v361.INSTANCE, 76)
            .registerPacket(CommandRequestPacket.class, CommandRequestSerializer_v361.INSTANCE, 77)
            .registerPacket(CommandBlockUpdatePacket.class, CommandBlockUpdateSerializer_v361.INSTANCE, 78)
            .registerPacket(CommandOutputPacket.class, CommandOutputSerializer_v361.INSTANCE, 79)
            .registerPacket(UpdateTradePacket.class, UpdateTradeSerializer_v361.INSTANCE, 80)
            .registerPacket(UpdateEquipPacket.class, UpdateEquipSerializer_v361.INSTANCE, 81)
            .registerPacket(ResourcePackDataInfoPacket.class, ResourcePackDataInfoSerializer_v361.INSTANCE, 82)
            .registerPacket(ResourcePackChunkDataPacket.class, ResourcePackChunkDataSerializer_v361.INSTANCE, 83)
            .registerPacket(ResourcePackChunkRequestPacket.class, ResourcePackChunkRequestSerializer_v361.INSTANCE, 84)
            .registerPacket(TransferPacket.class, TransferSerializer_v361.INSTANCE, 85)
            .registerPacket(PlaySoundPacket.class, PlaySoundSerializer_v361.INSTANCE, 86)
            .registerPacket(StopSoundPacket.class, StopSoundSerializer_v361.INSTANCE, 87)
            .registerPacket(SetTitlePacket.class, SetTitleSerializer_v361.INSTANCE, 88)
            .registerPacket(AddBehaviorTreePacket.class, AddBehaviorTreeSerializer_v361.INSTANCE, 89)
            .registerPacket(StructureBlockUpdatePacket.class, StructureBlockUpdateSerializer_v361.INSTANCE, 90)
            .registerPacket(ShowStoreOfferPacket.class, ShowStoreOfferSerializer_v361.INSTANCE, 91)
            .registerPacket(PurchaseReceiptPacket.class, PurchaseReceiptSerializer_v361.INSTANCE, 92)
            .registerPacket(PlayerSkinPacket.class, PlayerSkinSerializer_v361.INSTANCE, 93)
            .registerPacket(SubClientLoginPacket.class, SubClientLoginSerializer_v361.INSTANCE, 94)
            .registerPacket(AutomationClientConnectPacket.class, AutomationClientConnectSerializer_v361.INSTANCE, 95)
            .registerPacket(SetLastHurtByPacket.class, SetLastHurtBySerializer_v361.INSTANCE, 96)
            .registerPacket(BookEditPacket.class, BookEditSerializer_v361.INSTANCE, 97)
            .registerPacket(NpcRequestPacket.class, NpcRequestSerializer_v361.INSTANCE, 98)
            .registerPacket(PhotoTransferPacket.class, PhotoTransferSerializer_v361.INSTANCE, 99)
            .registerPacket(ModalFormRequestPacket.class, ModalFormRequestSerializer_v361.INSTANCE, 100)
            .registerPacket(ModalFormResponsePacket.class, ModalFormResponseSerializer_v361.INSTANCE, 101)
            .registerPacket(ServerSettingsRequestPacket.class, ServerSettingsRequestSerializer_v361.INSTANCE, 102)
            .registerPacket(ServerSettingsResponsePacket.class, ServerSettingsResponseSerializer_v361.INSTANCE, 103)
            .registerPacket(ShowProfilePacket.class, ShowProfileSerializer_v361.INSTANCE, 104)
            .registerPacket(SetDefaultGameTypePacket.class, SetDefaultGameTypeSerializer_v361.INSTANCE, 105)
            .registerPacket(RemoveObjectivePacket.class, RemoveObjectiveSerializer_v361.INSTANCE, 106)
            .registerPacket(SetDisplayObjectivePacket.class, SetDisplayObjectiveSerializer_v361.INSTANCE, 107)
            .registerPacket(SetScorePacket.class, SetScoreSerializer_v361.INSTANCE, 108)
            .registerPacket(LabTablePacket.class, LabTableSerializer_v361.INSTANCE, 109)
            .registerPacket(UpdateBlockSyncedPacket.class, UpdateBlockSyncedSerializer_v361.INSTANCE, 110)
            .registerPacket(MoveEntityDeltaPacket.class, MoveEntityDeltaSerializer_v361.INSTANCE, 111)
            .registerPacket(SetScoreboardIdentityPacket.class, SetScoreboardIdentitySerializer_v361.INSTANCE, 112)
            .registerPacket(SetLocalPlayerAsInitializedPacket.class, SetLocalPlayerAsInitializedSerializer_v361.INSTANCE, 113)
            .registerPacket(UpdateSoftEnumPacket.class, UpdateSoftEnumSerializer_v361.INSTANCE, 114)
            .registerPacket(NetworkStackLatencyPacket.class, NetworkStackLatencySerializer_v361.INSTANCE, 115)
            .registerPacket(ScriptCustomEventPacket.class, ScriptCustomEventSerializer_v361.INSTANCE, 117)
            .registerPacket(SpawnParticleEffectPacket.class, SpawnParticleEffectSerializer_v361.INSTANCE, 118)
            .registerPacket(AvailableEntityIdentifiersPacket.class, AvailableEntityIdentifiersSerializer_v361.INSTANCE, 119)
            .registerPacket(LevelSoundEvent2Packet.class, LevelSoundEvent2Serializer_v361.INSTANCE, 120)
            .registerPacket(NetworkChunkPublisherUpdatePacket.class, NetworkChunkPublisherUpdateSerializer_v361.INSTANCE, 121)
            .registerPacket(BiomeDefinitionListPacket.class, BiomeDefinitionListSerializer_v361.INSTANCE, 122)
            .registerPacket(LevelSoundEvent3Packet.class, LevelSoundEvent3Serializer_v361.INSTANCE, 123)
            .registerPacket(LevelEventGenericPacket.class, LevelEventGenericSerializer_v361.INSTANCE, 124)
            .registerPacket(LecternUpdatePacket.class, LecternUpdateSerializer_v361.INSTANCE, 125)
            .registerPacket(VideoStreamConnectPacket.class, VideoStreamConnectSerializer_v361.INSTANCE, 126)
            // AddEntityPacket 127
            // RemoveEntityPacket 128
            .registerPacket(ClientCacheStatusPacket.class, ClientCacheStatusSerializer_v361.INSTANCE, 129)
            .registerPacket(OnScreenTextureAnimationPacket.class, OnScreenTextureAnimationSerializer_v361.INSTANCE, 130)
            .registerPacket(MapCreateLockedCopyPacket.class, MapCreateLockedCopySerializer_v361.INSTANCE, 131)
            .registerPacket(StructureTemplateDataExportRequestPacket.class, StructureTemplateDataExportRequestSerializer_v361.INSTANCE, 132)
            .registerPacket(StructureTemplateDataExportResponsePacket.class, StructureTemplateDataExportResponseSerializer_v361.INSTANCE, 133)
            .registerPacket(UpdateBlockPropertiesPacket.class, UpdateBlockPropertiesSerializer_v361.INSTANCE, 134)
            .registerPacket(ClientCacheBlobStatusPacket.class, ClientCacheBlobStatusSerializer_v361.INSTANCE, 135)
            .registerPacket(ClientCacheMissResponsePacket.class, ClientCacheMissResponseSerializer_v361.INSTANCE, 136)
            .build();
}
