/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v354.serializer;

import com.nukkitx.nbt.NbtUtils;
import com.nukkitx.nbt.stream.NBTInputStream;
import com.nukkitx.nbt.stream.NBTOutputStream;
import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.packet.UpdateTradePacket;
import com.nukkitx.protocol.bedrock.v354.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class UpdateTradeSerializer_v354
implements PacketSerializer<UpdateTradePacket> {
    public static final UpdateTradeSerializer_v354 INSTANCE = new UpdateTradeSerializer_v354();

    public void serialize(ByteBuf buffer, UpdateTradePacket packet) {
        buffer.writeByte((int)packet.getWindowId());
        buffer.writeByte((int)packet.getWindowType());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getUnknownInt());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getTradeTier());
        VarInts.writeLong((ByteBuf)buffer, (long)packet.getTraderUniqueEntityId());
        VarInts.writeLong((ByteBuf)buffer, (long)packet.getPlayerUniqueEntityId());
        BedrockUtils.writeString(buffer, packet.getDisplayName());
        buffer.writeBoolean(packet.isScreen2());
        buffer.writeBoolean(packet.isWilling());
        try (NBTOutputStream writer = NbtUtils.createNetworkWriter((OutputStream)new ByteBufOutputStream(buffer));){
            writer.write(packet.getOffers());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deserialize(ByteBuf buffer, UpdateTradePacket packet) {
        packet.setWindowId(buffer.readUnsignedByte());
        packet.setWindowType(buffer.readUnsignedByte());
        packet.setUnknownInt(VarInts.readInt((ByteBuf)buffer));
        packet.setTradeTier(VarInts.readInt((ByteBuf)buffer));
        packet.setWilling(buffer.readBoolean());
        packet.setTraderUniqueEntityId(VarInts.readLong((ByteBuf)buffer));
        packet.setPlayerUniqueEntityId(VarInts.readLong((ByteBuf)buffer));
        packet.setDisplayName(BedrockUtils.readString(buffer));
        packet.setScreen2(buffer.readBoolean());
        packet.setWilling(buffer.readBoolean());
        try (NBTInputStream reader = NbtUtils.createNetworkReader((InputStream)new ByteBufInputStream(buffer));){
            packet.setOffers(reader.readTag());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private UpdateTradeSerializer_v354() {
    }
}

