/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v354.serializer;

import com.nukkitx.protocol.bedrock.packet.ResourcePackDataInfoPacket;
import com.nukkitx.protocol.bedrock.v354.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;
import java.util.UUID;

public class ResourcePackDataInfoSerializer_v354
implements PacketSerializer<ResourcePackDataInfoPacket> {
    public static final ResourcePackDataInfoSerializer_v354 INSTANCE = new ResourcePackDataInfoSerializer_v354();

    public void serialize(ByteBuf buffer, ResourcePackDataInfoPacket packet) {
        String packInfo = packet.getPackId().toString() + (packet.getPackVersion() == null ? "" : '_' + packet.getPackVersion());
        BedrockUtils.writeString(buffer, packInfo);
        buffer.writeIntLE((int)packet.getMaxChunkSize());
        buffer.writeIntLE((int)packet.getChunkCount());
        buffer.writeLongLE(packet.getCompressedPackSize());
        BedrockUtils.writeByteArray(buffer, packet.getHash());
    }

    public void deserialize(ByteBuf buffer, ResourcePackDataInfoPacket packet) {
        String[] packInfo = BedrockUtils.readString(buffer).split("_");
        packet.setPackId(UUID.fromString(packInfo[0]));
        if (packInfo.length > 1) {
            packet.setPackVersion(packInfo[1]);
        }
        packet.setMaxChunkSize((long)buffer.readIntLE());
        packet.setChunkCount((long)buffer.readIntLE());
        packet.setCompressedPackSize(buffer.readLongLE());
        packet.setHash(BedrockUtils.readByteArray(buffer));
    }

    private ResourcePackDataInfoSerializer_v354() {
    }
}

