/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v354.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.data.ImageData;
import com.nukkitx.protocol.bedrock.data.SerializedSkin;
import com.nukkitx.protocol.bedrock.packet.PlayerListPacket;
import com.nukkitx.protocol.bedrock.v354.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;

public class PlayerListSerializer_v354
implements PacketSerializer<PlayerListPacket> {
    public static final PlayerListSerializer_v354 INSTANCE = new PlayerListSerializer_v354();

    public void serialize(ByteBuf buffer, PlayerListPacket packet) {
        buffer.writeByte(packet.getAction().ordinal());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)packet.getEntries().size());
        for (PlayerListPacket.Entry entry : packet.getEntries()) {
            BedrockUtils.writeUuid(buffer, entry.getUuid());
            if (packet.getAction() != PlayerListPacket.Action.ADD) continue;
            VarInts.writeLong((ByteBuf)buffer, (long)entry.getEntityId());
            BedrockUtils.writeString(buffer, entry.getName());
            SerializedSkin skin = entry.getSkin();
            BedrockUtils.writeString(buffer, skin.getSkinId());
            skin.getSkinData().checkLegacySkinSize();
            BedrockUtils.writeByteArray(buffer, skin.getSkinData().getImage());
            skin.getCapeData().checkLegacyCapeSize();
            BedrockUtils.writeByteArray(buffer, skin.getCapeData().getImage());
            BedrockUtils.writeString(buffer, skin.getGeometryName());
            BedrockUtils.writeString(buffer, skin.getGeometryData());
            BedrockUtils.writeString(buffer, entry.getXuid());
            BedrockUtils.writeString(buffer, entry.getPlatformChatId());
        }
    }

    public void deserialize(ByteBuf buffer, PlayerListPacket packet) {
        PlayerListPacket.Action action = PlayerListPacket.Action.values()[buffer.readUnsignedByte()];
        packet.setAction(action);
        int length = VarInts.readUnsignedInt((ByteBuf)buffer);
        for (int i = 0; i < length; ++i) {
            PlayerListPacket.Entry entry = new PlayerListPacket.Entry(BedrockUtils.readUuid(buffer));
            if (action == PlayerListPacket.Action.ADD) {
                entry.setEntityId(VarInts.readLong((ByteBuf)buffer));
                entry.setName(BedrockUtils.readString(buffer));
                String skinId = BedrockUtils.readString(buffer);
                ImageData skinData = ImageData.of((byte[])BedrockUtils.readByteArray(buffer));
                ImageData capeData = ImageData.of((int)64, (int)32, (byte[])BedrockUtils.readByteArray(buffer));
                String geometryName = BedrockUtils.readString(buffer);
                String geometryData = BedrockUtils.readString(buffer);
                entry.setSkin(SerializedSkin.of((String)skinId, (ImageData)skinData, (ImageData)capeData, (String)geometryName, (String)geometryData, (boolean)false));
                entry.setXuid(BedrockUtils.readString(buffer));
                entry.setPlatformChatId(BedrockUtils.readString(buffer));
            }
            packet.getEntries().add(entry);
        }
    }

    private PlayerListSerializer_v354() {
    }
}

