/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v354.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.data.ItemData;
import com.nukkitx.protocol.bedrock.packet.InventoryContentPacket;
import com.nukkitx.protocol.bedrock.v354.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;

public class InventoryContentSerializer_v354
implements PacketSerializer<InventoryContentPacket> {
    public static final InventoryContentSerializer_v354 INSTANCE = new InventoryContentSerializer_v354();

    public void serialize(ByteBuf buffer, InventoryContentPacket packet) {
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)packet.getContainerId());
        ItemData[] contents = packet.getContents();
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)contents.length);
        for (ItemData content : contents) {
            BedrockUtils.writeItemData(buffer, content);
        }
    }

    public void deserialize(ByteBuf buffer, InventoryContentPacket packet) {
        packet.setContainerId(VarInts.readUnsignedInt((ByteBuf)buffer));
        ItemData[] contents = new ItemData[VarInts.readUnsignedInt((ByteBuf)buffer)];
        for (int i = 0; i < contents.length; ++i) {
            contents[i] = BedrockUtils.readItemData(buffer);
        }
        packet.setContents(contents);
    }

    private InventoryContentSerializer_v354() {
    }
}

