/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v354.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.packet.InteractPacket;
import com.nukkitx.protocol.bedrock.v354.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;

public class InteractSerializer_v354
implements PacketSerializer<InteractPacket> {
    public static final InteractSerializer_v354 INSTANCE = new InteractSerializer_v354();
    private static final InteractPacket.Action[] ACTIONS = InteractPacket.Action.values();

    public void serialize(ByteBuf buffer, InteractPacket packet) {
        buffer.writeByte(packet.getAction().ordinal());
        VarInts.writeUnsignedLong((ByteBuf)buffer, (long)packet.getRuntimeEntityId());
        if (packet.getAction() == InteractPacket.Action.MOUSEOVER || packet.getAction() == InteractPacket.Action.NPC_OPEN) {
            BedrockUtils.writeVector3f(buffer, packet.getMousePosition());
        }
    }

    public void deserialize(ByteBuf buffer, InteractPacket packet) {
        packet.setAction(ACTIONS[buffer.readUnsignedByte()]);
        packet.setRuntimeEntityId(VarInts.readUnsignedLong((ByteBuf)buffer));
        if (packet.getAction() == InteractPacket.Action.MOUSEOVER || packet.getAction() == InteractPacket.Action.NPC_OPEN) {
            packet.setMousePosition(BedrockUtils.readVector3f(buffer));
        }
    }

    private InteractSerializer_v354() {
    }
}

