/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v354.serializer;

import com.nukkitx.nbt.CompoundTagBuilder;
import com.nukkitx.nbt.tag.CompoundTag;
import com.nukkitx.nbt.tag.ListTag;
import com.nukkitx.nbt.tag.Tag;
import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.data.GamePublishSetting;
import com.nukkitx.protocol.bedrock.data.PlayerPermission;
import com.nukkitx.protocol.bedrock.packet.StartGamePacket;
import com.nukkitx.protocol.bedrock.v354.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;

public class StartGameSerializer_v354
implements PacketSerializer<StartGamePacket> {
    public static final StartGameSerializer_v354 INSTANCE = new StartGameSerializer_v354();
    private static final PlayerPermission[] PLAYER_PERMISSIONS = PlayerPermission.values();

    public void serialize(ByteBuf buffer, StartGamePacket packet) {
        VarInts.writeLong((ByteBuf)buffer, (long)packet.getUniqueEntityId());
        VarInts.writeUnsignedLong((ByteBuf)buffer, (long)packet.getRuntimeEntityId());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getPlayerGamemode());
        BedrockUtils.writeVector3f(buffer, packet.getPlayerPosition());
        BedrockUtils.writeVector2f(buffer, packet.getRotation());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getSeed());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getDimensionId());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getGeneratorId());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getLevelGamemode());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getDifficulty());
        BedrockUtils.writeBlockPosition(buffer, packet.getDefaultSpawn());
        buffer.writeBoolean(packet.isAchievementsDisabled());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getTime());
        buffer.writeBoolean(packet.getEduEditionOffers() != 0);
        buffer.writeBoolean(packet.isEduFeaturesEnabled());
        buffer.writeFloatLE(packet.getRainLevel());
        buffer.writeFloatLE(packet.getLightningLevel());
        buffer.writeBoolean(packet.isPlatformLockedContentConfirmed());
        buffer.writeBoolean(packet.isMultiplayerGame());
        buffer.writeBoolean(packet.isBroadcastingToLan());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getXblBroadcastMode().ordinal());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getPlatformBroadcastMode().ordinal());
        buffer.writeBoolean(packet.isCommandsEnabled());
        buffer.writeBoolean(packet.isTexturePacksRequired());
        BedrockUtils.writeArray(buffer, packet.getGamerules(), BedrockUtils::writeGameRule);
        buffer.writeBoolean(packet.isBonusChestEnabled());
        buffer.writeBoolean(packet.isStartingWithMap());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getDefaultPlayerPermission().ordinal());
        buffer.writeIntLE(packet.getServerChunkTickRange());
        buffer.writeBoolean(packet.isBehaviorPackLocked());
        buffer.writeBoolean(packet.isResourcePackLocked());
        buffer.writeBoolean(packet.isFromLockedWorldTemplate());
        buffer.writeBoolean(packet.isUsingMsaGamertagsOnly());
        buffer.writeBoolean(packet.isFromWorldTemplate());
        buffer.writeBoolean(packet.isWorldTemplateOptionLocked());
        BedrockUtils.writeString(buffer, packet.getLevelId());
        BedrockUtils.writeString(buffer, packet.getWorldName());
        BedrockUtils.writeString(buffer, packet.getPremiumWorldTemplateId());
        buffer.writeBoolean(packet.isTrial());
        buffer.writeLongLE(packet.getCurrentTick());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getEnchantmentSeed());
        List palette = packet.getBlockPalette().getValue();
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)palette.size());
        for (CompoundTag entry : palette) {
            CompoundTag blockTag = entry.getCompound("block");
            BedrockUtils.writeString(buffer, blockTag.getString("name"));
            buffer.writeShortLE((int)entry.getShort("meta"));
        }
        BedrockUtils.writeString(buffer, packet.getMultiplayerCorrelationId());
    }

    public void deserialize(ByteBuf buffer, StartGamePacket packet) {
        packet.setUniqueEntityId(VarInts.readLong((ByteBuf)buffer));
        packet.setRuntimeEntityId(VarInts.readUnsignedLong((ByteBuf)buffer));
        packet.setPlayerGamemode(VarInts.readInt((ByteBuf)buffer));
        packet.setPlayerPosition(BedrockUtils.readVector3f(buffer));
        packet.setRotation(BedrockUtils.readVector2f(buffer));
        packet.setSeed(VarInts.readInt((ByteBuf)buffer));
        packet.setDimensionId(VarInts.readInt((ByteBuf)buffer));
        packet.setGeneratorId(VarInts.readInt((ByteBuf)buffer));
        packet.setLevelGamemode(VarInts.readInt((ByteBuf)buffer));
        packet.setDifficulty(VarInts.readInt((ByteBuf)buffer));
        packet.setDefaultSpawn(BedrockUtils.readBlockPosition(buffer));
        packet.setAchievementsDisabled(buffer.readBoolean());
        packet.setTime(VarInts.readInt((ByteBuf)buffer));
        packet.setEduEditionOffers(buffer.readBoolean() ? 1 : 0);
        packet.setEduFeaturesEnabled(buffer.readBoolean());
        packet.setRainLevel(buffer.readFloatLE());
        packet.setLightningLevel(buffer.readFloatLE());
        packet.setPlatformLockedContentConfirmed(buffer.readBoolean());
        packet.setMultiplayerGame(buffer.readBoolean());
        packet.setBroadcastingToLan(buffer.readBoolean());
        packet.setXblBroadcastMode(GamePublishSetting.byId((int)VarInts.readInt((ByteBuf)buffer)));
        packet.setPlatformBroadcastMode(GamePublishSetting.byId((int)VarInts.readInt((ByteBuf)buffer)));
        packet.setCommandsEnabled(buffer.readBoolean());
        packet.setTexturePacksRequired(buffer.readBoolean());
        BedrockUtils.readArray(buffer, packet.getGamerules(), BedrockUtils::readGameRule);
        packet.setBonusChestEnabled(buffer.readBoolean());
        packet.setStartingWithMap(buffer.readBoolean());
        packet.setDefaultPlayerPermission(PLAYER_PERMISSIONS[VarInts.readInt((ByteBuf)buffer)]);
        packet.setServerChunkTickRange(buffer.readIntLE());
        packet.setBehaviorPackLocked(buffer.readBoolean());
        packet.setResourcePackLocked(buffer.readBoolean());
        packet.setFromLockedWorldTemplate(buffer.readBoolean());
        packet.setUsingMsaGamertagsOnly(buffer.readBoolean());
        packet.setFromWorldTemplate(buffer.readBoolean());
        packet.setWorldTemplateOptionLocked(buffer.readBoolean());
        packet.setLevelId(BedrockUtils.readString(buffer));
        packet.setWorldName(BedrockUtils.readString(buffer));
        packet.setPremiumWorldTemplateId(BedrockUtils.readString(buffer));
        packet.setTrial(buffer.readBoolean());
        packet.setCurrentTick(buffer.readLongLE());
        packet.setEnchantmentSeed(VarInts.readInt((ByteBuf)buffer));
        int paletteLength = VarInts.readUnsignedInt((ByteBuf)buffer);
        ObjectArrayList palette = new ObjectArrayList(paletteLength);
        for (int i = 0; i < paletteLength; ++i) {
            palette.add(CompoundTagBuilder.builder().tag((Tag)CompoundTagBuilder.builder().stringTag("name", BedrockUtils.readString(buffer)).build("block")).shortTag("meta", buffer.readShortLE()).buildRootTag());
        }
        packet.setBlockPalette(new ListTag("", CompoundTag.class, (List)palette));
        packet.setMultiplayerCorrelationId(BedrockUtils.readString(buffer));
    }

    private StartGameSerializer_v354() {
    }
}

