/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v354.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.data.EntityEventType;
import com.nukkitx.protocol.bedrock.packet.EntityEventPacket;
import com.nukkitx.protocol.serializer.PacketSerializer;
import com.nukkitx.protocol.util.Int2ObjectBiMap;
import io.netty.buffer.ByteBuf;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class EntityEventSerializer_v354
implements PacketSerializer<EntityEventPacket> {
    public static final EntityEventSerializer_v354 INSTANCE = new EntityEventSerializer_v354();
    private static final Int2ObjectBiMap<EntityEventType> events = new Int2ObjectBiMap();
    private static final InternalLogger log = InternalLoggerFactory.getInstance(EntityEventSerializer_v354.class);

    public void serialize(ByteBuf buffer, EntityEventPacket packet) {
        VarInts.writeUnsignedLong((ByteBuf)buffer, (long)packet.getRuntimeEntityId());
        buffer.writeByte(events.get((Object)packet.getType()));
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getData());
    }

    public void deserialize(ByteBuf buffer, EntityEventPacket packet) {
        packet.setRuntimeEntityId(VarInts.readUnsignedLong((ByteBuf)buffer));
        short event = buffer.readUnsignedByte();
        packet.setType((EntityEventType)events.get((int)event));
        packet.setData(VarInts.readInt((ByteBuf)buffer));
        if (packet.getType() == null) {
            log.debug("Unknown EntityEvent {} in packet {}", (Object)event, (Object)packet);
        }
    }

    private EntityEventSerializer_v354() {
    }

    static {
        events.put(2, (Object)EntityEventType.HURT_ANIMATION);
        events.put(3, (Object)EntityEventType.DEATH_ANIMATION);
        events.put(4, (Object)EntityEventType.ARM_SWING);
        events.put(6, (Object)EntityEventType.TAME_FAIL);
        events.put(7, (Object)EntityEventType.TAME_SUCCESS);
        events.put(8, (Object)EntityEventType.SHAKE_WET);
        events.put(9, (Object)EntityEventType.USE_ITEM);
        events.put(10, (Object)EntityEventType.EAT_BLOCK_ANIMATION);
        events.put(11, (Object)EntityEventType.FISH_HOOK_BUBBLE);
        events.put(12, (Object)EntityEventType.FISH_HOOK_POSITION);
        events.put(13, (Object)EntityEventType.FISH_HOOK_HOOK);
        events.put(14, (Object)EntityEventType.FISH_HOOK_LURED);
        events.put(15, (Object)EntityEventType.SQUID_INK_CLOUD);
        events.put(16, (Object)EntityEventType.ZOMBIE_VILLAGER_CURE);
        events.put(18, (Object)EntityEventType.RESPAWN);
        events.put(19, (Object)EntityEventType.IRON_GOLEM_OFFER_FLOWER);
        events.put(20, (Object)EntityEventType.IRON_GOLEM_WITHDRAW_FLOWER);
        events.put(21, (Object)EntityEventType.LOVE_PARTICLES);
        events.put(22, (Object)EntityEventType.VILLAGER_HURT);
        events.put(23, (Object)EntityEventType.VILLAGER_STOP_TRADING);
        events.put(24, (Object)EntityEventType.WITCH_SPELL_PARTICLES);
        events.put(25, (Object)EntityEventType.FIREWORK_PARTICLES);
        events.put(27, (Object)EntityEventType.SILVERFISH_MERGE_WITH_STONE);
        events.put(28, (Object)EntityEventType.GUARDIAN_ATTACK_ANIMATION);
        events.put(29, (Object)EntityEventType.WITCH_DRINK_POTION);
        events.put(30, (Object)EntityEventType.WITCH_THROW_POTION);
        events.put(31, (Object)EntityEventType.MINECART_TNT_PRIME_FUSE);
        events.put(34, (Object)EntityEventType.PLAYER_ADD_XP_LEVELS);
        events.put(35, (Object)EntityEventType.ELDER_GUARDIAN_CURSE);
        events.put(36, (Object)EntityEventType.AGENT_ARM_SWING);
        events.put(37, (Object)EntityEventType.ENDER_DRAGON_DEATH);
        events.put(38, (Object)EntityEventType.DUST_PARTICLES);
        events.put(39, (Object)EntityEventType.ARROW_SHAKE);
        events.put(57, (Object)EntityEventType.EATING_ITEM);
        events.put(60, (Object)EntityEventType.BABY_ANIMAL_FEED);
        events.put(61, (Object)EntityEventType.DEATH_SMOKE_CLOUD);
        events.put(62, (Object)EntityEventType.COMPLETE_TRADE);
        events.put(63, (Object)EntityEventType.REMOVE_LEASH);
        events.put(64, (Object)EntityEventType.CARAVAN);
        events.put(65, (Object)EntityEventType.CONSUME_TOTEM);
        events.put(66, (Object)EntityEventType.CHECK_TREASURE_HUNTER_ACHIEVEMENT);
        events.put(67, (Object)EntityEventType.ENTITY_SPAWN);
        events.put(68, (Object)EntityEventType.DRAGON_FLAMING);
        events.put(69, (Object)EntityEventType.MERGE_ITEMS);
        events.put(71, (Object)EntityEventType.BALLOON_POP);
        events.put(72, (Object)EntityEventType.FIND_TREASURE_BRIBE);
    }
}

