/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v354.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.network.util.Preconditions;
import com.nukkitx.protocol.bedrock.data.CommandData;
import com.nukkitx.protocol.bedrock.data.CommandEnumData;
import com.nukkitx.protocol.bedrock.data.CommandParamData;
import com.nukkitx.protocol.bedrock.data.CommandParamType;
import com.nukkitx.protocol.bedrock.packet.AvailableCommandsPacket;
import com.nukkitx.protocol.bedrock.v354.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import com.nukkitx.protocol.util.Int2ObjectBiMap;
import io.netty.buffer.ByteBuf;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.ObjIntConsumer;
import java.util.function.ToIntFunction;

public class AvailableCommandsSerializer_v354
implements PacketSerializer<AvailableCommandsPacket> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(AvailableCommandsSerializer_v354.class);
    public static final AvailableCommandsSerializer_v354 INSTANCE = new AvailableCommandsSerializer_v354();
    private static final ObjIntConsumer<ByteBuf> WRITE_BYTE = ByteBuf::writeByte;
    private static final ObjIntConsumer<ByteBuf> WRITE_SHORT = ByteBuf::writeShortLE;
    private static final ObjIntConsumer<ByteBuf> WRITE_INT = ByteBuf::writeIntLE;
    private static final ToIntFunction<ByteBuf> READ_BYTE = ByteBuf::readUnsignedByte;
    private static final ToIntFunction<ByteBuf> READ_SHORT = ByteBuf::readUnsignedShortLE;
    private static final ToIntFunction<ByteBuf> READ_INT = ByteBuf::readIntLE;
    private static final Int2ObjectBiMap<CommandParamData.Type> PARAM_TYPES = new Int2ObjectBiMap();

    public void serialize(ByteBuf buffer, AvailableCommandsPacket packet) {
        ObjectOpenHashSet enumValuesSet = new ObjectOpenHashSet();
        ObjectOpenHashSet postfixSet = new ObjectOpenHashSet();
        ObjectOpenHashSet enumsSet = new ObjectOpenHashSet();
        ObjectOpenHashSet softEnumsSet = new ObjectOpenHashSet();
        for (CommandData data : packet.getCommands()) {
            if (data.getAliases() != null) {
                Collections.addAll(enumValuesSet, data.getAliases().getValues());
                enumsSet.add(data.getAliases());
            }
            CommandParamData[][] commandParamDataArray = data.getOverloads();
            int n = commandParamDataArray.length;
            for (int i = 0; i < n; ++i) {
                CommandParamData[] overload;
                for (CommandParamData parameter : overload = commandParamDataArray[i]) {
                    String postfix;
                    CommandEnumData commandEnumData = parameter.getEnumData();
                    if (commandEnumData != null) {
                        if (commandEnumData.isSoft()) {
                            softEnumsSet.add(commandEnumData);
                        } else {
                            Collections.addAll(enumValuesSet, commandEnumData.getValues());
                            enumsSet.add(commandEnumData);
                        }
                    }
                    if ((postfix = parameter.getPostfix()) == null) continue;
                    postfixSet.add(postfix);
                }
            }
        }
        ObjectArrayList enumValues = new ObjectArrayList((Collection)enumValuesSet);
        ObjectArrayList postFixes = new ObjectArrayList((Collection)postfixSet);
        ObjectArrayList enums = new ObjectArrayList((Collection)enumsSet);
        ObjectArrayList softEnums = new ObjectArrayList((Collection)softEnumsSet);
        int valuesSize = enumValues.size();
        ObjIntConsumer<ByteBuf> indexWriter = valuesSize < 256 ? WRITE_BYTE : (valuesSize < 65536 ? WRITE_SHORT : WRITE_INT);
        BedrockUtils.writeArray(buffer, enumValues, BedrockUtils::writeString);
        BedrockUtils.writeArray(buffer, postFixes, BedrockUtils::writeString);
        BedrockUtils.writeArray(buffer, enums, (arg_0, arg_1) -> AvailableCommandsSerializer_v354.lambda$serialize$0(buffer, (List)enumValues, indexWriter, arg_0, arg_1));
        BedrockUtils.writeArray(buffer, packet.getCommands(), (arg_0, arg_1) -> AvailableCommandsSerializer_v354.lambda$serialize$1((List)enums, (List)postFixes, (List)softEnums, arg_0, arg_1));
        BedrockUtils.writeArray(buffer, softEnums, BedrockUtils::writeCommandEnumData);
    }

    public void deserialize(ByteBuf buffer, AvailableCommandsPacket packet) {
        ObjectArrayList enumValues = new ObjectArrayList();
        ObjectArrayList postFixes = new ObjectArrayList();
        ObjectArrayList enums = new ObjectArrayList();
        ObjectArrayList commands = new ObjectArrayList();
        ObjectArrayList softEnums = new ObjectArrayList();
        BedrockUtils.readArray(buffer, enumValues, BedrockUtils::readString);
        BedrockUtils.readArray(buffer, postFixes, BedrockUtils::readString);
        int valuesSize = enumValues.size();
        ToIntFunction<ByteBuf> indexReader = valuesSize < 256 ? READ_BYTE : (valuesSize < 65536 ? READ_SHORT : READ_INT);
        BedrockUtils.readArray(buffer, enums, arg_0 -> AvailableCommandsSerializer_v354.lambda$deserialize$2(buffer, (List)enumValues, indexReader, arg_0));
        BedrockUtils.readArray(buffer, commands, buf -> {
            String name = BedrockUtils.readString(buf);
            String description = BedrockUtils.readString(buf);
            byte flags = buf.readByte();
            byte permissions = buf.readByte();
            int aliasesIndex = buf.readIntLE();
            CommandParamData.Builder[][] overloads = new CommandParamData.Builder[VarInts.readUnsignedInt((ByteBuf)buf)][];
            for (int i = 0; i < overloads.length; ++i) {
                overloads[i] = new CommandParamData.Builder[VarInts.readUnsignedInt((ByteBuf)buf)];
                for (int i2 = 0; i2 < overloads[i].length; ++i2) {
                    String parameterName = BedrockUtils.readString(buf);
                    CommandParamType type = CommandParamType.deserialize((int)buf.readIntLE());
                    boolean optional = buf.readBoolean();
                    byte options = buf.readByte();
                    overloads[i][i2] = new CommandParamData.Builder(parameterName, type, optional, options);
                }
            }
            return new CommandData.Builder(name, description, flags, permissions, aliasesIndex, (CommandParamData.Builder[][])overloads);
        });
        BedrockUtils.readArray(buffer, softEnums, buf -> BedrockUtils.readCommandEnumData(buffer, true));
        for (CommandData.Builder command : commands) {
            byte flagsByte = command.getFlags();
            ObjectArrayList flags = new ObjectArrayList();
            for (int i = 0; i < 8; ++i) {
                if ((flagsByte >>> i & 0xF) == 0) continue;
                flags.add(CommandData.Flag.values()[i]);
            }
            int aliasesIndex = command.getAliases();
            CommandEnumData aliases = aliasesIndex == -1 ? null : (CommandEnumData)enums.get(aliasesIndex);
            CommandParamData.Builder[][] overloadBuilders = command.getOverloads();
            CommandParamData[][] overloads = new CommandParamData[overloadBuilders.length][];
            for (int i = 0; i < overloadBuilders.length; ++i) {
                overloads[i] = new CommandParamData[overloadBuilders[i].length];
                for (int i2 = 0; i2 < overloadBuilders[i].length; ++i2) {
                    String name = overloadBuilders[i][i2].getName();
                    CommandParamType type = overloadBuilders[i][i2].getType();
                    boolean optional = overloadBuilders[i][i2].isOptional();
                    byte optionsByte = overloadBuilders[i][i2].getOptions();
                    ObjectArrayList options = new ObjectArrayList();
                    for (int oi = 0; oi < 8; ++oi) {
                        if ((optionsByte >>> oi & 0xF) == 0) continue;
                        options.add(CommandParamData.Option.values()[oi]);
                    }
                    String postfix = null;
                    CommandEnumData enumData = null;
                    CommandParamData.Type paramType = null;
                    if (type.isPostfix()) {
                        postfix = (String)postFixes.get(type.getValue());
                    } else if (type.isCommandEnum()) {
                        enumData = (CommandEnumData)enums.get(type.getValue());
                    } else if (type.isSoftEnum()) {
                        enumData = (CommandEnumData)softEnums.get(type.getValue());
                    } else {
                        paramType = (CommandParamData.Type)PARAM_TYPES.get(type.getValue());
                        if (paramType == null) {
                            log.debug("Unknown parameter type {} from {} in {}", new Object[]{type.getValue(), name, command.getName()});
                        }
                    }
                    overloads[i][i2] = new CommandParamData(name, optional, enumData, paramType, postfix, (List)options);
                }
            }
            packet.getCommands().add(new CommandData(command.getName(), command.getDescription(), (List)flags, command.getPermission(), aliases, (CommandParamData[][])overloads));
        }
    }

    private AvailableCommandsSerializer_v354() {
    }

    private static /* synthetic */ CommandEnumData lambda$deserialize$2(ByteBuf buffer, List enumValues, ToIntFunction indexReader, ByteBuf buf) {
        String name = BedrockUtils.readString(buf);
        int length = VarInts.readUnsignedInt((ByteBuf)buffer);
        String[] values = new String[length];
        for (int i = 0; i < length; ++i) {
            values[i] = (String)enumValues.get(indexReader.applyAsInt(buf));
        }
        return new CommandEnumData(name, values, false);
    }

    private static /* synthetic */ void lambda$serialize$1(List enums, List postFixes, List softEnums, ByteBuf buf, CommandData commandData) {
        BedrockUtils.writeString(buf, commandData.getName());
        BedrockUtils.writeString(buf, commandData.getDescription());
        int flags = 0;
        if (commandData.getFlags() != null) {
            for (CommandData.Flag flag : commandData.getFlags()) {
                flags = (byte)(flags | 1 << flag.ordinal());
            }
        }
        buf.writeByte(flags);
        buf.writeByte((int)commandData.getPermission());
        CommandEnumData aliases = commandData.getAliases();
        buf.writeIntLE(enums.indexOf(aliases));
        CommandParamData[][] overloads = commandData.getOverloads();
        VarInts.writeUnsignedInt((ByteBuf)buf, (long)overloads.length);
        for (CommandParamData[] overload : overloads) {
            VarInts.writeUnsignedInt((ByteBuf)buf, (long)overload.length);
            for (CommandParamData param : overload) {
                int index;
                BedrockUtils.writeString(buf, param.getName());
                boolean postfix = false;
                boolean enumData = false;
                boolean softEnum = false;
                if (param.getPostfix() != null) {
                    postfix = true;
                    index = postFixes.indexOf(param.getPostfix());
                } else if (param.getEnumData() != null) {
                    if (param.getEnumData().isSoft()) {
                        softEnum = true;
                        index = softEnums.indexOf(param.getEnumData());
                    } else {
                        enumData = true;
                        index = enums.indexOf(param.getEnumData());
                    }
                } else if (param.getType() != null) {
                    index = PARAM_TYPES.get((Object)param.getType());
                } else {
                    throw new IllegalStateException("No param type specified");
                }
                CommandParamType type = new CommandParamType(index, enumData, softEnum, postfix);
                buf.writeIntLE(type.serialize());
                buf.writeBoolean(param.isOptional());
                int options = 0;
                if (param.getOptions() != null) {
                    for (CommandParamData.Option opt : param.getOptions()) {
                        options = (byte)(options | 1 << opt.ordinal());
                    }
                }
                buf.writeByte(options);
            }
        }
    }

    private static /* synthetic */ void lambda$serialize$0(ByteBuf buffer, List enumValues, ObjIntConsumer indexWriter, ByteBuf buf, CommandEnumData commandEnum) {
        BedrockUtils.writeString(buf, commandEnum.getName());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)commandEnum.getValues().length);
        for (String value : commandEnum.getValues()) {
            int index = enumValues.indexOf(value);
            Preconditions.checkArgument((index > -1 ? 1 : 0) != 0, (Object)"Invalid enum value detected");
            indexWriter.accept(buf, index);
        }
    }

    static {
        PARAM_TYPES.put(1, (Object)CommandParamData.Type.INT);
        PARAM_TYPES.put(2, (Object)CommandParamData.Type.FLOAT);
        PARAM_TYPES.put(3, (Object)CommandParamData.Type.VALUE);
        PARAM_TYPES.put(4, (Object)CommandParamData.Type.WILDCARD_INT);
        PARAM_TYPES.put(5, (Object)CommandParamData.Type.OPERATOR);
        PARAM_TYPES.put(6, (Object)CommandParamData.Type.TARGET);
        PARAM_TYPES.put(7, (Object)CommandParamData.Type.WILDCARD_TARGET);
        PARAM_TYPES.put(14, (Object)CommandParamData.Type.FILE_PATH);
        PARAM_TYPES.put(18, (Object)CommandParamData.Type.INT_RANGE);
        PARAM_TYPES.put(27, (Object)CommandParamData.Type.STRING);
        PARAM_TYPES.put(29, (Object)CommandParamData.Type.POSITION);
        PARAM_TYPES.put(32, (Object)CommandParamData.Type.MESSAGE);
        PARAM_TYPES.put(34, (Object)CommandParamData.Type.TEXT);
        PARAM_TYPES.put(37, (Object)CommandParamData.Type.JSON);
        PARAM_TYPES.put(44, (Object)CommandParamData.Type.COMMAND);
    }
}

