/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v354.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.data.CommandPermission;
import com.nukkitx.protocol.bedrock.data.PlayerPermission;
import com.nukkitx.protocol.bedrock.packet.AdventureSettingsPacket;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Set;

public class AdventureSettingsSerializer_v354
implements PacketSerializer<AdventureSettingsPacket> {
    public static final AdventureSettingsSerializer_v354 INSTANCE = new AdventureSettingsSerializer_v354();
    private static final CommandPermission[] COMMAND_PERMISSIONS = CommandPermission.values();
    private static final PlayerPermission[] PLAYER_PERMISSIONS = PlayerPermission.values();
    private static final AdventureSettingsPacket.Flag[] FLAGS_1 = new AdventureSettingsPacket.Flag[]{AdventureSettingsPacket.Flag.IMMUTABLE_WORLD, AdventureSettingsPacket.Flag.NO_PVP, AdventureSettingsPacket.Flag.NO_PVM, null, AdventureSettingsPacket.Flag.NO_MVP, AdventureSettingsPacket.Flag.AUTO_JUMP, AdventureSettingsPacket.Flag.MAY_FLY, AdventureSettingsPacket.Flag.NO_CLIP, AdventureSettingsPacket.Flag.WORLD_BUILDER, AdventureSettingsPacket.Flag.FLYING, AdventureSettingsPacket.Flag.MUTE};
    private static final AdventureSettingsPacket.Flag[] FLAGS_2 = new AdventureSettingsPacket.Flag[]{AdventureSettingsPacket.Flag.MINE, AdventureSettingsPacket.Flag.DOORS_AND_SWITCHES, AdventureSettingsPacket.Flag.OPEN_CONTAINERS, AdventureSettingsPacket.Flag.ATTACK_PLAYERS, AdventureSettingsPacket.Flag.ATTACK_MOBS, AdventureSettingsPacket.Flag.OP, null, AdventureSettingsPacket.Flag.TELEPORT, AdventureSettingsPacket.Flag.BUILD, AdventureSettingsPacket.Flag.SET_DEFAULT};
    private static final Object2IntMap<AdventureSettingsPacket.Flag> FLAGS_TO_BIT_1 = new Object2IntOpenHashMap();
    private static final Object2IntMap<AdventureSettingsPacket.Flag> FLAGS_TO_BIT_2 = new Object2IntOpenHashMap();

    public void serialize(ByteBuf buffer, AdventureSettingsPacket packet) {
        int flags1 = 0;
        int flags2 = 0;
        for (AdventureSettingsPacket.Flag flag : packet.getFlags()) {
            if (FLAGS_TO_BIT_1.containsKey((Object)flag)) {
                flags1 |= FLAGS_TO_BIT_1.get((Object)flag).intValue();
                continue;
            }
            if (!FLAGS_TO_BIT_2.containsKey((Object)flag)) continue;
            flags2 |= FLAGS_TO_BIT_2.get((Object)flag).intValue();
        }
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)flags1);
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)packet.getCommandPermission().ordinal());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)flags2);
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)packet.getPlayerPermission().ordinal());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)0L);
        buffer.writeLongLE(packet.getUniqueEntityId());
    }

    public void deserialize(ByteBuf buffer, AdventureSettingsPacket packet) {
        int i;
        int flags1 = VarInts.readUnsignedInt((ByteBuf)buffer);
        packet.setCommandPermission(COMMAND_PERMISSIONS[VarInts.readUnsignedInt((ByteBuf)buffer)]);
        int flags2 = VarInts.readUnsignedInt((ByteBuf)buffer);
        packet.setPlayerPermission(PLAYER_PERMISSIONS[VarInts.readUnsignedInt((ByteBuf)buffer)]);
        VarInts.readUnsignedInt((ByteBuf)buffer);
        packet.setUniqueEntityId(buffer.readLongLE());
        Set flags = packet.getFlags();
        for (i = 0; i < FLAGS_1.length; ++i) {
            if ((flags1 & 1 << i) == 0) continue;
            flags.add(FLAGS_1[i]);
        }
        for (i = 0; i < FLAGS_2.length; ++i) {
            if ((flags2 & 1 << i) == 0) continue;
            flags.add(FLAGS_2[i]);
        }
    }

    private AdventureSettingsSerializer_v354() {
    }

    static {
        FLAGS_TO_BIT_1.put((Object)AdventureSettingsPacket.Flag.IMMUTABLE_WORLD, 1);
        FLAGS_TO_BIT_1.put((Object)AdventureSettingsPacket.Flag.NO_PVP, 2);
        FLAGS_TO_BIT_1.put((Object)AdventureSettingsPacket.Flag.NO_PVM, 4);
        FLAGS_TO_BIT_1.put((Object)AdventureSettingsPacket.Flag.NO_MVP, 16);
        FLAGS_TO_BIT_1.put((Object)AdventureSettingsPacket.Flag.AUTO_JUMP, 32);
        FLAGS_TO_BIT_1.put((Object)AdventureSettingsPacket.Flag.MAY_FLY, 64);
        FLAGS_TO_BIT_1.put((Object)AdventureSettingsPacket.Flag.NO_CLIP, 128);
        FLAGS_TO_BIT_1.put((Object)AdventureSettingsPacket.Flag.WORLD_BUILDER, 256);
        FLAGS_TO_BIT_1.put((Object)AdventureSettingsPacket.Flag.FLYING, 512);
        FLAGS_TO_BIT_1.put((Object)AdventureSettingsPacket.Flag.MUTE, 1024);
        FLAGS_TO_BIT_2.put((Object)AdventureSettingsPacket.Flag.MINE, 1);
        FLAGS_TO_BIT_2.put((Object)AdventureSettingsPacket.Flag.DOORS_AND_SWITCHES, 2);
        FLAGS_TO_BIT_2.put((Object)AdventureSettingsPacket.Flag.OPEN_CONTAINERS, 4);
        FLAGS_TO_BIT_2.put((Object)AdventureSettingsPacket.Flag.ATTACK_PLAYERS, 8);
        FLAGS_TO_BIT_2.put((Object)AdventureSettingsPacket.Flag.ATTACK_MOBS, 16);
        FLAGS_TO_BIT_2.put((Object)AdventureSettingsPacket.Flag.OP, 32);
        FLAGS_TO_BIT_2.put((Object)AdventureSettingsPacket.Flag.TELEPORT, 128);
        FLAGS_TO_BIT_2.put((Object)AdventureSettingsPacket.Flag.BUILD, 256);
        FLAGS_TO_BIT_2.put((Object)AdventureSettingsPacket.Flag.SET_DEFAULT, 512);
    }
}

