package com.nukkitx.protocol.bedrock.v354;

import com.nukkitx.protocol.bedrock.BedrockPacketCodec;
import com.nukkitx.protocol.bedrock.packet.*;
import com.nukkitx.protocol.bedrock.v354.serializer.*;
import lombok.experimental.UtilityClass;

@UtilityClass
public class Bedrock_v354 {
    public static BedrockPacketCodec V354_CODEC = BedrockPacketCodec.builder()
            .protocolVersion(354)
            .minecraftVersion("1.11.0")
            .headerSerializer(PacketHeaderSerializer_v354.INSTANCE)
            .registerPacket(LoginPacket.class, LoginSerializer_v354.INSTANCE, 1)
            .registerPacket(PlayStatusPacket.class, PlayStatusSerializer_v354.INSTANCE, 2)
            .registerPacket(ServerToClientHandshakePacket.class, ServerToClientHandshakeSerializer_v354.INSTANCE, 3)
            .registerPacket(ClientToServerHandshakePacket.class, ClientToServerHandshakeSerializer_v354.INSTANCE, 4)
            .registerPacket(DisconnectPacket.class, DisconnectSerializer_v354.INSTANCE, 5)
            .registerPacket(ResourcePacksInfoPacket.class, ResourcePacksInfoSerializer_v354.INSTANCE, 6)
            .registerPacket(ResourcePackStackPacket.class, ResourcePackStackSerializer_v354.INSTANCE, 7)
            .registerPacket(ResourcePackClientResponsePacket.class, ResourcePackClientResponseSerializer_v354.INSTANCE, 8)
            .registerPacket(TextPacket.class, TextSerializer_v354.INSTANCE, 9)
            .registerPacket(SetTimePacket.class, SetTimeSerializer_v354.INSTANCE, 10)
            .registerPacket(StartGamePacket.class, StartGameSerializer_v354.INSTANCE, 11)
            .registerPacket(AddPlayerPacket.class, AddPlayerSerializer_v354.INSTANCE, 12)
            .registerPacket(AddEntityPacket.class, AddEntitySerializer_v354.INSTANCE, 13)
            .registerPacket(RemoveEntityPacket.class, RemoveEntitySerializer_v354.INSTANCE, 14)
            .registerPacket(AddItemEntityPacket.class, AddItemEntitySerializer_v354.INSTANCE, 15)
            .registerPacket(TakeItemEntityPacket.class, TakeItemEntitySerializer_v354.INSTANCE, 17)
            .registerPacket(MoveEntityAbsolutePacket.class, MoveEntityAbsoluteSerializer_v354.INSTANCE, 18)
            .registerPacket(MovePlayerPacket.class, MovePlayerSerializer_v354.INSTANCE, 19)
            .registerPacket(RiderJumpPacket.class, RiderJumpSerializer_v354.INSTANCE, 20)
            .registerPacket(UpdateBlockPacket.class, UpdateBlockSerializer_v354.INSTANCE, 21)
            .registerPacket(AddPaintingPacket.class, AddPaintingSerializer_v354.INSTANCE, 22)
            .registerPacket(ExplodePacket.class, ExplodeSerializer_v354.INSTANCE, 23)
            .registerPacket(LevelSoundEvent1Packet.class, LevelSoundEvent1Serializer_v354.INSTANCE, 24)
            .registerPacket(LevelEventPacket.class, LevelEventSerializer_v354.INSTANCE, 25)
            .registerPacket(BlockEventPacket.class, BlockEventSerializer_v354.INSTANCE, 26)
            .registerPacket(EntityEventPacket.class, EntityEventSerializer_v354.INSTANCE, 27)
            .registerPacket(MobEffectPacket.class, MobEffectSerializer_v354.INSTANCE, 28)
            .registerPacket(UpdateAttributesPacket.class, UpdateAttributesSerializer_v354.INSTANCE, 29)
            .registerPacket(InventoryTransactionPacket.class, InventoryTransactionSerializer_v354.INSTANCE, 30)
            .registerPacket(MobEquipmentPacket.class, MobEquipmentSerializer_v354.INSTANCE, 31)
            .registerPacket(MobArmorEquipmentPacket.class, MobArmorEquipmentSerializer_v354.INSTANCE, 32)
            .registerPacket(InteractPacket.class, InteractSerializer_v354.INSTANCE, 33)
            .registerPacket(BlockPickRequestPacket.class, BlockPickRequestSerializer_v354.INSTANCE, 34)
            .registerPacket(EntityPickRequestPacket.class, EntityPickRequestSerializer_v354.INSTANCE, 35)
            .registerPacket(PlayerActionPacket.class, PlayerActionSerializer_v354.INSTANCE, 36)
            .registerPacket(EntityFallPacket.class, EntityFallSerializer_v354.INSTANCE, 37)
            .registerPacket(HurtArmorPacket.class, HurtArmorSerializer_v354.INSTANCE, 38)
            .registerPacket(SetEntityDataPacket.class, SetEntityDataSerializer_v354.INSTANCE, 39)
            .registerPacket(SetEntityMotionPacket.class, SetEntityMotionSerializer_v354.INSTANCE, 40)
            .registerPacket(SetEntityLinkPacket.class, SetEntityLinkSerializer_v354.INSTANCE, 41)
            .registerPacket(SetHealthPacket.class, SetHealthSerializer_v354.INSTANCE, 42)
            .registerPacket(SetSpawnPositionPacket.class, SetSpawnPositionSerializer_v354.INSTANCE, 43)
            .registerPacket(AnimatePacket.class, AnimateSerializer_v354.INSTANCE, 44)
            .registerPacket(RespawnPacket.class, RespawnSerializer_v354.INSTANCE, 45)
            .registerPacket(ContainerOpenPacket.class, ContainerOpenSerializer_v354.INSTANCE, 46)
            .registerPacket(ContainerClosePacket.class, ContainerCloseSerializer_v354.INSTANCE, 47)
            .registerPacket(PlayerHotbarPacket.class, PlayerHotbarSerializer_v354.INSTANCE, 48)
            .registerPacket(InventoryContentPacket.class, InventoryContentSerializer_v354.INSTANCE, 49)
            .registerPacket(InventorySlotPacket.class, InventorySlotSerializer_v354.INSTANCE, 50)
            .registerPacket(ContainerSetDataPacket.class, ContainerSetDataSerializer_v354.INSTANCE, 51)
            .registerPacket(CraftingDataPacket.class, CraftingDataSerializer_v354.INSTANCE, 52)
            .registerPacket(CraftingEventPacket.class, CraftingEventSerializer_v354.INSTANCE, 53)
            .registerPacket(GuiDataPickItemPacket.class, GuiDataPickItemSerializer_v354.INSTANCE, 54)
            .registerPacket(AdventureSettingsPacket.class, AdventureSettingsSerializer_v354.INSTANCE, 55)
            .registerPacket(BlockEntityDataPacket.class, BlockEntityDataSerializer_v354.INSTANCE, 56)
            .registerPacket(PlayerInputPacket.class, PlayerInputSerializer_v354.INSTANCE, 57)
            .registerPacket(LevelChunkPacket.class, FullChunkDataSerializer_v354.INSTANCE, 58)
            .registerPacket(SetCommandsEnabledPacket.class, SetCommandsEnabledSerializer_v354.INSTANCE, 59)
            .registerPacket(SetDifficultyPacket.class, SetDifficultySerializer_v354.INSTANCE, 60)
            .registerPacket(ChangeDimensionPacket.class, ChangeDimensionSerializer_v354.INSTANCE, 61)
            .registerPacket(SetPlayerGameTypePacket.class, SetPlayerGameTypeSerializer_v354.INSTANCE, 62)
            .registerPacket(PlayerListPacket.class, PlayerListSerializer_v354.INSTANCE, 63)
            .registerPacket(SimpleEventPacket.class, SimpleEventSerializer_v354.INSTANCE, 64)
            .registerPacket(EventPacket.class, EventSerializer_v354.INSTANCE, 65)
            .registerPacket(SpawnExperienceOrbPacket.class, SpawnExperienceOrbSerializer_v354.INSTANCE, 66)
            .registerPacket(ClientboundMapItemDataPacket.class, ClientboundMapItemDataSerializer_v354.INSTANCE, 67)
            .registerPacket(MapInfoRequestPacket.class, MapInfoRequestSerializer_v354.INSTANCE, 68)
            .registerPacket(RequestChunkRadiusPacket.class, RequestChunkRadiusSerializer_v354.INSTANCE, 69)
            .registerPacket(ChunkRadiusUpdatedPacket.class, ChunkRadiusUpdatedSerializer_v354.INSTANCE, 70)
            .registerPacket(ItemFrameDropItemPacket.class, ItemFrameDropItemSerializer_v354.INSTANCE, 71)
            .registerPacket(GameRulesChangedPacket.class, GameRulesChangedSerializer_v354.INSTANCE, 72)
            .registerPacket(CameraPacket.class, CameraSerializer_v354.INSTANCE, 73)
            .registerPacket(BossEventPacket.class, BossEventSerializer_v354.INSTANCE, 74)
            .registerPacket(ShowCreditsPacket.class, ShowCreditsSerializer_v354.INSTANCE, 75)
            .registerPacket(AvailableCommandsPacket.class, AvailableCommandsSerializer_v354.INSTANCE, 76)
            .registerPacket(CommandRequestPacket.class, CommandRequestSerializer_v354.INSTANCE, 77)
            .registerPacket(CommandBlockUpdatePacket.class, CommandBlockUpdateSerializer_v354.INSTANCE, 78)
            .registerPacket(CommandOutputPacket.class, CommandOutputSerializer_v354.INSTANCE, 79)
            .registerPacket(UpdateTradePacket.class, UpdateTradeSerializer_v354.INSTANCE, 80)
            .registerPacket(UpdateEquipPacket.class, UpdateEquipSerializer_v354.INSTANCE, 81)
            .registerPacket(ResourcePackDataInfoPacket.class, ResourcePackDataInfoSerializer_v354.INSTANCE, 82)
            .registerPacket(ResourcePackChunkDataPacket.class, ResourcePackChunkDataSerializer_v354.INSTANCE, 83)
            .registerPacket(ResourcePackChunkRequestPacket.class, ResourcePackChunkRequestSerializer_v354.INSTANCE, 84)
            .registerPacket(TransferPacket.class, TransferSerializer_v354.INSTANCE, 85)
            .registerPacket(PlaySoundPacket.class, PlaySoundSerializer_v354.INSTANCE, 86)
            .registerPacket(StopSoundPacket.class, StopSoundSerializer_v354.INSTANCE, 87)
            .registerPacket(SetTitlePacket.class, SetTitleSerializer_v354.INSTANCE, 88)
            .registerPacket(AddBehaviorTreePacket.class, AddBehaviorTreeSerializer_v354.INSTANCE, 89)
            .registerPacket(StructureBlockUpdatePacket.class, StructureBlockUpdateSerializer_v354.INSTANCE, 90)
            .registerPacket(ShowStoreOfferPacket.class, ShowStoreOfferSerializer_v354.INSTANCE, 91)
            .registerPacket(PurchaseReceiptPacket.class, PurchaseReceiptSerializer_v354.INSTANCE, 92)
            .registerPacket(PlayerSkinPacket.class, PlayerSkinSerializer_v354.INSTANCE, 93)
            .registerPacket(SubClientLoginPacket.class, SubClientLoginSerializer_v354.INSTANCE, 94)
            .registerPacket(AutomationClientConnectPacket.class, AutomationClientConnectSerializer_v354.INSTANCE, 95)
            .registerPacket(SetLastHurtByPacket.class, SetLastHurtBySerializer_v354.INSTANCE, 96)
            .registerPacket(BookEditPacket.class, BookEditSerializer_v354.INSTANCE, 97)
            .registerPacket(NpcRequestPacket.class, NpcRequestSerializer_v354.INSTANCE, 98)
            .registerPacket(PhotoTransferPacket.class, PhotoTransferSerializer_v354.INSTANCE, 99)
            .registerPacket(ModalFormRequestPacket.class, ModalFormRequestSerializer_v354.INSTANCE, 100)
            .registerPacket(ModalFormResponsePacket.class, ModalFormResponseSerializer_v354.INSTANCE, 101)
            .registerPacket(ServerSettingsRequestPacket.class, ServerSettingsRequestSerializer_v354.INSTANCE, 102)
            .registerPacket(ServerSettingsResponsePacket.class, ServerSettingsResponseSerializer_v354.INSTANCE, 103)
            .registerPacket(ShowProfilePacket.class, ShowProfileSerializer_v354.INSTANCE, 104)
            .registerPacket(SetDefaultGameTypePacket.class, SetDefaultGameTypeSerializer_v354.INSTANCE, 105)
            .registerPacket(RemoveObjectivePacket.class, RemoveObjectiveSerializer_v354.INSTANCE, 106)
            .registerPacket(SetDisplayObjectivePacket.class, SetDisplayObjectiveSerializer_v354.INSTANCE, 107)
            .registerPacket(SetScorePacket.class, SetScoreSerializer_v354.INSTANCE, 108)
            .registerPacket(LabTablePacket.class, LabTableSerializer_v354.INSTANCE, 109)
            .registerPacket(UpdateBlockSyncedPacket.class, UpdateBlockSyncedSerializer_v354.INSTANCE, 110)
            .registerPacket(MoveEntityDeltaPacket.class, MoveEntityDeltaSerializer_v354.INSTANCE, 111)
            .registerPacket(SetScoreboardIdentityPacket.class, SetScoreboardIdentitySerializer_v354.INSTANCE, 112)
            .registerPacket(SetLocalPlayerAsInitializedPacket.class, SetLocalPlayerAsInitializedSerializer_v354.INSTANCE, 113)
            .registerPacket(UpdateSoftEnumPacket.class, UpdateSoftEnumSerializer_v354.INSTANCE, 114)
            .registerPacket(NetworkStackLatencyPacket.class, NetworkStackLatencySerializer_v354.INSTANCE, 115)
            .registerPacket(ScriptCustomEventPacket.class, ScriptCustomEventSerializer_v354.INSTANCE, 117)
            .registerPacket(SpawnParticleEffectPacket.class, SpawnParticleEffectSerializer_v354.INSTANCE, 118)
            .registerPacket(AvailableEntityIdentifiersPacket.class, AvailableEntityIdentifiersSerializer_v354.INSTANCE, 119)
            .registerPacket(LevelSoundEvent2Packet.class, LevelSoundEvent2Serializer_v354.INSTANCE, 120)
            .registerPacket(NetworkChunkPublisherUpdatePacket.class, NetworkChunkPublisherUpdateSerializer_v354.INSTANCE, 121)
            .registerPacket(BiomeDefinitionListPacket.class, BiomeDefinitionListSerializer_v354.INSTANCE, 122)
            .registerPacket(LevelSoundEventPacket.class, LevelSoundEvent3Serializer_v354.INSTANCE, 123)
            .registerPacket(LecternUpdatePacket.class, LecternUpdateSerializer_v354.INSTANCE, 124)
            .registerPacket(VideoStreamConnectPacket.class, VideoStreamConnectSerializer_v354.INSTANCE, 125)
            .registerPacket(MapCreateLockedCopyPacket.class, MapCreateLockedCopySerializer_v354.INSTANCE, 126)
            .registerPacket(OnScreenTextureAnimationPacket.class, OnScreenTextureAnimationSerializer_v354.INSTANCE, 127)
            .build();
}
