/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v354.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.data.ScoreInfo;
import com.nukkitx.protocol.bedrock.packet.SetScorePacket;
import com.nukkitx.protocol.bedrock.v354.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;

public class SetScoreSerializer_v354
implements PacketSerializer<SetScorePacket> {
    public static final SetScoreSerializer_v354 INSTANCE = new SetScoreSerializer_v354();

    public void serialize(ByteBuf buffer, SetScorePacket packet) {
        SetScorePacket.Action action = packet.getAction();
        buffer.writeByte(action.ordinal());
        BedrockUtils.writeArray(buffer, packet.getInfos(), (buf, scoreInfo) -> {
            VarInts.writeLong((ByteBuf)buf, (long)scoreInfo.getScoreboardId());
            BedrockUtils.writeString(buf, scoreInfo.getObjectiveId());
            buf.writeIntLE(scoreInfo.getScore());
            if (action == SetScorePacket.Action.SET) {
                buf.writeByte(scoreInfo.getType().ordinal());
                switch (scoreInfo.getType()) {
                    case ENTITY: 
                    case PLAYER: {
                        VarInts.writeLong((ByteBuf)buf, (long)scoreInfo.getEntityId());
                        break;
                    }
                    case FAKE: {
                        BedrockUtils.writeString(buf, scoreInfo.getName());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid score info received");
                    }
                }
            }
        });
    }

    public void deserialize(ByteBuf buffer, SetScorePacket packet) {
        SetScorePacket.Action action = SetScorePacket.Action.values()[buffer.readUnsignedByte()];
        packet.setAction(action);
        BedrockUtils.readArray(buffer, packet.getInfos(), buf -> {
            long scoreboardId = VarInts.readLong((ByteBuf)buf);
            String objectiveId = BedrockUtils.readString(buf);
            int score = buf.readIntLE();
            if (action == SetScorePacket.Action.SET) {
                ScoreInfo.ScorerType type = ScoreInfo.ScorerType.values()[buf.readUnsignedByte()];
                switch (type) {
                    case ENTITY: 
                    case PLAYER: {
                        long entityId = VarInts.readLong((ByteBuf)buf);
                        return new ScoreInfo(scoreboardId, objectiveId, score, type, entityId);
                    }
                    case FAKE: {
                        String name = BedrockUtils.readString(buf);
                        return new ScoreInfo(scoreboardId, objectiveId, score, name);
                    }
                }
                throw new IllegalArgumentException("Invalid score info received");
            }
            return new ScoreInfo(scoreboardId, objectiveId, score);
        });
    }

    private SetScoreSerializer_v354() {
    }
}

