package com.nukkitx.protocol.bedrock.v340;

import com.nukkitx.protocol.bedrock.BedrockPacketCodec;
import com.nukkitx.protocol.bedrock.packet.*;
import com.nukkitx.protocol.bedrock.v340.serializer.*;
import lombok.experimental.UtilityClass;

@UtilityClass
public class Bedrock_v340 {
    public static BedrockPacketCodec V340_CODEC = BedrockPacketCodec.builder()
            .protocolVersion(340)
            .minecraftVersion("1.10.0")
            .headerSerializer(PacketHeaderSerializer_v340.INSTANCE)
            .registerPacket(LoginPacket.class, LoginSerializer_v340.INSTANCE, 1)
            .registerPacket(PlayStatusPacket.class, PlayStatusSerializer_v340.INSTANCE, 2)
            .registerPacket(ServerToClientHandshakePacket.class, ServerToClientHandshakeSerializer_v340.INSTANCE, 3)
            .registerPacket(ClientToServerHandshakePacket.class, ClientToServerHandshakeSerializer_v340.INSTANCE, 4)
            .registerPacket(DisconnectPacket.class, DisconnectSerializer_v340.INSTANCE, 5)
            .registerPacket(ResourcePacksInfoPacket.class, ResourcePacksInfoSerializer_v340.INSTANCE, 6)
            .registerPacket(ResourcePackStackPacket.class, ResourcePackStackSerializer_v340.INSTANCE, 7)
            .registerPacket(ResourcePackClientResponsePacket.class, ResourcePackClientResponseSerializer_v340.INSTANCE, 8)
            .registerPacket(TextPacket.class, TextSerializer_v340.INSTANCE, 9)
            .registerPacket(SetTimePacket.class, SetTimeSerializer_v340.INSTANCE, 10)
            .registerPacket(StartGamePacket.class, StartGameSerializer_v340.INSTANCE, 11)
            .registerPacket(AddPlayerPacket.class, AddPlayerSerializer_v340.INSTANCE, 12)
            .registerPacket(AddEntityPacket.class, AddEntitySerializer_v340.INSTANCE, 13)
            .registerPacket(RemoveEntityPacket.class, RemoveEntitySerializer_v340.INSTANCE, 14)
            .registerPacket(AddItemEntityPacket.class, AddItemEntitySerializer_v340.INSTANCE, 15)
            .registerPacket(TakeItemEntityPacket.class, TakeItemEntitySerializer_v340.INSTANCE, 17)
            .registerPacket(MoveEntityAbsolutePacket.class, MoveEntityAbsoluteSerializer_v340.INSTANCE, 18)
            .registerPacket(MovePlayerPacket.class, MovePlayerSerializer_v340.INSTANCE, 19)
            .registerPacket(RiderJumpPacket.class, RiderJumpSerializer_v340.INSTANCE, 20)
            .registerPacket(UpdateBlockPacket.class, UpdateBlockSerializer_v340.INSTANCE, 21)
            .registerPacket(AddPaintingPacket.class, AddPaintingSerializer_v340.INSTANCE, 22)
            .registerPacket(ExplodePacket.class, ExplodeSerializer_v340.INSTANCE, 23)
            .registerPacket(LevelSoundEventPacket.class, LevelSoundEventSerializer_v340.INSTANCE, 24)
            .registerPacket(LevelEventPacket.class, LevelEventSerializer_v340.INSTANCE, 25)
            .registerPacket(BlockEventPacket.class, BlockEventSerializer_v340.INSTANCE, 26)
            .registerPacket(EntityEventPacket.class, EntityEventSerializer_v340.INSTANCE, 27)
            .registerPacket(MobEffectPacket.class, MobEffectSerializer_v340.INSTANCE, 28)
            .registerPacket(UpdateAttributesPacket.class, UpdateAttributesSerializer_v340.INSTANCE, 29)
            .registerPacket(InventoryTransactionPacket.class, InventoryTransactionSerializer_v340.INSTANCE, 30)
            .registerPacket(MobEquipmentPacket.class, MobEquipmentSerializer_v340.INSTANCE, 31)
            .registerPacket(MobArmorEquipmentPacket.class, MobArmorEquipmentSerializer_v340.INSTANCE, 32)
            .registerPacket(InteractPacket.class, InteractSerializer_v340.INSTANCE, 33)
            .registerPacket(BlockPickRequestPacket.class, BlockPickRequestSerializer_v340.INSTANCE, 34)
            .registerPacket(EntityPickRequestPacket.class, EntityPickRequestSerializer_v340.INSTANCE, 35)
            .registerPacket(PlayerActionPacket.class, PlayerActionSerializer_v340.INSTANCE, 36)
            .registerPacket(EntityFallPacket.class, EntityFallSerializer_v340.INSTANCE, 37)
            .registerPacket(HurtArmorPacket.class, HurtArmorSerializer_v340.INSTANCE, 38)
            .registerPacket(SetEntityDataPacket.class, SetEntityDataSerializer_v340.INSTANCE, 39)
            .registerPacket(SetEntityMotionPacket.class, SetEntityMotionSerializer_v340.INSTANCE, 40)
            .registerPacket(SetEntityLinkPacket.class, SetEntityLinkSerializer_v340.INSTANCE, 41)
            .registerPacket(SetHealthPacket.class, SetHealthSerializer_v340.INSTANCE, 42)
            .registerPacket(SetSpawnPositionPacket.class, SetSpawnPositionSerializer_v340.INSTANCE, 43)
            .registerPacket(AnimatePacket.class, AnimateSerializer_v340.INSTANCE, 44)
            .registerPacket(RespawnPacket.class, RespawnSerializer_v340.INSTANCE, 45)
            .registerPacket(ContainerOpenPacket.class, ContainerOpenSerializer_v340.INSTANCE, 46)
            .registerPacket(ContainerClosePacket.class, ContainerCloseSerializer_v340.INSTANCE, 47)
            .registerPacket(PlayerHotbarPacket.class, PlayerHotbarSerializer_v340.INSTANCE, 48)
            .registerPacket(InventoryContentPacket.class, InventoryContentSerializer_v340.INSTANCE, 49)
            .registerPacket(InventorySlotPacket.class, InventorySlotSerializer_v340.INSTANCE, 50)
            .registerPacket(ContainerSetDataPacket.class, ContainerSetDataSerializer_v340.INSTANCE, 51)
            .registerPacket(CraftingDataPacket.class, CraftingDataSerializer_v340.INSTANCE, 52)
            .registerPacket(CraftingEventPacket.class, CraftingEventSerializer_v340.INSTANCE, 53)
            .registerPacket(GuiDataPickItemPacket.class, GuiDataPickItemSerializer_v340.INSTANCE, 54)
            .registerPacket(AdventureSettingsPacket.class, AdventureSettingsSerializer_v340.INSTANCE, 55)
            .registerPacket(BlockEntityDataPacket.class, BlockEntityDataSerializer_v340.INSTANCE, 56)
            .registerPacket(PlayerInputPacket.class, PlayerInputSerializer_v340.INSTANCE, 57)
            .registerPacket(LevelChunkPacket.class, FullChunkDataSerializer_v340.INSTANCE, 58)
            .registerPacket(SetCommandsEnabledPacket.class, SetCommandsEnabledSerializer_v340.INSTANCE, 59)
            .registerPacket(SetDifficultyPacket.class, SetDifficultySerializer_v340.INSTANCE, 60)
            .registerPacket(ChangeDimensionPacket.class, ChangeDimensionSerializer_v340.INSTANCE, 61)
            .registerPacket(SetPlayerGameTypePacket.class, SetPlayerGameTypeSerializer_v340.INSTANCE, 62)
            .registerPacket(PlayerListPacket.class, PlayerListSerializer_v340.INSTANCE, 63)
            .registerPacket(SimpleEventPacket.class, SimpleEventSerializer_v340.INSTANCE, 64)
            .registerPacket(EventPacket.class, EventSerializer_v340.INSTANCE, 65)
            .registerPacket(SpawnExperienceOrbPacket.class, SpawnExperienceOrbSerializer_v340.INSTANCE, 66)
            .registerPacket(ClientboundMapItemDataPacket.class, ClientboundMapItemDataSerializer_v340.INSTANCE, 67)
            .registerPacket(MapInfoRequestPacket.class, MapInfoRequestSerializer_v340.INSTANCE, 68)
            .registerPacket(RequestChunkRadiusPacket.class, RequestChunkRadiusSerializer_v340.INSTANCE, 69)
            .registerPacket(ChunkRadiusUpdatedPacket.class, ChunkRadiusUpdatedSerializer_v340.INSTANCE, 70)
            .registerPacket(ItemFrameDropItemPacket.class, ItemFrameDropItemSerializer_v340.INSTANCE, 71)
            .registerPacket(GameRulesChangedPacket.class, GameRulesChangedSerializer_v340.INSTANCE, 72)
            .registerPacket(CameraPacket.class, CameraSerializer_v340.INSTANCE, 73)
            .registerPacket(BossEventPacket.class, BossEventSerializer_v340.INSTANCE, 74)
            .registerPacket(ShowCreditsPacket.class, ShowCreditsSerializer_v340.INSTANCE, 75)
            .registerPacket(AvailableCommandsPacket.class, AvailableCommandsSerializer_v340.INSTANCE, 76)
            .registerPacket(CommandRequestPacket.class, CommandRequestSerializer_v340.INSTANCE, 77)
            .registerPacket(CommandBlockUpdatePacket.class, CommandBlockUpdateSerializer_v340.INSTANCE, 78)
            .registerPacket(CommandOutputPacket.class, CommandOutputSerializer_v340.INSTANCE, 79)
            .registerPacket(UpdateTradePacket.class, UpdateTradeSerializer_v340.INSTANCE, 80)
            .registerPacket(UpdateEquipPacket.class, UpdateEquipSerializer_v340.INSTANCE, 81)
            .registerPacket(ResourcePackDataInfoPacket.class, ResourcePackDataInfoSerializer_v340.INSTANCE, 82)
            .registerPacket(ResourcePackChunkDataPacket.class, ResourcePackChunkDataSerializer_v340.INSTANCE, 83)
            .registerPacket(ResourcePackChunkRequestPacket.class, ResourcePackChunkRequestSerializer_v340.INSTANCE, 84)
            .registerPacket(TransferPacket.class, TransferSerializer_v340.INSTANCE, 85)
            .registerPacket(PlaySoundPacket.class, PlaySoundSerializer_v340.INSTANCE, 86)
            .registerPacket(StopSoundPacket.class, StopSoundSerializer_v340.INSTANCE, 87)
            .registerPacket(SetTitlePacket.class, SetTitleSerializer_v340.INSTANCE, 88)
            .registerPacket(AddBehaviorTreePacket.class, AddBehaviorTreeSerializer_v340.INSTANCE, 89)
            .registerPacket(StructureBlockUpdatePacket.class, StructureBlockUpdateSerializer_v340.INSTANCE, 90)
            .registerPacket(ShowStoreOfferPacket.class, ShowStoreOfferSerializer_v340.INSTANCE, 91)
            .registerPacket(PurchaseReceiptPacket.class, PurchaseReceiptSerializer_v340.INSTANCE, 92)
            .registerPacket(PlayerSkinPacket.class, PlayerSkinSerializer_v340.INSTANCE, 93)
            .registerPacket(SubClientLoginPacket.class, SubClientLoginSerializer_v340.INSTANCE, 94)
            .registerPacket(AutomationClientConnectPacket.class, AutomationClientConnectSerializer_v340.INSTANCE, 95)
            .registerPacket(SetLastHurtByPacket.class, SetLastHurtBySerializer_v340.INSTANCE, 96)
            .registerPacket(BookEditPacket.class, BookEditSerializer_v340.INSTANCE, 97)
            .registerPacket(NpcRequestPacket.class, NpcRequestSerializer_v340.INSTANCE, 98)
            .registerPacket(PhotoTransferPacket.class, PhotoTransferSerializer_v340.INSTANCE, 99)
            .registerPacket(ModalFormRequestPacket.class, ModalFormRequestSerializer_v340.INSTANCE, 100)
            .registerPacket(ModalFormResponsePacket.class, ModalFormResponseSerializer_v340.INSTANCE, 101)
            .registerPacket(ServerSettingsRequestPacket.class, ServerSettingsRequestSerializer_v340.INSTANCE, 102)
            .registerPacket(ServerSettingsResponsePacket.class, ServerSettingsResponseSerializer_v340.INSTANCE, 103)
            .registerPacket(ShowProfilePacket.class, ShowProfileSerializer_v340.INSTANCE, 104)
            .registerPacket(SetDefaultGameTypePacket.class, SetDefaultGameTypeSerializer_v340.INSTANCE, 105)
            .registerPacket(RemoveObjectivePacket.class, RemoveObjectiveSerializer_v340.INSTANCE, 106)
            .registerPacket(SetDisplayObjectivePacket.class, SetDisplayObjectiveSerializer_v340.INSTANCE, 107)
            .registerPacket(SetScorePacket.class, SetScoreSerializer_v340.INSTANCE, 108)
            .registerPacket(LabTablePacket.class, LabTableSerializer_v340.INSTANCE, 109)
            .registerPacket(UpdateBlockSyncedPacket.class, UpdateBlockSyncedSerializer_v340.INSTANCE, 110)
            .registerPacket(MoveEntityDeltaPacket.class, MoveEntityDeltaSerializer_v340.INSTANCE, 111)
            .registerPacket(SetScoreboardIdentityPacket.class, SetScoreboardIdentitySerializer_v340.INSTANCE, 112)
            .registerPacket(SetLocalPlayerAsInitializedPacket.class, SetLocalPlayerAsInitializedSerializer_v340.INSTANCE, 113)
            .registerPacket(UpdateSoftEnumPacket.class, UpdateSoftEnumSerializer_v340.INSTANCE, 114)
            .registerPacket(NetworkStackLatencyPacket.class, NetworkStackLatencySerializer_v340.INSTANCE, 115)
            .registerPacket(ScriptCustomEventPacket.class, ScriptCustomEventSerializer_v340.INSTANCE, 117)
            .registerPacket(SpawnParticleEffectPacket.class, SpawnParticleEffectSerializer_v340.INSTANCE, 118)
            .registerPacket(AvailableEntityIdentifiersPacket.class, AvailableEntityIdentifiersSerializer_v340.INSTANCE, 119)
            .registerPacket(LevelSoundEvent2Packet.class, LevelSoundEvent2Serializer_v340.INSTANCE, 120)
            .registerPacket(NetworkChunkPublisherUpdatePacket.class, NetworkChunkPublisherUpdateSerializer_v340.INSTANCE, 121)
            .registerPacket(BiomeDefinitionListPacket.class, BiomeDefinitionListSerializer_v340.INSTANCE, 122)
            .registerPacket(LevelSoundEvent3Packet.class, LevelSoundEvent3Serializer_v340.INSTANCE, 123)
            .registerPacket(LecternUpdatePacket.class, LecternUpdateSerializer_v340.INSTANCE, 124)
            .registerPacket(VideoStreamConnectPacket.class, VideoStreamConnectSerializer_v340.INSTANCE, 125)
            .build();
}
