/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v332.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.packet.UpdateBlockPacket;
import com.nukkitx.protocol.bedrock.v332.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;
import java.util.Set;

public class UpdateBlockSerializer_v332
implements PacketSerializer<UpdateBlockPacket> {
    public static final UpdateBlockSerializer_v332 INSTANCE = new UpdateBlockSerializer_v332();

    public void serialize(ByteBuf buffer, UpdateBlockPacket packet) {
        BedrockUtils.writeBlockPosition(buffer, packet.getBlockPosition());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)packet.getRuntimeId());
        int flagValue = 0;
        for (UpdateBlockPacket.Flag flag : packet.getFlags()) {
            flagValue |= 1 << flag.ordinal();
        }
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)flagValue);
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)packet.getDataLayer());
    }

    public void deserialize(ByteBuf buffer, UpdateBlockPacket packet) {
        packet.setBlockPosition(BedrockUtils.readBlockPosition(buffer));
        packet.setRuntimeId(VarInts.readUnsignedInt((ByteBuf)buffer));
        int flagValue = VarInts.readUnsignedInt((ByteBuf)buffer);
        Set flags = packet.getFlags();
        for (UpdateBlockPacket.Flag flag : UpdateBlockPacket.Flag.values()) {
            if ((flagValue & 1 << flag.ordinal()) == 0) continue;
            flags.add(flag);
        }
        packet.setDataLayer(VarInts.readUnsignedInt((ByteBuf)buffer));
    }

    private UpdateBlockSerializer_v332() {
    }
}

