/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v332.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.packet.InventoryTransactionPacket;
import com.nukkitx.protocol.bedrock.v332.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;

public class InventoryTransactionSerializer_v332
implements PacketSerializer<InventoryTransactionPacket> {
    public static final InventoryTransactionSerializer_v332 INSTANCE = new InventoryTransactionSerializer_v332();

    public void serialize(ByteBuf buffer, InventoryTransactionPacket packet) {
        InventoryTransactionPacket.Type transactionType = packet.getTransactionType();
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)transactionType.ordinal());
        BedrockUtils.writeArray(buffer, packet.getActions(), BedrockUtils::writeInventoryAction);
        switch (transactionType) {
            case ITEM_USE: {
                VarInts.writeUnsignedInt((ByteBuf)buffer, (long)packet.getActionType());
                BedrockUtils.writeBlockPosition(buffer, packet.getBlockPosition());
                VarInts.writeInt((ByteBuf)buffer, (int)packet.getFace());
                VarInts.writeInt((ByteBuf)buffer, (int)packet.getHotbarSlot());
                BedrockUtils.writeItemData(buffer, packet.getItemInHand());
                BedrockUtils.writeVector3f(buffer, packet.getPlayerPosition());
                BedrockUtils.writeVector3f(buffer, packet.getClickPosition());
                break;
            }
            case ITEM_USE_ON_ENTITY: {
                VarInts.writeUnsignedInt((ByteBuf)buffer, (long)packet.getRuntimeEntityId());
                VarInts.writeUnsignedInt((ByteBuf)buffer, (long)packet.getActionType());
                VarInts.writeInt((ByteBuf)buffer, (int)packet.getHotbarSlot());
                BedrockUtils.writeItemData(buffer, packet.getItemInHand());
                BedrockUtils.writeVector3f(buffer, packet.getPlayerPosition());
                BedrockUtils.writeVector3f(buffer, packet.getClickPosition());
                break;
            }
            case ITEM_RELEASE: {
                VarInts.writeUnsignedInt((ByteBuf)buffer, (long)packet.getActionType());
                VarInts.writeInt((ByteBuf)buffer, (int)packet.getHotbarSlot());
                BedrockUtils.writeItemData(buffer, packet.getItemInHand());
                BedrockUtils.writeVector3f(buffer, packet.getHeadPosition());
            }
        }
    }

    public void deserialize(ByteBuf buffer, InventoryTransactionPacket packet) {
        InventoryTransactionPacket.Type transactionType = InventoryTransactionPacket.Type.values()[VarInts.readUnsignedInt((ByteBuf)buffer)];
        packet.setTransactionType(transactionType);
        BedrockUtils.readArray(buffer, packet.getActions(), BedrockUtils::readInventoryAction);
        switch (transactionType) {
            case ITEM_USE: {
                packet.setActionType(VarInts.readUnsignedInt((ByteBuf)buffer));
                packet.setBlockPosition(BedrockUtils.readBlockPosition(buffer));
                packet.setFace(VarInts.readInt((ByteBuf)buffer));
                packet.setHotbarSlot(VarInts.readInt((ByteBuf)buffer));
                packet.setItemInHand(BedrockUtils.readItemData(buffer));
                packet.setPlayerPosition(BedrockUtils.readVector3f(buffer));
                packet.setClickPosition(BedrockUtils.readVector3f(buffer));
                break;
            }
            case ITEM_USE_ON_ENTITY: {
                packet.setRuntimeEntityId((long)VarInts.readUnsignedInt((ByteBuf)buffer));
                packet.setActionType(VarInts.readUnsignedInt((ByteBuf)buffer));
                packet.setHotbarSlot(VarInts.readInt((ByteBuf)buffer));
                packet.setItemInHand(BedrockUtils.readItemData(buffer));
                packet.setPlayerPosition(BedrockUtils.readVector3f(buffer));
                packet.setClickPosition(BedrockUtils.readVector3f(buffer));
                break;
            }
            case ITEM_RELEASE: {
                packet.setActionType(VarInts.readUnsignedInt((ByteBuf)buffer));
                packet.setHotbarSlot(VarInts.readInt((ByteBuf)buffer));
                packet.setItemInHand(BedrockUtils.readItemData(buffer));
                packet.setHeadPosition(BedrockUtils.readVector3f(buffer));
            }
        }
    }

    private InventoryTransactionSerializer_v332() {
    }
}

