/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v332.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.network.util.Preconditions;
import com.nukkitx.protocol.bedrock.data.event.AchievementAwardedEventData;
import com.nukkitx.protocol.bedrock.data.event.AgentCommandEventData;
import com.nukkitx.protocol.bedrock.data.event.AgentCreatedEventData;
import com.nukkitx.protocol.bedrock.data.event.BossKilledEventData;
import com.nukkitx.protocol.bedrock.data.event.CauldronUsedEventData;
import com.nukkitx.protocol.bedrock.data.event.EntityInteractEventData;
import com.nukkitx.protocol.bedrock.data.event.EventData;
import com.nukkitx.protocol.bedrock.data.event.EventDataType;
import com.nukkitx.protocol.bedrock.data.event.FishBucketedEventData;
import com.nukkitx.protocol.bedrock.data.event.MobBornEventData;
import com.nukkitx.protocol.bedrock.data.event.MobKilledEventData;
import com.nukkitx.protocol.bedrock.data.event.PatternRemovedEventData;
import com.nukkitx.protocol.bedrock.data.event.PetDiedEventData;
import com.nukkitx.protocol.bedrock.data.event.PlayerDiedEventData;
import com.nukkitx.protocol.bedrock.data.event.PortalBuiltEventData;
import com.nukkitx.protocol.bedrock.data.event.PortalUsedEventData;
import com.nukkitx.protocol.bedrock.data.event.SlashCommandExecutedEventData;
import com.nukkitx.protocol.bedrock.packet.EventPacket;
import com.nukkitx.protocol.bedrock.v332.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;

public class EventSerializer_v332
implements PacketSerializer<EventPacket> {
    public static final EventSerializer_v332 INSTANCE = new EventSerializer_v332();
    private static final EventDataType[] VALUES = EventDataType.values();

    public void serialize(ByteBuf buffer, EventPacket packet) {
        VarInts.writeLong((ByteBuf)buffer, (long)packet.getUniqueEntityId());
        EventData eventData = packet.getEventData();
        VarInts.writeInt((ByteBuf)buffer, (int)eventData.getType().ordinal());
        buffer.writeByte((int)packet.getUnknown0());
        switch (eventData.getType()) {
            case ACHIEVEMENT_AWARDED: {
                VarInts.writeInt((ByteBuf)buffer, (int)((AchievementAwardedEventData)eventData).getAchievementId());
                break;
            }
            case ENTITY_INTERACT: {
                EntityInteractEventData entityInteractEventData = (EntityInteractEventData)eventData;
                VarInts.writeInt((ByteBuf)buffer, (int)entityInteractEventData.getInteractionType());
                VarInts.writeInt((ByteBuf)buffer, (int)entityInteractEventData.getLegacyEntityTypeId());
                VarInts.writeInt((ByteBuf)buffer, (int)entityInteractEventData.getVariant());
                buffer.writeShortLE(entityInteractEventData.getPaletteColor());
                break;
            }
            case PORTAL_BUILT: {
                VarInts.writeInt((ByteBuf)buffer, (int)((PortalBuiltEventData)eventData).getDimensionId());
                break;
            }
            case PORTAL_USED: {
                PortalUsedEventData portalUsedEventData = (PortalUsedEventData)eventData;
                VarInts.writeInt((ByteBuf)buffer, (int)portalUsedEventData.getFromDimensionId());
                VarInts.writeInt((ByteBuf)buffer, (int)portalUsedEventData.getToDimensionId());
                break;
            }
            case MOB_KILLED: {
                MobKilledEventData mobKilledEventData = (MobKilledEventData)eventData;
                VarInts.writeLong((ByteBuf)buffer, (long)mobKilledEventData.getKillerUniqueEntityId());
                VarInts.writeLong((ByteBuf)buffer, (long)mobKilledEventData.getVictimUniqueEntityId());
                VarInts.writeInt((ByteBuf)buffer, (int)mobKilledEventData.getEntityDamageCause());
                VarInts.writeInt((ByteBuf)buffer, (int)mobKilledEventData.getVillagerTradeTier());
                BedrockUtils.writeString(buffer, mobKilledEventData.getVillagerDisplayName());
                break;
            }
            case CAULDRON_USED: {
                CauldronUsedEventData cauldronUsedEventData = (CauldronUsedEventData)eventData;
                VarInts.writeUnsignedInt((ByteBuf)buffer, (long)cauldronUsedEventData.getPotionId());
                VarInts.writeInt((ByteBuf)buffer, (int)cauldronUsedEventData.getColor());
                VarInts.writeInt((ByteBuf)buffer, (int)cauldronUsedEventData.getFillLevel());
                break;
            }
            case PLAYER_DIED: {
                PlayerDiedEventData playerDiedEventData = (PlayerDiedEventData)eventData;
                VarInts.writeInt((ByteBuf)buffer, (int)playerDiedEventData.getUnknown0());
                VarInts.writeInt((ByteBuf)buffer, (int)playerDiedEventData.getUnknown1());
                VarInts.writeInt((ByteBuf)buffer, (int)playerDiedEventData.getEntityDamageCause());
                break;
            }
            case BOSS_KILLED: {
                BossKilledEventData bossKilledEventData = (BossKilledEventData)eventData;
                VarInts.writeLong((ByteBuf)buffer, (long)bossKilledEventData.getBossUniqueEntityId());
                VarInts.writeInt((ByteBuf)buffer, (int)bossKilledEventData.getPlayerPartySize());
                VarInts.writeInt((ByteBuf)buffer, (int)bossKilledEventData.getLegacyEntityTypeId());
                break;
            }
            case AGENT_COMMAND: {
                AgentCommandEventData agentCommandEventData = (AgentCommandEventData)eventData;
                VarInts.writeInt((ByteBuf)buffer, (int)agentCommandEventData.getAgentResult());
                VarInts.writeInt((ByteBuf)buffer, (int)agentCommandEventData.getDataValue());
                BedrockUtils.writeString(buffer, agentCommandEventData.getCommand());
                BedrockUtils.writeString(buffer, agentCommandEventData.getDataKey());
                BedrockUtils.writeString(buffer, agentCommandEventData.getOutput());
                break;
            }
            case PATTERN_REMOVED: {
                PatternRemovedEventData patternRemovedEventData = (PatternRemovedEventData)eventData;
                VarInts.writeInt((ByteBuf)buffer, (int)patternRemovedEventData.getItemId());
                VarInts.writeInt((ByteBuf)buffer, (int)patternRemovedEventData.getAuxValue());
                VarInts.writeInt((ByteBuf)buffer, (int)patternRemovedEventData.getPatternsSize());
                VarInts.writeInt((ByteBuf)buffer, (int)patternRemovedEventData.getPatternIndex());
                VarInts.writeInt((ByteBuf)buffer, (int)patternRemovedEventData.getPatternColor());
                break;
            }
            case SLASH_COMMAND_EXECUTED: {
                SlashCommandExecutedEventData slashCommandExecutedEventData = (SlashCommandExecutedEventData)eventData;
                VarInts.writeInt((ByteBuf)buffer, (int)slashCommandExecutedEventData.getSuccessCount());
                List outputMessages = slashCommandExecutedEventData.getOutputMessages();
                VarInts.writeInt((ByteBuf)buffer, (int)outputMessages.size());
                BedrockUtils.writeString(buffer, slashCommandExecutedEventData.getCommandName());
                BedrockUtils.writeString(buffer, String.join((CharSequence)";", outputMessages));
                break;
            }
            case FISH_BUCKETED: {
                FishBucketedEventData fishBucketedEventData = (FishBucketedEventData)eventData;
                VarInts.writeInt((ByteBuf)buffer, (int)fishBucketedEventData.getUnknown0());
                VarInts.writeInt((ByteBuf)buffer, (int)fishBucketedEventData.getUnknown1());
                VarInts.writeInt((ByteBuf)buffer, (int)fishBucketedEventData.getUnknown2());
                buffer.writeBoolean(fishBucketedEventData.isUnknown3());
                break;
            }
            case MOB_BORN: {
                MobBornEventData mobBornEventData = (MobBornEventData)eventData;
                VarInts.writeInt((ByteBuf)buffer, (int)mobBornEventData.getLegacyEntityTypeId());
                VarInts.writeInt((ByteBuf)buffer, (int)mobBornEventData.getVariant());
                buffer.writeByte(mobBornEventData.getColor());
                break;
            }
            case PET_DIED: {
                PetDiedEventData petDiedEventData = (PetDiedEventData)eventData;
                buffer.writeBoolean(petDiedEventData.isUnknown0());
                VarInts.writeLong((ByteBuf)buffer, (long)petDiedEventData.getKillerUniqueEntityId());
                VarInts.writeLong((ByteBuf)buffer, (long)petDiedEventData.getPetUniqueEntityId());
                VarInts.writeInt((ByteBuf)buffer, (int)petDiedEventData.getEntityDamageCause());
                VarInts.writeInt((ByteBuf)buffer, (int)petDiedEventData.getUnknown1());
                break;
            }
        }
    }

    public void deserialize(ByteBuf buffer, EventPacket packet) {
        AgentCreatedEventData data;
        packet.setUniqueEntityId(VarInts.readLong((ByteBuf)buffer));
        int eventId = VarInts.readInt((ByteBuf)buffer);
        Preconditions.checkElementIndex((int)eventId, (int)VALUES.length, (String)"EventDataType");
        EventDataType type = VALUES[eventId];
        packet.setUnknown0(buffer.readByte());
        switch (type) {
            case ACHIEVEMENT_AWARDED: {
                data = new AchievementAwardedEventData(VarInts.readInt((ByteBuf)buffer));
                break;
            }
            case ENTITY_INTERACT: {
                int interactionType = VarInts.readInt((ByteBuf)buffer);
                int legacyEntityTypeId = VarInts.readInt((ByteBuf)buffer);
                int variant = VarInts.readInt((ByteBuf)buffer);
                short paletteColor = buffer.readUnsignedByte();
                data = new EntityInteractEventData(interactionType, legacyEntityTypeId, variant, (int)paletteColor);
                break;
            }
            case PORTAL_BUILT: {
                data = new PortalBuiltEventData(VarInts.readInt((ByteBuf)buffer));
                break;
            }
            case PORTAL_USED: {
                int fromDimensionId = VarInts.readInt((ByteBuf)buffer);
                int toDimensionId = VarInts.readInt((ByteBuf)buffer);
                data = new PortalUsedEventData(fromDimensionId, toDimensionId);
                break;
            }
            case MOB_KILLED: {
                long killerUniqueEntityId = VarInts.readLong((ByteBuf)buffer);
                long victimUniqueEntityId = VarInts.readLong((ByteBuf)buffer);
                int entityDamageCause = VarInts.readInt((ByteBuf)buffer);
                int villagerTradeTier = VarInts.readInt((ByteBuf)buffer);
                String villagerDisplayName = BedrockUtils.readString(buffer);
                data = new MobKilledEventData(killerUniqueEntityId, victimUniqueEntityId, entityDamageCause, villagerTradeTier, villagerDisplayName);
                break;
            }
            case CAULDRON_USED: {
                int potionId = VarInts.readInt((ByteBuf)buffer);
                int color = VarInts.readInt((ByteBuf)buffer);
                int fillLevel = VarInts.readInt((ByteBuf)buffer);
                data = new CauldronUsedEventData(potionId, color, fillLevel);
                break;
            }
            case PLAYER_DIED: {
                int unknown0 = VarInts.readInt((ByteBuf)buffer);
                int unknown1 = VarInts.readInt((ByteBuf)buffer);
                int entityDamageCause = VarInts.readInt((ByteBuf)buffer);
                data = new PlayerDiedEventData(unknown0, unknown1, entityDamageCause, false);
                break;
            }
            case BOSS_KILLED: {
                long bossUniqueEntityId = VarInts.readLong((ByteBuf)buffer);
                int playerPartySize = VarInts.readInt((ByteBuf)buffer);
                int legacyEntityTypeId = VarInts.readInt((ByteBuf)buffer);
                data = new BossKilledEventData(bossUniqueEntityId, playerPartySize, legacyEntityTypeId);
                break;
            }
            case AGENT_COMMAND: {
                int agentResult = VarInts.readInt((ByteBuf)buffer);
                int dataValue = VarInts.readInt((ByteBuf)buffer);
                String command = BedrockUtils.readString(buffer);
                String dataKey = BedrockUtils.readString(buffer);
                String output = BedrockUtils.readString(buffer);
                data = new AgentCommandEventData(agentResult, command, dataKey, dataValue, output);
                break;
            }
            case AGENT_CREATED: {
                data = AgentCreatedEventData.INSTANCE;
                break;
            }
            case PATTERN_REMOVED: {
                int itemId = VarInts.readInt((ByteBuf)buffer);
                int auxValue = VarInts.readInt((ByteBuf)buffer);
                int patternsSize = VarInts.readInt((ByteBuf)buffer);
                int patternIndex = VarInts.readInt((ByteBuf)buffer);
                int patternColor = VarInts.readInt((ByteBuf)buffer);
                data = new PatternRemovedEventData(itemId, auxValue, patternsSize, patternIndex, patternColor);
                break;
            }
            case SLASH_COMMAND_EXECUTED: {
                int successCount = VarInts.readInt((ByteBuf)buffer);
                VarInts.readInt((ByteBuf)buffer);
                String commandName = BedrockUtils.readString(buffer);
                List<String> outputMessages = Arrays.asList(BedrockUtils.readString(buffer).split(";"));
                data = new SlashCommandExecutedEventData(commandName, successCount, outputMessages);
                break;
            }
            case FISH_BUCKETED: {
                int unknown0 = VarInts.readInt((ByteBuf)buffer);
                int unknown1 = VarInts.readInt((ByteBuf)buffer);
                int unknown2 = VarInts.readInt((ByteBuf)buffer);
                boolean unknown3 = buffer.readBoolean();
                data = new FishBucketedEventData(unknown0, unknown1, unknown2, unknown3);
                break;
            }
            case MOB_BORN: {
                int legacyEntityTypeId = VarInts.readInt((ByteBuf)buffer);
                int variant = VarInts.readInt((ByteBuf)buffer);
                short color = buffer.readUnsignedByte();
                data = new MobBornEventData(legacyEntityTypeId, variant, (int)color);
                break;
            }
            case PET_DIED: {
                boolean unknownBool = buffer.readBoolean();
                long killerUniqueEntityId = VarInts.readLong((ByteBuf)buffer);
                long petUniqueEntityId = VarInts.readLong((ByteBuf)buffer);
                int entityDamageCause = VarInts.readInt((ByteBuf)buffer);
                int unknown1 = VarInts.readInt((ByteBuf)buffer);
                data = new PetDiedEventData(unknownBool, killerUniqueEntityId, petUniqueEntityId, entityDamageCause, unknown1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown EventDataType");
            }
        }
        packet.setEventData((EventData)data);
    }

    private EventSerializer_v332() {
    }
}

