package com.nukkitx.protocol.bedrock.v313.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.data.SoundEvent;
import com.nukkitx.protocol.bedrock.packet.LevelSoundEvent1Packet;
import com.nukkitx.protocol.bedrock.v313.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import com.nukkitx.protocol.util.Int2ObjectBiMap;
import io.netty.buffer.ByteBuf;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;

import static com.nukkitx.protocol.bedrock.data.SoundEvent.*;


@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class LevelSoundEvent1Serializer_v313 implements PacketSerializer<LevelSoundEvent1Packet> {
    public static final LevelSoundEvent1Serializer_v313 INSTANCE = new LevelSoundEvent1Serializer_v313();

    static final Int2ObjectBiMap<SoundEvent> SOUNDS = new Int2ObjectBiMap<>(2, 0.5F, 255, UNDEFINED);

    static {
        SOUNDS.put(0, ITEM_USE_ON);
        SOUNDS.put(1, HIT);
        SOUNDS.put(2, STEP);
        SOUNDS.put(3, FLY);
        SOUNDS.put(4, JUMP);
        SOUNDS.put(5, BREAK);
        SOUNDS.put(6, PLACE);
        SOUNDS.put(7, HEAVY_STEP);
        SOUNDS.put(8, GALLOP);
        SOUNDS.put(9, FALL);
        SOUNDS.put(10, AMBIENT);
        SOUNDS.put(11, AMBIENT_BABY);
        SOUNDS.put(12, AMBIENT_IN_WATER);
        SOUNDS.put(13, BREATHE);
        SOUNDS.put(14, DEATH);
        SOUNDS.put(15, DEATH_IN_WATER);
        SOUNDS.put(16, DEATH_TO_ZOMBIE);
        SOUNDS.put(17, HURT);
        SOUNDS.put(18, HURT_IN_WATER);
        SOUNDS.put(19, MAD);
        SOUNDS.put(20, BOOST);
        SOUNDS.put(21, BOW);
        SOUNDS.put(22, SQUISH_BIG);
        SOUNDS.put(23, SQUISH_SMALL);
        SOUNDS.put(24, FALL_BIG);
        SOUNDS.put(25, FALL_SMALL);
        SOUNDS.put(26, SPLASH);
        SOUNDS.put(27, FIZZ);
        SOUNDS.put(28, FLAP);
        SOUNDS.put(29, SWIM);
        SOUNDS.put(30, DRINK);
        SOUNDS.put(31, EAT);
        SOUNDS.put(32, TAKEOFF);
        SOUNDS.put(33, SHAKE);
        SOUNDS.put(34, PLOP);
        SOUNDS.put(35, LAND);
        SOUNDS.put(36, SADDLE);
        SOUNDS.put(37, ARMOR);
        SOUNDS.put(38, MOB_ARMOR_STAND_PLACE);
        SOUNDS.put(39, ADD_CHEST);
        SOUNDS.put(40, THROW);
        SOUNDS.put(41, ATTACK);
        SOUNDS.put(42, ATTACK_NODAMAGE);
        SOUNDS.put(43, ATTACK_STRONG);
        SOUNDS.put(44, WARN);
        SOUNDS.put(45, SHEAR);
        SOUNDS.put(46, MILK);
        SOUNDS.put(47, THUNDER);
        SOUNDS.put(48, EXPLODE);
        SOUNDS.put(49, FIRE);
        SOUNDS.put(50, IGNITE);
        SOUNDS.put(51, FUSE);
        SOUNDS.put(52, STARE);
        SOUNDS.put(53, SPAWN);
        SOUNDS.put(54, SHOOT);
        SOUNDS.put(55, BREAK_BLOCK);
        SOUNDS.put(56, LAUNCH);
        SOUNDS.put(57, BLAST);
        SOUNDS.put(58, LARGE_BLAST);
        SOUNDS.put(59, TWINKLE);
        SOUNDS.put(60, REMEDY);
        SOUNDS.put(61, UNFECT);
        SOUNDS.put(62, LEVELUP);
        SOUNDS.put(63, BOW_HIT);
        SOUNDS.put(64, BULLET_HIT);
        SOUNDS.put(65, EXTINGUISH_FIRE);
        SOUNDS.put(66, ITEM_FIZZ);
        SOUNDS.put(67, CHEST_OPEN);
        SOUNDS.put(68, CHEST_CLOSED);
        SOUNDS.put(69, SHULKERBOX_OPEN);
        SOUNDS.put(70, SHULKERBOX_CLOSED);
        SOUNDS.put(71, ENDERCHEST_OPEN);
        SOUNDS.put(72, ENDERCHEST_CLOSED);
        SOUNDS.put(73, POWER_ON);
        SOUNDS.put(74, POWER_OFF);
        SOUNDS.put(75, ATTACH);
        SOUNDS.put(76, DETACH);
        SOUNDS.put(77, DENY);
        SOUNDS.put(78, TRIPOD);
        SOUNDS.put(79, POP);
        SOUNDS.put(80, DROP_SLOT);
        SOUNDS.put(81, NOTE);
        SOUNDS.put(82, THORNS);
        SOUNDS.put(83, PISTON_IN);
        SOUNDS.put(84, PISTON_OUT);
        SOUNDS.put(85, PORTAL);
        SOUNDS.put(86, WATER);
        SOUNDS.put(87, LAVA_POP);
        SOUNDS.put(88, LAVA);
        SOUNDS.put(89, BURP);
        SOUNDS.put(90, BUCKET_FILL_WATER);
        SOUNDS.put(91, BUCKET_FILL_LAVA);
        SOUNDS.put(92, BUCKET_EMPTY_WATER);
        SOUNDS.put(93, BUCKET_EMPTY_LAVA);
        SOUNDS.put(94, ARMOR_EQUIP_CHAIN);
        SOUNDS.put(95, ARMOR_EQUIP_DIAMOND);
        SOUNDS.put(96, ARMOR_EQUIP_GENERIC);
        SOUNDS.put(97, ARMOR_EQUIP_GOLD);
        SOUNDS.put(98, ARMOR_EQUIP_IRON);
        SOUNDS.put(99, ARMOR_EQUIP_LEATHER);
        SOUNDS.put(100, ARMOR_EQUIP_ELYTRA);
        SOUNDS.put(101, RECORD_13);
        SOUNDS.put(102, RECORD_CAT);
        SOUNDS.put(103, RECORD_BLOCKS);
        SOUNDS.put(104, RECORD_CHIRP);
        SOUNDS.put(105, RECORD_FAR);
        SOUNDS.put(106, RECORD_MALL);
        SOUNDS.put(107, RECORD_MELLOHI);
        SOUNDS.put(108, RECORD_STAL);
        SOUNDS.put(109, RECORD_STRAD);
        SOUNDS.put(110, RECORD_WARD);
        SOUNDS.put(111, RECORD_11);
        SOUNDS.put(112, RECORD_WAIT);
        SOUNDS.put(113, STOP_RECORD); //Not really a sound
        SOUNDS.put(114, FLOP);
        SOUNDS.put(115, ELDERGUARDIAN_CURSE);
        SOUNDS.put(116, MOB_WARNING);
        SOUNDS.put(117, MOB_WARNING_BABY);
        SOUNDS.put(118, TELEPORT);
        SOUNDS.put(119, SHULKER_OPEN);
        SOUNDS.put(120, SHULKER_CLOSE);
        SOUNDS.put(121, HAGGLE);
        SOUNDS.put(122, HAGGLE_YES);
        SOUNDS.put(123, HAGGLE_NO);
        SOUNDS.put(124, HAGGLE_IDLE);
        SOUNDS.put(125, CHORUSGROW);
        SOUNDS.put(126, CHORUSDEATH);
        SOUNDS.put(127, GLASS);
        SOUNDS.put(128, POTION_BREWED);
        SOUNDS.put(129, CAST_SPELL);
        SOUNDS.put(130, PREPARE_ATTACK);
        SOUNDS.put(131, PREPARE_SUMMON);
        SOUNDS.put(132, PREPARE_WOLOLO);
        SOUNDS.put(133, FANG);
        SOUNDS.put(134, CHARGE);
        SOUNDS.put(135, CAMERA_TAKE_PICTURE);
        SOUNDS.put(136, LEASHKNOT_PLACE);
        SOUNDS.put(137, LEASHKNOT_BREAK);
        SOUNDS.put(138, GROWL);
        SOUNDS.put(139, WHINE);
        SOUNDS.put(140, PANT);
        SOUNDS.put(141, PURR);
        SOUNDS.put(142, PURREOW);
        SOUNDS.put(143, DEATH_MIN_VOLUME);
        SOUNDS.put(144, DEATH_MID_VOLUME);
        SOUNDS.put(145, IMITATE_BLAZE);
        SOUNDS.put(146, IMITATE_CAVE_SPIDER);
        SOUNDS.put(147, IMITATE_CREEPER);
        SOUNDS.put(148, IMITATE_ELDER_GUARDIAN);
        SOUNDS.put(149, IMITATE_ENDER_DRAGON);
        SOUNDS.put(150, IMITATE_ENDERMAN);
        SOUNDS.put(152, IMITATE_EVOCATION_ILLAGER);
        SOUNDS.put(153, IMITATE_GHAST);
        SOUNDS.put(154, IMITATE_HUSK);
        SOUNDS.put(155, IMITATE_ILLUSION_ILLAGER);
        SOUNDS.put(156, IMITATE_MAGMA_CUBE);
        SOUNDS.put(157, IMITATE_POLAR_BEAR);
        SOUNDS.put(158, IMITATE_SHULKER);
        SOUNDS.put(159, IMITATE_SILVERFISH);
        SOUNDS.put(160, IMITATE_SKELETON);
        SOUNDS.put(161, IMITATE_SLIME);
        SOUNDS.put(162, IMITATE_SPIDER);
        SOUNDS.put(163, IMITATE_STRAY);
        SOUNDS.put(164, IMITATE_VEX);
        SOUNDS.put(165, IMITATE_VINDICATION_ILLAGER);
        SOUNDS.put(166, IMITATE_WITCH);
        SOUNDS.put(167, IMITATE_WITHER);
        SOUNDS.put(168, IMITATE_WITHER_SKELETON);
        SOUNDS.put(169, IMITATE_WOLF);
        SOUNDS.put(170, IMITATE_ZOMBIE);
        SOUNDS.put(171, IMITATE_ZOMBIE_PIGMAN);
        SOUNDS.put(172, IMITATE_ZOMBIE_VILLAGER);
        SOUNDS.put(173, BLOCK_END_PORTAL_FRAME_FILL);
        SOUNDS.put(174, BLOCK_END_PORTAL_SPAWN);
        SOUNDS.put(175, RANDOM_ANVIL_USE);
        SOUNDS.put(176, BOTTLE_DRAGONBREATH);
        SOUNDS.put(177, PORTAL_TRAVEL);
        SOUNDS.put(178, ITEM_TRIDENT_HIT);
        SOUNDS.put(179, ITEM_TRIDENT_RETURN);
        SOUNDS.put(180, ITEM_TRIDENT_RIPTIDE_1);
        SOUNDS.put(181, ITEM_TRIDENT_RIPTIDE_2);
        SOUNDS.put(182, ITEM_TRIDENT_RIPTIDE_3);
        SOUNDS.put(183, ITEM_TRIDENT_THROW);
        SOUNDS.put(184, ITEM_TRIDENT_THUNDER);
        SOUNDS.put(185, ITEM_TRIDENT_HIT_GROUND);
        SOUNDS.put(186, DEFAULT);
        SOUNDS.put(188, ELEMENT_CONSTRUCTOR_OPEN);
        SOUNDS.put(189, ICE_BOMB_HIT);
        SOUNDS.put(190, BALLOON_POP);
        SOUNDS.put(191, LT_REACTION_ICE_BOMB);
        SOUNDS.put(192, LT_REACTION_BLEACH);
        SOUNDS.put(193, LT_REACTION_E_PASTE);
        SOUNDS.put(194, LT_REACTION_E_PASTE2);
        SOUNDS.put(199, LT_REACTION_FERTILIZER);
        SOUNDS.put(200, LT_REACTION_FIREBALL);
        SOUNDS.put(201, LT_REACTION_MG_SALT);
        SOUNDS.put(202, LT_REACTION_MISC_FIRE);
        SOUNDS.put(203, LT_REACTION_FIRE);
        SOUNDS.put(204, LT_REACTION_MISC_EXPLOSION);
        SOUNDS.put(205, LT_REACTION_MISC_MYSTICAL);
        SOUNDS.put(206, LT_REACTION_MISC_MYSTICAL2);
        SOUNDS.put(207, LT_REACTION_PRODUCT);
        SOUNDS.put(208, SPARKLER_USE);
        SOUNDS.put(209, GLOWSTICK_USE);
        SOUNDS.put(210, SPARKLER_ACTIVE);
        SOUNDS.put(211, CONVERT_TO_DROWNED);
        SOUNDS.put(212, BUCKET_FILL_FISH);
        SOUNDS.put(213, BUCKET_EMPTY_FISH);
        SOUNDS.put(214, BUBBLE_UP);
        SOUNDS.put(215, BUBBLE_DOWN);
        SOUNDS.put(216, BUBBLE_POP);
        SOUNDS.put(217, BUBBLE_UP_INSIDE);
        SOUNDS.put(218, BUBBLE_DOWN_INSIDE);
        SOUNDS.put(219, HURT_BABY);
        SOUNDS.put(220, DEATH_BABY);
        SOUNDS.put(221, STEP_BABY);
        SOUNDS.put(223, BORN);
        SOUNDS.put(224, BLOCK_TURTLE_EGG_BREAK);
        SOUNDS.put(225, BLOCK_TURTLE_EGG_CRACK);
        SOUNDS.put(226, BLOCK_TURTLE_EGG_HATCH);
        SOUNDS.put(228, BLOCK_TURTLE_EGG_ATTACK);
        SOUNDS.put(229, BEACON_ACTIVATE);
        SOUNDS.put(230, BEACON_AMBIENT);
        SOUNDS.put(231, BEACON_DEACTIVATE);
        SOUNDS.put(232, BEACON_POWER);
        SOUNDS.put(233, CONDUIT_ACTIVATE);
        SOUNDS.put(234, CONDUIT_AMBIENT);
        SOUNDS.put(235, CONDUIT_ATTACK);
        SOUNDS.put(236, CONDUIT_DEACTIVATE);
        SOUNDS.put(237, CONDUIT_SHORT);
        SOUNDS.put(238, SWOOP);
        SOUNDS.put(239, BLOCK_BAMBOO_SAPLING_PLACE);
        SOUNDS.put(240, PRE_SNEEZE);
        SOUNDS.put(241, SNEEZE);
        SOUNDS.put(242, AMBIENT_TAME);
        SOUNDS.put(243, SCARED);
        SOUNDS.put(244, BLOCK_SCAFFOLDING_CLIMB);
        SOUNDS.put(245, CROSSBOW_LOADING_START);
        SOUNDS.put(246, CROSSBOW_LOADING_MIDDLE);
        SOUNDS.put(247, CROSSBOW_LOADING_END);
        SOUNDS.put(248, CROSSBOW_SHOOT);
        SOUNDS.put(249, CROSSBOW_QUICK_CHARGE_START);
        SOUNDS.put(250, CROSSBOW_QUICK_CHARGE_MIDDLE);
        SOUNDS.put(251, CROSSBOW_QUICK_CHARGE_END);
        SOUNDS.put(252, AMBIENT_AGGRESSIVE);
        SOUNDS.put(253, AMBIENT_WORRIED);
        SOUNDS.put(254, CANT_BREED);
        SOUNDS.put(255, UNDEFINED);
    }

    @Override
    public void serialize(ByteBuf buffer, LevelSoundEvent1Packet packet) {
        buffer.writeByte(SOUNDS.get(packet.getSound()));
        BedrockUtils.writeVector3f(buffer, packet.getPosition());
        VarInts.writeInt(buffer, packet.getExtraData());
        VarInts.writeInt(buffer, packet.getPitch());
        buffer.writeBoolean(packet.isBabySound());
        buffer.writeBoolean(packet.isRelativeVolumeDisabled());
    }

    @Override
    public void deserialize(ByteBuf buffer, LevelSoundEvent1Packet packet) {
        packet.setSound(SOUNDS.get(buffer.readUnsignedByte()));
        packet.setPosition(BedrockUtils.readVector3f(buffer));
        packet.setExtraData(VarInts.readInt(buffer));
        packet.setPitch(VarInts.readInt(buffer));
        packet.setBabySound(buffer.readBoolean());
        packet.setRelativeVolumeDisabled(buffer.readBoolean());
    }
}
