/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v313.serializer;

import com.nukkitx.nbt.NbtUtils;
import com.nukkitx.nbt.stream.NBTInputStream;
import com.nukkitx.nbt.stream.NBTOutputStream;
import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.packet.UpdateTradePacket;
import com.nukkitx.protocol.bedrock.v313.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class UpdateTradeSerializer_v313
implements PacketSerializer<UpdateTradePacket> {
    public static final UpdateTradeSerializer_v313 INSTANCE = new UpdateTradeSerializer_v313();

    public void serialize(ByteBuf buffer, UpdateTradePacket packet) {
        buffer.writeByte((int)packet.getWindowId());
        buffer.writeByte((int)packet.getWindowType());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getUnknownInt());
        VarInts.writeInt((ByteBuf)buffer, (int)(packet.isScreen2() ? 40 : 0));
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getTradeTier());
        buffer.writeBoolean(packet.isWilling());
        VarInts.writeLong((ByteBuf)buffer, (long)packet.getTraderUniqueEntityId());
        VarInts.writeLong((ByteBuf)buffer, (long)packet.getPlayerUniqueEntityId());
        BedrockUtils.writeString(buffer, packet.getDisplayName());
        try (NBTOutputStream writer = NbtUtils.createNetworkWriter((OutputStream)new ByteBufOutputStream(buffer));){
            writer.write(packet.getOffers());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deserialize(ByteBuf buffer, UpdateTradePacket packet) {
        packet.setWindowId(buffer.readUnsignedByte());
        packet.setWindowType(buffer.readUnsignedByte());
        packet.setUnknownInt(VarInts.readInt((ByteBuf)buffer));
        packet.setScreen2(VarInts.readInt((ByteBuf)buffer) >= 40);
        packet.setTradeTier(VarInts.readInt((ByteBuf)buffer));
        packet.setWilling(buffer.readBoolean());
        packet.setTraderUniqueEntityId(VarInts.readLong((ByteBuf)buffer));
        packet.setPlayerUniqueEntityId(VarInts.readLong((ByteBuf)buffer));
        packet.setDisplayName(BedrockUtils.readString(buffer));
        try (NBTInputStream reader = NbtUtils.createNetworkReader((InputStream)new ByteBufInputStream(buffer));){
            packet.setOffers(reader.readTag());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private UpdateTradeSerializer_v313() {
    }
}

