/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v313.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.packet.MovePlayerPacket;
import com.nukkitx.protocol.bedrock.v313.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;

public class MovePlayerSerializer_v313
implements PacketSerializer<MovePlayerPacket> {
    public static final MovePlayerSerializer_v313 INSTANCE = new MovePlayerSerializer_v313();

    public void serialize(ByteBuf buffer, MovePlayerPacket packet) {
        VarInts.writeUnsignedLong((ByteBuf)buffer, (long)packet.getRuntimeEntityId());
        BedrockUtils.writeVector3f(buffer, packet.getPosition());
        BedrockUtils.writeVector3f(buffer, packet.getRotation());
        buffer.writeByte(packet.getMode().ordinal());
        buffer.writeBoolean(packet.isOnGround());
        VarInts.writeUnsignedLong((ByteBuf)buffer, (long)packet.getRidingRuntimeEntityId());
        if (packet.getMode() == MovePlayerPacket.Mode.TELEPORT) {
            buffer.writeIntLE(packet.getTeleportationCause().ordinal());
            buffer.writeIntLE(packet.getEntityType());
        }
    }

    public void deserialize(ByteBuf buffer, MovePlayerPacket packet) {
        packet.setRuntimeEntityId(VarInts.readUnsignedLong((ByteBuf)buffer));
        packet.setPosition(BedrockUtils.readVector3f(buffer));
        packet.setRotation(BedrockUtils.readVector3f(buffer));
        packet.setMode(MovePlayerPacket.Mode.values()[buffer.readByte()]);
        packet.setOnGround(buffer.readBoolean());
        packet.setRidingRuntimeEntityId(VarInts.readUnsignedLong((ByteBuf)buffer));
        if (packet.getMode() == MovePlayerPacket.Mode.TELEPORT) {
            packet.setTeleportationCause(MovePlayerPacket.TeleportationCause.byId((int)buffer.readIntLE()));
            packet.setEntityType(buffer.readIntLE());
        }
    }

    private MovePlayerSerializer_v313() {
    }
}

