/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v313.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.packet.MoveEntityAbsolutePacket;
import com.nukkitx.protocol.bedrock.v313.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;

public class MoveEntityAbsoluteSerializer_v313
implements PacketSerializer<MoveEntityAbsolutePacket> {
    public static final MoveEntityAbsoluteSerializer_v313 INSTANCE = new MoveEntityAbsoluteSerializer_v313();
    private static final int FLAG_ON_GROUND = 1;
    private static final int FLAG_TELEPORTED = 2;

    public void serialize(ByteBuf buffer, MoveEntityAbsolutePacket packet) {
        VarInts.writeUnsignedLong((ByteBuf)buffer, (long)packet.getRuntimeEntityId());
        int flags = 0;
        if (packet.isOnGround()) {
            flags |= 1;
        }
        if (packet.isTeleported()) {
            flags |= 2;
        }
        buffer.writeByte(flags);
        BedrockUtils.writeVector3f(buffer, packet.getPosition());
        BedrockUtils.writeByteRotation(buffer, packet.getRotation());
    }

    public void deserialize(ByteBuf buffer, MoveEntityAbsolutePacket packet) {
        packet.setRuntimeEntityId(VarInts.readUnsignedLong((ByteBuf)buffer));
        short flags = buffer.readUnsignedByte();
        packet.setOnGround((flags & 1) != 0);
        packet.setTeleported((flags & 2) != 0);
        packet.setPosition(BedrockUtils.readVector3f(buffer));
        packet.setRotation(BedrockUtils.readByteRotation(buffer));
    }

    private MoveEntityAbsoluteSerializer_v313() {
    }
}

