/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v313.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.data.LevelEventType;
import com.nukkitx.protocol.bedrock.packet.LevelEventPacket;
import com.nukkitx.protocol.bedrock.v313.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import com.nukkitx.protocol.util.Int2ObjectBiMap;
import io.netty.buffer.ByteBuf;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class LevelEventSerializer_v313
implements PacketSerializer<LevelEventPacket> {
    public static final LevelEventSerializer_v313 INSTANCE = new LevelEventSerializer_v313();
    private static final InternalLogger log = InternalLoggerFactory.getInstance(LevelEventSerializer_v313.class);
    private static final Int2ObjectBiMap<LevelEventType> events = new Int2ObjectBiMap();

    public void serialize(ByteBuf buffer, LevelEventPacket packet) {
        VarInts.writeInt((ByteBuf)buffer, (int)events.get((Object)packet.getType()));
        BedrockUtils.writeVector3f(buffer, packet.getPosition());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getData());
    }

    public void deserialize(ByteBuf buffer, LevelEventPacket packet) {
        int eventId = VarInts.readInt((ByteBuf)buffer);
        packet.setType((LevelEventType)events.get(eventId));
        if (packet.getType() == null) {
            log.debug("Unknown Level Event {} received", (Object)eventId);
        }
        packet.setPosition(BedrockUtils.readVector3f(buffer));
        packet.setData(VarInts.readInt((ByteBuf)buffer));
    }

    private LevelEventSerializer_v313() {
    }

    static {
        events.put(1000, (Object)LevelEventType.SOUND_CLICK);
        events.put(1001, (Object)LevelEventType.SOUND_CLICK_FAIL);
        events.put(1002, (Object)LevelEventType.SOUND_SHOOT);
        events.put(1003, (Object)LevelEventType.SOUND_DOOR);
        events.put(1004, (Object)LevelEventType.SOUND_FIZZ);
        events.put(1005, (Object)LevelEventType.SOUND_IGNITE);
        events.put(1007, (Object)LevelEventType.SOUND_GHAST);
        events.put(1008, (Object)LevelEventType.SOUND_GHAST_SHOOT);
        events.put(1009, (Object)LevelEventType.SOUND_BLAZE_SHOOT);
        events.put(1010, (Object)LevelEventType.SOUND_DOOR_BUMP);
        events.put(1012, (Object)LevelEventType.SOUND_DOOR_CRASH);
        events.put(1018, (Object)LevelEventType.SOUND_ENDERMAN_TELEPORT);
        events.put(1020, (Object)LevelEventType.SOUND_ANVIL_BREAK);
        events.put(1021, (Object)LevelEventType.SOUND_ANVIL_USE);
        events.put(1022, (Object)LevelEventType.SOUND_ANVIL_FALL);
        events.put(1030, (Object)LevelEventType.SOUND_POP);
        events.put(1032, (Object)LevelEventType.SOUND_PORTAL);
        events.put(1040, (Object)LevelEventType.SOUND_ITEMFRAME_ADD_ITEM);
        events.put(1041, (Object)LevelEventType.SOUND_ITEMFRAME_REMOVE);
        events.put(1042, (Object)LevelEventType.SOUND_ITEMFRAME_PLACE);
        events.put(1043, (Object)LevelEventType.SOUND_ITEMFRAME_REMOVE_ITEM);
        events.put(1044, (Object)LevelEventType.SOUND_ITEMFRAME_ROTATE_ITEM);
        events.put(1050, (Object)LevelEventType.SOUND_CAMERA);
        events.put(1051, (Object)LevelEventType.SOUND_ORB);
        events.put(1052, (Object)LevelEventType.SOUND_TOTEM);
        events.put(1060, (Object)LevelEventType.SOUND_ARMOR_STAND_BREAK);
        events.put(1061, (Object)LevelEventType.SOUND_ARMOR_STAND_HIT);
        events.put(1062, (Object)LevelEventType.SOUND_ARMOR_STAND_FALL);
        events.put(1063, (Object)LevelEventType.SOUND_ARMOR_STAND_PLACE);
        events.put(2000, (Object)LevelEventType.SHOOT);
        events.put(2001, (Object)LevelEventType.DESTROY);
        events.put(2002, (Object)LevelEventType.SPLASH);
        events.put(2003, (Object)LevelEventType.EYE_DESPAWN);
        events.put(2004, (Object)LevelEventType.ENTITY_SPAWN);
        events.put(2005, (Object)LevelEventType.BONEMEAL);
        events.put(2006, (Object)LevelEventType.GUARDIAN_CURSE);
        events.put(2008, (Object)LevelEventType.BLOCK_FORCE_FIELD);
        events.put(2009, (Object)LevelEventType.PROJECTILE_HIT);
        events.put(2010, (Object)LevelEventType.DRAGON_EGG_TELEPORT);
        events.put(2013, (Object)LevelEventType.ENDERMAN_TELEPORT);
        events.put(2014, (Object)LevelEventType.PUNCH_BLOCK);
        events.put(2015, (Object)LevelEventType.WATER_SPLASH);
        events.put(3001, (Object)LevelEventType.START_RAIN);
        events.put(3002, (Object)LevelEventType.START_THUNDER);
        events.put(3003, (Object)LevelEventType.STOP_RAIN);
        events.put(3004, (Object)LevelEventType.STOP_THUNDER);
        events.put(3005, (Object)LevelEventType.PAUSE_GAME);
        events.put(3500, (Object)LevelEventType.REDSTONE_TRIGGER);
        events.put(3501, (Object)LevelEventType.CAULDRON_EXPLODE);
        events.put(3502, (Object)LevelEventType.CAULDRON_DYE_ARMOR);
        events.put(3503, (Object)LevelEventType.CAULDRON_CLEAN_ARMOR);
        events.put(3504, (Object)LevelEventType.CAULDRON_FILL_POTION);
        events.put(3505, (Object)LevelEventType.CAULDRON_TAKE_POTION);
        events.put(3506, (Object)LevelEventType.CAULDRON_FILL_WATER);
        events.put(3507, (Object)LevelEventType.CAULDRON_TAKE_WATER);
        events.put(3508, (Object)LevelEventType.CAULDRON_ADD_DYE);
        events.put(3509, (Object)LevelEventType.CAULDRON_CLEAN_BANNER);
        events.put(3600, (Object)LevelEventType.BLOCK_START_BREAK);
        events.put(3601, (Object)LevelEventType.BLOCK_STOP_BREAK);
        events.put(4000, (Object)LevelEventType.SET_DATA);
        events.put(9800, (Object)LevelEventType.PLAYERS_SLEEPING);
        events.put(16385, (Object)LevelEventType.PARTICLE_BUBBLE);
        events.put(16386, (Object)LevelEventType.PARTICLE_CRITICAL);
        events.put(16387, (Object)LevelEventType.PARTICLE_BLOCK_FORCE_FIELD);
        events.put(16388, (Object)LevelEventType.PARTICLE_SMOKE);
        events.put(16389, (Object)LevelEventType.PARTICLE_EXPLODE);
        events.put(16390, (Object)LevelEventType.PARTICLE_EVAPORATION);
        events.put(16391, (Object)LevelEventType.PARTICLE_FLAME);
        events.put(16392, (Object)LevelEventType.PARTICLE_LAVA);
        events.put(16393, (Object)LevelEventType.PARTICLE_LARGE_SMOKE);
        events.put(16394, (Object)LevelEventType.PARTICLE_REDSTONE);
        events.put(16395, (Object)LevelEventType.PARTICLE_RISING_RED_DUST);
        events.put(16396, (Object)LevelEventType.PARTICLE_ITEM_BREAK);
        events.put(16397, (Object)LevelEventType.PARTICLE_SNOWBALL_POOF);
        events.put(16398, (Object)LevelEventType.PARTICLE_HUGE_EXPLODE);
        events.put(16399, (Object)LevelEventType.PARTICLE_HUGE_EXPLODE_SEED);
        events.put(16400, (Object)LevelEventType.PARTICLE_MOB_FLAME);
        events.put(16401, (Object)LevelEventType.PARTICLE_HEART);
        events.put(16402, (Object)LevelEventType.PARTICLE_TERRAIN);
        events.put(16403, (Object)LevelEventType.PARTICLE_TOWN_AURA);
        events.put(16404, (Object)LevelEventType.PARTICLE_PORTAL);
        events.put(16405, (Object)LevelEventType.PARTICLE_SPLASH);
        events.put(16406, (Object)LevelEventType.PARTICLE_WATER_WAKE);
        events.put(16407, (Object)LevelEventType.PARTICLE_DRIP_WATER);
        events.put(16408, (Object)LevelEventType.PARTICLE_DRIP_LAVA);
        events.put(16409, (Object)LevelEventType.PARTICLE_FALLING_DUST);
        events.put(16410, (Object)LevelEventType.PARTICLE_MOB_SPELL);
        events.put(16411, (Object)LevelEventType.PARTICLE_MOB_SPELL_AMBIENT);
        events.put(16412, (Object)LevelEventType.PARTICLE_MOB_SPELL_INSTANTANEOUS);
        events.put(16413, (Object)LevelEventType.PARTICLE_INK);
        events.put(16414, (Object)LevelEventType.PARTICLE_SLIME);
        events.put(16415, (Object)LevelEventType.PARTICLE_RAIN_SPLASH);
        events.put(16416, (Object)LevelEventType.PARTICLE_VILLAGER_ANGRY);
        events.put(16417, (Object)LevelEventType.PARTICLE_VILLAGER_HAPPY);
        events.put(16418, (Object)LevelEventType.PARTICLE_ENCHANTMENT_TABLE);
        events.put(16419, (Object)LevelEventType.PARTICLE_TRACKING_EMITTER);
        events.put(16420, (Object)LevelEventType.PARTICLE_NOTE);
        events.put(16421, (Object)LevelEventType.PARTICLE_WITCH_SPELL);
        events.put(16422, (Object)LevelEventType.PARTICLE_CARROT);
        events.put(16424, (Object)LevelEventType.PARTICLE_END_ROD);
        events.put(16425, (Object)LevelEventType.PARTICLE_DRAGONS_BREATH);
    }
}

