/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v313.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.packet.BossEventPacket;
import com.nukkitx.protocol.bedrock.v313.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;

public class BossEventSerializer_v313
implements PacketSerializer<BossEventPacket> {
    public static final BossEventSerializer_v313 INSTANCE = new BossEventSerializer_v313();

    public void serialize(ByteBuf buffer, BossEventPacket packet) {
        VarInts.writeLong((ByteBuf)buffer, (long)packet.getBossUniqueEntityId());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)packet.getAction().ordinal());
        switch (packet.getAction()) {
            case REGISTER_PLAYER: 
            case UNREGISTER_PLAYER: {
                VarInts.writeLong((ByteBuf)buffer, (long)packet.getPlayerUniqueEntityId());
                break;
            }
            case SHOW: {
                BedrockUtils.writeString(buffer, packet.getTitle());
                buffer.writeFloatLE(packet.getHealthPercentage());
            }
            case DARKEN_SKY: {
                buffer.writeShortLE(packet.getDarkenSky());
            }
            case OVERLAY: {
                VarInts.writeUnsignedInt((ByteBuf)buffer, (long)packet.getColor());
                VarInts.writeUnsignedInt((ByteBuf)buffer, (long)packet.getOverlay());
                break;
            }
            case HEALTH_PERCENTAGE: {
                buffer.writeFloatLE(packet.getHealthPercentage());
                break;
            }
            case TITLE: {
                BedrockUtils.writeString(buffer, packet.getTitle());
                break;
            }
            default: {
                throw new RuntimeException("BossEvent transactionType was unknown!");
            }
        }
    }

    public void deserialize(ByteBuf buffer, BossEventPacket packet) {
        packet.setBossUniqueEntityId((long)VarInts.readInt((ByteBuf)buffer));
        BossEventPacket.Action action = BossEventPacket.Action.values()[VarInts.readUnsignedInt((ByteBuf)buffer)];
        packet.setAction(action);
        switch (action) {
            case REGISTER_PLAYER: 
            case UNREGISTER_PLAYER: {
                packet.setPlayerUniqueEntityId(VarInts.readLong((ByteBuf)buffer));
                break;
            }
            case SHOW: {
                packet.setTitle(BedrockUtils.readString(buffer));
                packet.setHealthPercentage(buffer.readFloatLE());
            }
            case DARKEN_SKY: {
                packet.setDarkenSky(buffer.readUnsignedShortLE());
            }
            case OVERLAY: {
                packet.setColor(VarInts.readUnsignedInt((ByteBuf)buffer));
                packet.setOverlay(VarInts.readUnsignedInt((ByteBuf)buffer));
                break;
            }
            case HEALTH_PERCENTAGE: {
                packet.setHealthPercentage(buffer.readFloatLE());
                break;
            }
            case TITLE: {
                packet.setTitle(BedrockUtils.readString(buffer));
            }
        }
    }

    private BossEventSerializer_v313() {
    }
}

