/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v313.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.network.util.Preconditions;
import com.nukkitx.protocol.bedrock.data.CommandData;
import com.nukkitx.protocol.bedrock.data.CommandEnumData;
import com.nukkitx.protocol.bedrock.data.CommandParamData;
import com.nukkitx.protocol.bedrock.data.CommandParamType;
import com.nukkitx.protocol.bedrock.packet.AvailableCommandsPacket;
import com.nukkitx.protocol.bedrock.v313.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import com.nukkitx.protocol.util.Int2ObjectBiMap;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.ObjIntConsumer;
import java.util.function.ToIntFunction;

public class AvailableCommandsSerializer_v313
implements PacketSerializer<AvailableCommandsPacket> {
    public static final AvailableCommandsSerializer_v313 INSTANCE = new AvailableCommandsSerializer_v313();
    private static final ObjIntConsumer<ByteBuf> WRITE_BYTE = ByteBuf::writeByte;
    private static final ObjIntConsumer<ByteBuf> WRITE_SHORT = ByteBuf::writeShortLE;
    private static final ObjIntConsumer<ByteBuf> WRITE_INT = ByteBuf::writeIntLE;
    private static final ToIntFunction<ByteBuf> READ_BYTE = ByteBuf::readUnsignedByte;
    private static final ToIntFunction<ByteBuf> READ_SHORT = ByteBuf::readUnsignedShortLE;
    private static final ToIntFunction<ByteBuf> READ_INT = ByteBuf::readIntLE;
    private static final Int2ObjectBiMap<CommandParamData.Type> PARAM_TYPES = new Int2ObjectBiMap();

    public void serialize(ByteBuf buffer, AvailableCommandsPacket packet) {
        ObjectOpenHashSet enumValuesSet = new ObjectOpenHashSet();
        ObjectOpenHashSet postfixSet = new ObjectOpenHashSet();
        ObjectOpenHashSet enumsSet = new ObjectOpenHashSet();
        ObjectOpenHashSet softEnumsSet = new ObjectOpenHashSet();
        for (CommandData data : packet.getCommands()) {
            if (data.getAliases() != null) {
                Collections.addAll(enumValuesSet, data.getAliases().getValues());
                enumsSet.add(data.getAliases());
            }
            CommandParamData[][] commandParamDataArray = data.getOverloads();
            int n = commandParamDataArray.length;
            for (int i = 0; i < n; ++i) {
                CommandParamData[] overload;
                for (CommandParamData parameter : overload = commandParamDataArray[i]) {
                    String postfix;
                    CommandEnumData commandEnumData = parameter.getEnumData();
                    if (commandEnumData != null) {
                        if (commandEnumData.isSoft()) {
                            softEnumsSet.add(commandEnumData);
                        } else {
                            Collections.addAll(enumValuesSet, commandEnumData.getValues());
                            enumsSet.add(commandEnumData);
                        }
                    }
                    if ((postfix = parameter.getPostfix()) == null) continue;
                    postfixSet.add(postfix);
                }
            }
        }
        ArrayList enumValues = new ArrayList(enumValuesSet);
        ArrayList postFixes = new ArrayList(postfixSet);
        ArrayList enums = new ArrayList(enumsSet);
        ArrayList softEnums = new ArrayList(softEnumsSet);
        int valuesSize = enumValues.size();
        ObjIntConsumer<ByteBuf> indexWriter = valuesSize < 256 ? WRITE_BYTE : (valuesSize < 65536 ? WRITE_SHORT : WRITE_INT);
        BedrockUtils.writeArray(buffer, enumValues, BedrockUtils::writeString);
        BedrockUtils.writeArray(buffer, postFixes, BedrockUtils::writeString);
        BedrockUtils.writeArray(buffer, enums, (buf, commandEnum) -> {
            BedrockUtils.writeString(buf, commandEnum.getName());
            VarInts.writeUnsignedInt((ByteBuf)buffer, (long)commandEnum.getValues().length);
            for (String value : commandEnum.getValues()) {
                int index = enumValues.indexOf(value);
                Preconditions.checkArgument((index > -1 ? 1 : 0) != 0, (Object)"Invalid enum value detected");
                indexWriter.accept((ByteBuf)buf, index);
            }
        });
        BedrockUtils.writeArray(buffer, packet.getCommands(), (buf, commandData) -> {
            BedrockUtils.writeString(buf, commandData.getName());
            BedrockUtils.writeString(buf, commandData.getDescription());
            int flags = 0;
            for (CommandData.Flag flag : commandData.getFlags()) {
                flags = (byte)(flags | 1 << flag.ordinal());
            }
            buf.writeByte(flags);
            buf.writeByte((int)commandData.getPermission());
            CommandEnumData aliases = commandData.getAliases();
            buf.writeIntLE(enums.indexOf(aliases));
            CommandParamData[][] overloads = commandData.getOverloads();
            VarInts.writeUnsignedInt((ByteBuf)buf, (long)overloads.length);
            for (CommandParamData[] overload : overloads) {
                VarInts.writeUnsignedInt((ByteBuf)buf, (long)overload.length);
                for (CommandParamData param : overload) {
                    BedrockUtils.writeString(buf, param.getName());
                    int index = 0;
                    boolean postfix = false;
                    boolean enumData = false;
                    boolean softEnum = false;
                    if (param.getPostfix() != null) {
                        postfix = true;
                        index = postFixes.indexOf(param.getPostfix());
                    } else if (param.getEnumData() != null) {
                        if (param.getEnumData().isSoft()) {
                            softEnum = true;
                            index = softEnums.indexOf(param.getEnumData());
                        } else {
                            enumData = true;
                            index = enums.indexOf(param.getEnumData());
                        }
                    } else if (param.getType() != null) {
                        index = PARAM_TYPES.get((Object)param.getType());
                    } else {
                        throw new IllegalStateException("No param type specified");
                    }
                    CommandParamType type = new CommandParamType(index, enumData, softEnum, postfix);
                    buf.writeIntLE(type.serialize());
                    buf.writeBoolean(param.isOptional());
                }
            }
        });
        BedrockUtils.writeArray(buffer, softEnums, BedrockUtils::writeCommandEnumData);
    }

    public void deserialize(ByteBuf buffer, AvailableCommandsPacket packet) {
        ArrayList enumValues = new ArrayList();
        ArrayList postFixes = new ArrayList();
        ArrayList enums = new ArrayList();
        ArrayList commands = new ArrayList();
        ArrayList softEnums = new ArrayList();
        BedrockUtils.readArray(buffer, enumValues, BedrockUtils::readString);
        BedrockUtils.readArray(buffer, postFixes, BedrockUtils::readString);
        int valuesSize = enumValues.size();
        ToIntFunction<ByteBuf> indexReader = valuesSize < 256 ? READ_BYTE : (valuesSize < 65536 ? READ_SHORT : READ_INT);
        BedrockUtils.readArray(buffer, enums, buf -> {
            String name = BedrockUtils.readString(buf);
            int length = VarInts.readUnsignedInt((ByteBuf)buffer);
            String[] values = new String[length];
            for (int i = 0; i < length; ++i) {
                values[i] = (String)enumValues.get(indexReader.applyAsInt((ByteBuf)buf));
            }
            return new CommandEnumData(name, values, false);
        });
        BedrockUtils.readArray(buffer, commands, buf -> {
            String name = BedrockUtils.readString(buf);
            String description = BedrockUtils.readString(buf);
            byte flags = buf.readByte();
            byte permissions = buf.readByte();
            int aliasesIndex = buf.readIntLE();
            CommandParamData.Builder[][] overloads = new CommandParamData.Builder[VarInts.readUnsignedInt((ByteBuf)buf)][];
            for (int i = 0; i < overloads.length; ++i) {
                overloads[i] = new CommandParamData.Builder[VarInts.readUnsignedInt((ByteBuf)buf)];
                for (int i2 = 0; i2 < overloads[i].length; ++i2) {
                    String parameterName = BedrockUtils.readString(buf);
                    CommandParamType type = CommandParamType.deserialize((int)buf.readIntLE());
                    boolean optional = buf.readBoolean();
                    overloads[i][i2] = new CommandParamData.Builder(parameterName, type, optional);
                }
            }
            return new CommandData.Builder(name, description, flags, permissions, aliasesIndex, (CommandParamData.Builder[][])overloads);
        });
        BedrockUtils.readArray(buffer, softEnums, buf -> BedrockUtils.readCommandEnumData(buffer, true));
        for (CommandData.Builder command : commands) {
            byte flags = command.getFlags();
            ArrayList<CommandData.Flag> flagList = new ArrayList<CommandData.Flag>();
            for (int i = 0; i < 6; ++i) {
                if ((flags >>> i & 0xF) == 0) continue;
                flagList.add(CommandData.Flag.values()[i]);
            }
            int aliasesIndex = command.getAliases();
            CommandEnumData aliases = aliasesIndex == -1 ? null : (CommandEnumData)enums.get(aliasesIndex);
            CommandParamData.Builder[][] overloadBuilders = command.getOverloads();
            CommandParamData[][] overloads = new CommandParamData[overloadBuilders.length][];
            for (int i = 0; i < overloadBuilders.length; ++i) {
                overloads[i] = new CommandParamData[overloadBuilders[i].length];
                for (int i2 = 0; i2 < overloadBuilders[i].length; ++i2) {
                    String name = overloadBuilders[i][i2].getName();
                    CommandParamType type = overloadBuilders[i][i2].getType();
                    boolean optional = overloadBuilders[i][i2].isOptional();
                    String postfix = null;
                    CommandEnumData enumData = null;
                    CommandParamData.Type paramType = null;
                    if (type.isPostfix()) {
                        postfix = (String)postFixes.get(type.getValue());
                    } else if (type.isCommandEnum()) {
                        enumData = (CommandEnumData)enums.get(type.getValue());
                    } else if (type.isSoftEnum()) {
                        enumData = (CommandEnumData)softEnums.get(type.getValue());
                    } else {
                        paramType = (CommandParamData.Type)PARAM_TYPES.get(type.getValue());
                    }
                    overloads[i][i2] = new CommandParamData(name, optional, enumData, paramType, postfix, Collections.emptyList());
                }
            }
            packet.getCommands().add(new CommandData(command.getName(), command.getDescription(), flagList, command.getPermission(), aliases, (CommandParamData[][])overloads));
        }
    }

    private AvailableCommandsSerializer_v313() {
    }

    static {
        PARAM_TYPES.put(1, (Object)CommandParamData.Type.INT);
        PARAM_TYPES.put(2, (Object)CommandParamData.Type.FLOAT);
        PARAM_TYPES.put(3, (Object)CommandParamData.Type.VALUE);
        PARAM_TYPES.put(4, (Object)CommandParamData.Type.WILDCARD_INT);
        PARAM_TYPES.put(5, (Object)CommandParamData.Type.OPERATOR);
        PARAM_TYPES.put(6, (Object)CommandParamData.Type.TARGET);
        PARAM_TYPES.put(7, (Object)CommandParamData.Type.WILDCARD_TARGET);
        PARAM_TYPES.put(14, (Object)CommandParamData.Type.FILE_PATH);
        PARAM_TYPES.put(18, (Object)CommandParamData.Type.INT_RANGE);
        PARAM_TYPES.put(26, (Object)CommandParamData.Type.STRING);
        PARAM_TYPES.put(28, (Object)CommandParamData.Type.POSITION);
        PARAM_TYPES.put(31, (Object)CommandParamData.Type.MESSAGE);
        PARAM_TYPES.put(33, (Object)CommandParamData.Type.TEXT);
        PARAM_TYPES.put(36, (Object)CommandParamData.Type.JSON);
        PARAM_TYPES.put(43, (Object)CommandParamData.Type.COMMAND);
    }
}

