/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v313;

import com.nukkitx.math.vector.Vector2f;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.nbt.NbtUtils;
import com.nukkitx.nbt.stream.NBTInputStream;
import com.nukkitx.nbt.stream.NBTOutputStream;
import com.nukkitx.nbt.tag.CompoundTag;
import com.nukkitx.nbt.tag.Tag;
import com.nukkitx.network.VarInts;
import com.nukkitx.network.util.Preconditions;
import com.nukkitx.protocol.bedrock.data.Attribute;
import com.nukkitx.protocol.bedrock.data.CommandEnumData;
import com.nukkitx.protocol.bedrock.data.CommandOriginData;
import com.nukkitx.protocol.bedrock.data.CommandOutputMessage;
import com.nukkitx.protocol.bedrock.data.EntityData;
import com.nukkitx.protocol.bedrock.data.EntityDataMap;
import com.nukkitx.protocol.bedrock.data.EntityFlag;
import com.nukkitx.protocol.bedrock.data.EntityFlags;
import com.nukkitx.protocol.bedrock.data.EntityLink;
import com.nukkitx.protocol.bedrock.data.GameRuleData;
import com.nukkitx.protocol.bedrock.data.InventoryActionData;
import com.nukkitx.protocol.bedrock.data.InventorySource;
import com.nukkitx.protocol.bedrock.data.ItemData;
import com.nukkitx.protocol.bedrock.packet.ResourcePackStackPacket;
import com.nukkitx.protocol.bedrock.packet.ResourcePacksInfoPacket;
import com.nukkitx.protocol.bedrock.util.LittleEndianByteBufOutputStream;
import com.nukkitx.protocol.bedrock.v313.serializer.GameRulesChangedSerializer_v313;
import com.nukkitx.protocol.util.Int2ObjectBiMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.util.AsciiString;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class BedrockUtils {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(BedrockUtils.class);
    private static final Int2ObjectBiMap<EntityData> METADATAS = new Int2ObjectBiMap();
    private static final Int2ObjectBiMap<EntityFlag> METADATA_FLAGS = new Int2ObjectBiMap();
    private static final Int2ObjectBiMap<EntityData.Type> METADATA_TYPES = new Int2ObjectBiMap(9);
    private static final byte[] EMPTY = new byte[0];

    public static byte[] readByteArray(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        byte[] bytes = new byte[VarInts.readUnsignedInt((ByteBuf)buffer)];
        buffer.readBytes(bytes);
        return bytes;
    }

    public static void writeByteArray(ByteBuf buffer, byte[] bytes) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        if (bytes == null) {
            bytes = EMPTY;
        }
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)bytes.length);
        buffer.writeBytes(bytes);
    }

    public static String readString(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        return new String(BedrockUtils.readByteArray(buffer), StandardCharsets.UTF_8);
    }

    public static void writeString(ByteBuf buffer, String string) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        BedrockUtils.writeByteArray(buffer, string == null ? null : string.getBytes(StandardCharsets.UTF_8));
    }

    public static AsciiString readLEAsciiString(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        int length = buffer.readIntLE();
        byte[] bytes = new byte[length];
        buffer.readBytes(bytes);
        return new AsciiString(bytes);
    }

    public static void writeLEAsciiString(ByteBuf buffer, AsciiString string) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)string, (Object)"string");
        buffer.writeIntLE(string.length());
        buffer.writeBytes(string.toByteArray());
    }

    public static AsciiString readVarIntAsciiString(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        int length = VarInts.readUnsignedInt((ByteBuf)buffer);
        byte[] bytes = new byte[length];
        buffer.readBytes(bytes);
        return new AsciiString(bytes);
    }

    public static void writeVarIntAsciiString(ByteBuf buffer, AsciiString string) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)string, (Object)"string");
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)string.length());
        buffer.writeBytes(string.toByteArray());
    }

    public static UUID readUuid(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        return new UUID(buffer.readLong(), buffer.readLong());
    }

    public static void writeUuid(ByteBuf buffer, UUID uuid) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)uuid, (Object)"uuid");
        buffer.writeLong(uuid.getMostSignificantBits());
        buffer.writeLong(uuid.getLeastSignificantBits());
    }

    public static Vector3f readVector3f(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        float x = buffer.readFloatLE();
        float y = buffer.readFloatLE();
        float z = buffer.readFloatLE();
        return Vector3f.from((float)x, (float)y, (float)z);
    }

    public static void writeVector3f(ByteBuf buffer, Vector3f vector3f) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)vector3f, (Object)"vector3f");
        buffer.writeFloatLE(vector3f.getX());
        buffer.writeFloatLE(vector3f.getY());
        buffer.writeFloatLE(vector3f.getZ());
    }

    public static Vector2f readVector2f(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        float x = buffer.readFloatLE();
        float y = buffer.readFloatLE();
        return Vector2f.from((float)x, (float)y);
    }

    public static void writeVector2f(ByteBuf buffer, Vector2f vector2f) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)vector2f, (Object)"vector2f");
        buffer.writeFloatLE(vector2f.getX());
        buffer.writeFloatLE(vector2f.getY());
    }

    public static Vector3i readVector3i(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        int x = VarInts.readInt((ByteBuf)buffer);
        int y = VarInts.readInt((ByteBuf)buffer);
        int z = VarInts.readInt((ByteBuf)buffer);
        return Vector3i.from((int)x, (int)y, (int)z);
    }

    public static void writeVector3i(ByteBuf buffer, Vector3i vector3i) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)vector3i, (Object)"vector3i");
        VarInts.writeInt((ByteBuf)buffer, (int)vector3i.getX());
        VarInts.writeInt((ByteBuf)buffer, (int)vector3i.getY());
        VarInts.writeInt((ByteBuf)buffer, (int)vector3i.getZ());
    }

    public static Vector3i readBlockPosition(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        int x = VarInts.readInt((ByteBuf)buffer);
        int y = VarInts.readUnsignedInt((ByteBuf)buffer);
        int z = VarInts.readInt((ByteBuf)buffer);
        return Vector3i.from((int)x, (int)y, (int)z);
    }

    public static void writeBlockPosition(ByteBuf buffer, Vector3i blockPosition) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)blockPosition, (Object)"blockPosition");
        VarInts.writeInt((ByteBuf)buffer, (int)blockPosition.getX());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)blockPosition.getY());
        VarInts.writeInt((ByteBuf)buffer, (int)blockPosition.getZ());
    }

    public static Vector3f readByteRotation(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        float pitch = BedrockUtils.readByteAngle(buffer);
        float yaw = BedrockUtils.readByteAngle(buffer);
        float roll = BedrockUtils.readByteAngle(buffer);
        return Vector3f.from((float)pitch, (float)yaw, (float)roll);
    }

    public static void writeByteRotation(ByteBuf buffer, Vector3f rotation) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)rotation, (Object)"rotation");
        BedrockUtils.writeByteAngle(buffer, rotation.getX());
        BedrockUtils.writeByteAngle(buffer, rotation.getY());
        BedrockUtils.writeByteAngle(buffer, rotation.getZ());
    }

    public static float readByteAngle(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        return (float)buffer.readByte() * 1.40625f;
    }

    public static void writeByteAngle(ByteBuf buffer, float angle) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        buffer.writeByte((int)((byte)(angle / 1.40625f)));
    }

    public static Attribute readEntityAttribute(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        String name = BedrockUtils.readString(buffer);
        float min = buffer.readFloatLE();
        float max = buffer.readFloatLE();
        float val = buffer.readFloatLE();
        return new Attribute(name, min, max, val, max);
    }

    public static void writeEntityAttribute(ByteBuf buffer, Attribute attribute) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)attribute, (Object)"attribute");
        BedrockUtils.writeString(buffer, attribute.getName());
        buffer.writeFloatLE(attribute.getMinimum());
        buffer.writeFloatLE(attribute.getMaximum());
        buffer.writeFloatLE(attribute.getValue());
    }

    public static Attribute readPlayerAttribute(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        float min = buffer.readFloatLE();
        float max = buffer.readFloatLE();
        float val = buffer.readFloatLE();
        float def = buffer.readFloatLE();
        String name = BedrockUtils.readString(buffer);
        return new Attribute(name, min, max, val, def);
    }

    public static void writePlayerAttribute(ByteBuf buffer, Attribute attribute) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)attribute, (Object)"attribute");
        buffer.writeFloatLE(attribute.getMinimum());
        buffer.writeFloatLE(attribute.getMaximum());
        buffer.writeFloatLE(attribute.getValue());
        buffer.writeFloatLE(attribute.getDefaultValue());
        BedrockUtils.writeString(buffer, attribute.getName());
    }

    public static EntityLink readEntityLink(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        long from = VarInts.readLong((ByteBuf)buffer);
        long to = VarInts.readLong((ByteBuf)buffer);
        short type = buffer.readUnsignedByte();
        boolean immediate = buffer.readBoolean();
        return new EntityLink(from, to, EntityLink.Type.values()[type], immediate);
    }

    public static void writeEntityLink(ByteBuf buffer, EntityLink entityLink) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)entityLink, (Object)"entityLink");
        VarInts.writeLong((ByteBuf)buffer, (long)entityLink.getFrom());
        VarInts.writeLong((ByteBuf)buffer, (long)entityLink.getTo());
        buffer.writeByte(entityLink.getType().ordinal());
        buffer.writeBoolean(entityLink.isImmediate());
    }

    public static ItemData readItemData(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        int id = VarInts.readInt((ByteBuf)buffer);
        if (id == 0) {
            return ItemData.AIR;
        }
        int aux = VarInts.readInt((ByteBuf)buffer);
        short damage = (short)(aux >> 8);
        if (damage == Short.MAX_VALUE) {
            damage = -1;
        }
        int count = aux & 0xFF;
        short nbtSize = buffer.readShortLE();
        CompoundTag compoundTag = null;
        if (nbtSize > 0) {
            try (NBTInputStream reader = NbtUtils.createReaderLE((InputStream)new ByteBufInputStream(buffer.readSlice((int)nbtSize)));){
                Tag tag = reader.readTag();
                if (tag instanceof CompoundTag) {
                    compoundTag = (CompoundTag)tag;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to load NBT data", e);
            }
        }
        String[] canPlace = new String[VarInts.readInt((ByteBuf)buffer)];
        for (int i = 0; i < canPlace.length; ++i) {
            canPlace[i] = BedrockUtils.readString(buffer);
        }
        String[] canBreak = new String[VarInts.readInt((ByteBuf)buffer)];
        for (int i = 0; i < canBreak.length; ++i) {
            canBreak[i] = BedrockUtils.readString(buffer);
        }
        return ItemData.of((int)id, (short)damage, (int)count, (CompoundTag)compoundTag, (String[])canPlace, (String[])canBreak);
    }

    public static void writeItemData(ByteBuf buffer, ItemData item) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)item, (Object)"item");
        int id = item.getId();
        if (id == 0) {
            buffer.writeByte(0);
            return;
        }
        VarInts.writeInt((ByteBuf)buffer, (int)id);
        int damage = item.getDamage();
        if (damage == -1) {
            damage = Short.MAX_VALUE;
        }
        VarInts.writeInt((ByteBuf)buffer, (int)(damage << 8 | item.getCount() & 0xFF));
        int sizeIndex = buffer.writerIndex();
        buffer.writeShortLE(0);
        if (item.getTag() != null) {
            int afterSizeIndex = buffer.writerIndex();
            try (NBTOutputStream stream = new NBTOutputStream((DataOutput)new LittleEndianByteBufOutputStream(buffer));){
                stream.write((Tag)item.getTag());
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to save NBT data", e);
            }
            buffer.setShortLE(sizeIndex, buffer.writerIndex() - afterSizeIndex);
        }
        String[] canPlace = item.getCanPlace();
        VarInts.writeInt((ByteBuf)buffer, (int)canPlace.length);
        for (String aCanPlace : canPlace) {
            BedrockUtils.writeString(buffer, aCanPlace);
        }
        String[] canBreak = item.getCanBreak();
        VarInts.writeInt((ByteBuf)buffer, (int)canBreak.length);
        for (String aCanBreak : canBreak) {
            BedrockUtils.writeString(buffer, aCanBreak);
        }
    }

    public static CommandOriginData readCommandOriginData(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        CommandOriginData.Origin origin = CommandOriginData.Origin.values()[VarInts.readUnsignedInt((ByteBuf)buffer)];
        UUID uuid = BedrockUtils.readUuid(buffer);
        String requestId = BedrockUtils.readString(buffer);
        long varLong = -1L;
        if (origin == CommandOriginData.Origin.DEV_CONSOLE || origin == CommandOriginData.Origin.TEST) {
            varLong = VarInts.readLong((ByteBuf)buffer);
        }
        return new CommandOriginData(origin, uuid, requestId, varLong);
    }

    public static void writeCommandOriginData(ByteBuf buffer, CommandOriginData originData) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)originData, (Object)"commandOriginData");
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)originData.getOrigin().ordinal());
        BedrockUtils.writeUuid(buffer, originData.getUuid());
        BedrockUtils.writeString(buffer, originData.getRequestId());
        if (originData.getOrigin() == CommandOriginData.Origin.DEV_CONSOLE || originData.getOrigin() == CommandOriginData.Origin.TEST) {
            VarInts.writeLong((ByteBuf)buffer, (long)originData.getEvent());
        }
    }

    public static CommandOutputMessage readCommandOutputMessage(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        boolean internal = buffer.readBoolean();
        String messageId = BedrockUtils.readString(buffer);
        String[] parameters = new String[VarInts.readUnsignedInt((ByteBuf)buffer)];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = BedrockUtils.readString(buffer);
        }
        return new CommandOutputMessage(internal, messageId, parameters);
    }

    public static void writeCommandOutputMessage(ByteBuf buffer, CommandOutputMessage outputMessage) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)outputMessage, (Object)"outputMessage");
        buffer.writeBoolean(outputMessage.isInternal());
        BedrockUtils.writeString(buffer, outputMessage.getMessageId());
        BedrockUtils.writeArray(buffer, outputMessage.getParameters(), BedrockUtils::writeString);
    }

    public static List<ResourcePacksInfoPacket.Entry> readPacksInfoEntries(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        ArrayList<ResourcePacksInfoPacket.Entry> entries = new ArrayList<ResourcePacksInfoPacket.Entry>();
        int length = buffer.readUnsignedShortLE();
        for (int i = 0; i < length; ++i) {
            String packId = BedrockUtils.readString(buffer);
            String packVersion = BedrockUtils.readString(buffer);
            long packSize = buffer.readLongLE();
            String encryptionKey = BedrockUtils.readString(buffer);
            String subpackName = BedrockUtils.readString(buffer);
            String contentId = BedrockUtils.readString(buffer);
            entries.add(new ResourcePacksInfoPacket.Entry(packId, packVersion, packSize, encryptionKey, subpackName, contentId, false));
        }
        return entries;
    }

    public static void writePacksInfoEntries(ByteBuf buffer, Collection<ResourcePacksInfoPacket.Entry> packInfoEntries) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull(packInfoEntries, (Object)"packInfoEntries");
        buffer.writeShortLE(packInfoEntries.size());
        for (ResourcePacksInfoPacket.Entry packInfoEntry : packInfoEntries) {
            BedrockUtils.writeString(buffer, packInfoEntry.getPackId());
            BedrockUtils.writeString(buffer, packInfoEntry.getPackVersion());
            buffer.writeLongLE(packInfoEntry.getPackSize());
            BedrockUtils.writeString(buffer, packInfoEntry.getEncryptionKey());
            BedrockUtils.writeString(buffer, packInfoEntry.getSubpackName());
            BedrockUtils.writeString(buffer, packInfoEntry.getContentId());
        }
    }

    public static ResourcePackStackPacket.Entry readPackInstanceEntry(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        String packId = BedrockUtils.readString(buffer);
        String packVersion = BedrockUtils.readString(buffer);
        String subpackName = BedrockUtils.readString(buffer);
        return new ResourcePackStackPacket.Entry(packId, packVersion, subpackName);
    }

    public static void writePackInstanceEntry(ByteBuf buffer, ResourcePackStackPacket.Entry packInstanceEntry) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)packInstanceEntry, (Object)"packInstanceEntry");
        BedrockUtils.writeString(buffer, packInstanceEntry.getPackId());
        BedrockUtils.writeString(buffer, packInstanceEntry.getPackVersion());
        BedrockUtils.writeString(buffer, packInstanceEntry.getSubpackName());
    }

    public static <T> void readArray(ByteBuf buffer, Collection<T> array, Function<ByteBuf, T> function) {
        int length = VarInts.readUnsignedInt((ByteBuf)buffer);
        for (int i = 0; i < length; ++i) {
            array.add(function.apply(buffer));
        }
    }

    public static <T> void writeArray(ByteBuf buffer, Collection<T> array, BiConsumer<ByteBuf, T> biConsumer) {
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)array.size());
        for (T val : array) {
            biConsumer.accept(buffer, (ByteBuf)val);
        }
    }

    public static <T> void writeArray(ByteBuf buffer, T[] array, BiConsumer<ByteBuf, T> biConsumer) {
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)array.length);
        for (T val : array) {
            biConsumer.accept(buffer, (ByteBuf)val);
        }
    }

    public static InventoryActionData readInventoryAction(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        InventorySource source = BedrockUtils.readInventorySource(buffer);
        int slot = VarInts.readUnsignedInt((ByteBuf)buffer);
        ItemData fromItem = BedrockUtils.readItemData(buffer);
        ItemData toItem = BedrockUtils.readItemData(buffer);
        return new InventoryActionData(source, slot, fromItem, toItem);
    }

    public static void writeInventoryAction(ByteBuf buffer, InventoryActionData action) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)action, (Object)"action");
        BedrockUtils.writeInventorySource(buffer, action.getSource());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)action.getSlot());
        BedrockUtils.writeItemData(buffer, action.getFromItem());
        BedrockUtils.writeItemData(buffer, action.getToItem());
    }

    public static InventorySource readInventorySource(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        InventorySource.Type type = InventorySource.Type.byId((int)VarInts.readUnsignedInt((ByteBuf)buffer));
        switch (type) {
            case CONTAINER: {
                int containerId = VarInts.readInt((ByteBuf)buffer);
                return InventorySource.fromContainerWindowId((int)containerId);
            }
            case GLOBAL: {
                return InventorySource.fromGlobalInventory();
            }
            case WORLD_INTERACTION: {
                InventorySource.Flag flag = InventorySource.Flag.values()[VarInts.readUnsignedInt((ByteBuf)buffer)];
                return InventorySource.fromWorldInteraction((InventorySource.Flag)flag);
            }
            case CREATIVE: {
                return InventorySource.fromCreativeInventory();
            }
            case UNTRACKED_INTERACTION_UI: {
                int containerId = VarInts.readInt((ByteBuf)buffer);
                return InventorySource.fromUntrackedInteractionUI((int)containerId);
            }
            case NON_IMPLEMENTED_TODO: {
                int containerId = VarInts.readInt((ByteBuf)buffer);
                return InventorySource.fromNonImplementedTodo((int)containerId);
            }
        }
        return InventorySource.fromInvalid();
    }

    public static void writeInventorySource(ByteBuf buffer, InventorySource inventorySource) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)inventorySource, (Object)"inventorySource");
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)inventorySource.getType().id());
        switch (inventorySource.getType()) {
            case CONTAINER: 
            case UNTRACKED_INTERACTION_UI: 
            case NON_IMPLEMENTED_TODO: {
                VarInts.writeInt((ByteBuf)buffer, (int)inventorySource.getContainerId());
                break;
            }
            case WORLD_INTERACTION: {
                VarInts.writeUnsignedInt((ByteBuf)buffer, (long)inventorySource.getFlag().ordinal());
            }
        }
    }

    public static GameRuleData readGameRule(ByteBuf buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        String name = BedrockUtils.readString(buffer);
        int type = VarInts.readUnsignedInt((ByteBuf)buffer);
        switch (type) {
            case 1: {
                return new GameRuleData(name, (Object)buffer.readBoolean());
            }
            case 2: {
                return new GameRuleData(name, (Object)VarInts.readUnsignedInt((ByteBuf)buffer));
            }
            case 3: {
                return new GameRuleData(name, (Object)Float.valueOf(buffer.readFloatLE()));
            }
        }
        throw new IllegalStateException("Invalid gamerule type received");
    }

    public static void writeGameRule(ByteBuf buffer, GameRuleData gameRule) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)gameRule, (Object)"gameRule");
        Object value = gameRule.getValue();
        int type = GameRulesChangedSerializer_v313.RULE_TYPES.get(value.getClass());
        BedrockUtils.writeString(buffer, gameRule.getName());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)type);
        switch (type) {
            case 1: {
                buffer.writeBoolean(((Boolean)value).booleanValue());
                break;
            }
            case 2: {
                VarInts.writeUnsignedInt((ByteBuf)buffer, (long)((Integer)value).intValue());
                break;
            }
            case 3: {
                buffer.writeFloatLE(((Float)value).floatValue());
            }
        }
    }

    public static void readEntityData(ByteBuf buffer, EntityDataMap entityDataMap) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)entityDataMap, (Object)"entityDataDictionary");
        int length = VarInts.readUnsignedInt((ByteBuf)buffer);
        block12: for (int i = 0; i < length; ++i) {
            Object object;
            int metadataInt = VarInts.readUnsignedInt((ByteBuf)buffer);
            EntityData entityData = (EntityData)METADATAS.get(metadataInt);
            EntityData.Type type = (EntityData.Type)METADATA_TYPES.get(VarInts.readUnsignedInt((ByteBuf)buffer));
            if (entityData != null && entityData.isFlags()) {
                if (type != EntityData.Type.LONG) {
                    throw new IllegalArgumentException("Expected long value for flags, got " + type.name());
                }
                type = EntityData.Type.FLAGS;
            }
            switch (type) {
                case BYTE: {
                    object = buffer.readByte();
                    break;
                }
                case SHORT: {
                    object = buffer.readShortLE();
                    break;
                }
                case INT: {
                    object = VarInts.readInt((ByteBuf)buffer);
                    break;
                }
                case FLOAT: {
                    object = Float.valueOf(buffer.readFloatLE());
                    break;
                }
                case STRING: {
                    object = BedrockUtils.readString(buffer);
                    break;
                }
                case NBT: {
                    object = BedrockUtils.readItemData(buffer);
                    break;
                }
                case VECTOR3I: {
                    object = BedrockUtils.readVector3i(buffer);
                    break;
                }
                case FLAGS: {
                    int index = entityData == EntityData.FLAGS_2 ? 1 : 0;
                    entityDataMap.getOrCreateFlags().set(VarInts.readLong((ByteBuf)buffer), index, METADATA_FLAGS);
                    continue block12;
                }
                case LONG: {
                    object = VarInts.readLong((ByteBuf)buffer);
                    break;
                }
                case VECTOR3F: {
                    object = BedrockUtils.readVector3f(buffer);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown entity data type received");
                }
            }
            if (entityData != null) {
                entityDataMap.put(entityData, object);
                continue;
            }
            log.debug("Unknown entity data: {} type {} value {}", new Object[]{metadataInt, type, object});
        }
    }

    public static void writeEntityData(ByteBuf buffer, EntityDataMap entityDataMap) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)entityDataMap, (Object)"entityDataDictionary");
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)entityDataMap.size());
        block12: for (Map.Entry entry : entityDataMap.entrySet()) {
            int index = buffer.writerIndex();
            VarInts.writeUnsignedInt((ByteBuf)buffer, (long)METADATAS.get(entry.getKey()));
            Object object = entry.getValue();
            EntityData.Type type = EntityData.Type.from(object);
            VarInts.writeUnsignedInt((ByteBuf)buffer, (long)METADATA_TYPES.get((Object)type));
            switch (type) {
                case BYTE: {
                    buffer.writeByte((int)((Byte)object).byteValue());
                    continue block12;
                }
                case SHORT: {
                    buffer.writeShortLE((int)((Short)object).shortValue());
                    continue block12;
                }
                case INT: {
                    VarInts.writeInt((ByteBuf)buffer, (int)((Integer)object));
                    continue block12;
                }
                case FLOAT: {
                    buffer.writeFloatLE(((Float)object).floatValue());
                    continue block12;
                }
                case STRING: {
                    BedrockUtils.writeString(buffer, (String)object);
                    continue block12;
                }
                case NBT: {
                    ItemData item = object instanceof CompoundTag ? ItemData.of((int)1, (short)0, (int)1, (CompoundTag)((CompoundTag)object)) : (ItemData)object;
                    BedrockUtils.writeItemData(buffer, item);
                    continue block12;
                }
                case VECTOR3I: {
                    BedrockUtils.writeVector3i(buffer, (Vector3i)object);
                    continue block12;
                }
                case FLAGS: {
                    int flagsIndex = entry.getKey() == EntityData.FLAGS_2 ? 1 : 0;
                    object = ((EntityFlags)object).get(flagsIndex, METADATA_FLAGS);
                }
                case LONG: {
                    VarInts.writeLong((ByteBuf)buffer, (long)((Long)object));
                    continue block12;
                }
                case VECTOR3F: {
                    BedrockUtils.writeVector3f(buffer, (Vector3f)object);
                    continue block12;
                }
            }
            buffer.writerIndex(index);
        }
    }

    public static CommandEnumData readCommandEnumData(ByteBuf buffer, boolean soft) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        String name = BedrockUtils.readString(buffer);
        String[] values = new String[VarInts.readUnsignedInt((ByteBuf)buffer)];
        for (int i = 0; i < values.length; ++i) {
            values[i] = BedrockUtils.readString(buffer);
        }
        return new CommandEnumData(name, values, soft);
    }

    public static void writeCommandEnumData(ByteBuf buffer, CommandEnumData enumData) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)enumData, (Object)"enumData");
        BedrockUtils.writeString(buffer, enumData.getName());
        String[] values = enumData.getValues();
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)values.length);
        for (String value : values) {
            BedrockUtils.writeString(buffer, value);
        }
    }

    private BedrockUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        METADATAS.put(0, (Object)EntityData.FLAGS);
        METADATAS.put(1, (Object)EntityData.HEALTH);
        METADATAS.put(2, (Object)EntityData.VARIANT);
        METADATAS.put(3, (Object)EntityData.COLOR);
        METADATAS.put(4, (Object)EntityData.NAMETAG);
        METADATAS.put(5, (Object)EntityData.OWNER_EID);
        METADATAS.put(6, (Object)EntityData.TARGET_EID);
        METADATAS.put(7, (Object)EntityData.AIR);
        METADATAS.put(8, (Object)EntityData.POTION_COLOR);
        METADATAS.put(9, (Object)EntityData.POTION_AMBIENT);
        METADATAS.put(10, (Object)EntityData.JUMP_DURATION);
        METADATAS.put(11, (Object)EntityData.HURT_TIME);
        METADATAS.put(12, (Object)EntityData.HURT_DIRECTION);
        METADATAS.put(13, (Object)EntityData.PADDLE_TIME_LEFT);
        METADATAS.put(14, (Object)EntityData.PADDLE_TIME_RIGHT);
        METADATAS.put(15, (Object)EntityData.EXPERIENCE_VALUE);
        METADATAS.put(16, (Object)EntityData.DISPLAY_ITEM);
        METADATAS.put(17, (Object)EntityData.DISPLAY_OFFSET);
        METADATAS.put(18, (Object)EntityData.HAS_DISPLAY);
        METADATAS.put(22, (Object)EntityData.CHARGED);
        METADATAS.put(23, (Object)EntityData.ENDERMAN_HELD_ITEM_ID);
        METADATAS.put(24, (Object)EntityData.ENTITY_AGE);
        METADATAS.put(26, (Object)EntityData.CAN_START_SLEEP);
        METADATAS.put(27, (Object)EntityData.PLAYER_INDEX);
        METADATAS.put(28, (Object)EntityData.BED_RESPAWN_POS);
        METADATAS.put(29, (Object)EntityData.FIREBALL_POWER_X);
        METADATAS.put(30, (Object)EntityData.FIREBALL_POWER_Y);
        METADATAS.put(31, (Object)EntityData.FIREBALL_POWER_Z);
        METADATAS.put(36, (Object)EntityData.POTION_AUX_VALUE);
        METADATAS.put(37, (Object)EntityData.LEAD_HOLDER_EID);
        METADATAS.put(38, (Object)EntityData.SCALE);
        METADATAS.put(39, (Object)EntityData.HAS_NPC_COMPONENT);
        METADATAS.put(40, (Object)EntityData.NPC_SKIN_ID);
        METADATAS.put(41, (Object)EntityData.URL_TAG);
        METADATAS.put(42, (Object)EntityData.MAX_AIR);
        METADATAS.put(43, (Object)EntityData.MARK_VARIANT);
        METADATAS.put(44, (Object)EntityData.CONTAINER_TYPE);
        METADATAS.put(45, (Object)EntityData.CONTAINER_BASE_SIZE);
        METADATAS.put(46, (Object)EntityData.CONTAINER_EXTRA_SLOTS_PER_STRENGTH);
        METADATAS.put(47, (Object)EntityData.BLOCK_TARGET);
        METADATAS.put(48, (Object)EntityData.WITHER_INVULNERABLE_TICKS);
        METADATAS.put(49, (Object)EntityData.WITHER_TARGET_1);
        METADATAS.put(50, (Object)EntityData.WITHER_TARGET_2);
        METADATAS.put(51, (Object)EntityData.WITHER_TARGET_3);
        METADATAS.put(53, (Object)EntityData.BOUNDING_BOX_WIDTH);
        METADATAS.put(54, (Object)EntityData.BOUNDING_BOX_HEIGHT);
        METADATAS.put(55, (Object)EntityData.FUSE_LENGTH);
        METADATAS.put(56, (Object)EntityData.RIDER_SEAT_POSITION);
        METADATAS.put(57, (Object)EntityData.RIDER_ROTATION_LOCKED);
        METADATAS.put(58, (Object)EntityData.RIDER_MAX_ROTATION);
        METADATAS.put(59, (Object)EntityData.RIDER_MIN_ROTATION);
        METADATAS.put(60, (Object)EntityData.AREA_EFFECT_CLOUD_RADIUS);
        METADATAS.put(61, (Object)EntityData.AREA_EFFECT_CLOUD_WAITING);
        METADATAS.put(62, (Object)EntityData.AREA_EFFECT_CLOUD_PARTICLE_ID);
        METADATAS.put(64, (Object)EntityData.SHULKER_ATTACH_FACE);
        METADATAS.put(66, (Object)EntityData.SHULKER_ATTACH_POS);
        METADATAS.put(67, (Object)EntityData.TRADING_PLAYER_EID);
        METADATAS.put(69, (Object)EntityData.COMMAND_BLOCK_ENABLED);
        METADATAS.put(70, (Object)EntityData.COMMAND_BLOCK_COMMAND);
        METADATAS.put(71, (Object)EntityData.COMMAND_BLOCK_LAST_OUTPUT);
        METADATAS.put(72, (Object)EntityData.COMMAND_BLOCK_TRACK_OUTPUT);
        METADATAS.put(73, (Object)EntityData.CONTROLLING_RIDER_SEAT_NUMBER);
        METADATAS.put(74, (Object)EntityData.STRENGTH);
        METADATAS.put(75, (Object)EntityData.MAX_STRENGTH);
        METADATAS.put(76, (Object)EntityData.EVOKER_SPELL_COLOR);
        METADATAS.put(77, (Object)EntityData.LIMITED_LIFE);
        METADATAS.put(78, (Object)EntityData.ARMOR_STAND_POSE_INDEX);
        METADATAS.put(79, (Object)EntityData.ENDER_CRYSTAL_TIME_OFFSET);
        METADATAS.put(80, (Object)EntityData.ALWAYS_SHOW_NAMETAG);
        METADATAS.put(81, (Object)EntityData.COLOR_2);
        METADATAS.put(83, (Object)EntityData.SCORE_TAG);
        METADATAS.put(84, (Object)EntityData.BALLOON_ATTACHED_ENTITY);
        METADATAS.put(85, (Object)EntityData.PUFFERFISH_SIZE);
        METADATAS.put(87, (Object)EntityData.AGENT_ID);
        METADATA_FLAGS.put(0, (Object)EntityFlag.ON_FIRE);
        METADATA_FLAGS.put(1, (Object)EntityFlag.SNEAKING);
        METADATA_FLAGS.put(2, (Object)EntityFlag.RIDING);
        METADATA_FLAGS.put(3, (Object)EntityFlag.SPRINTING);
        METADATA_FLAGS.put(4, (Object)EntityFlag.USING_ITEM);
        METADATA_FLAGS.put(5, (Object)EntityFlag.INVISIBLE);
        METADATA_FLAGS.put(6, (Object)EntityFlag.TEMPTED);
        METADATA_FLAGS.put(7, (Object)EntityFlag.IN_LOVE);
        METADATA_FLAGS.put(8, (Object)EntityFlag.SADDLED);
        METADATA_FLAGS.put(9, (Object)EntityFlag.POWERED);
        METADATA_FLAGS.put(10, (Object)EntityFlag.IGNITED);
        METADATA_FLAGS.put(11, (Object)EntityFlag.BABY);
        METADATA_FLAGS.put(12, (Object)EntityFlag.CONVERTING);
        METADATA_FLAGS.put(13, (Object)EntityFlag.CRITICAL);
        METADATA_FLAGS.put(14, (Object)EntityFlag.CAN_SHOW_NAME);
        METADATA_FLAGS.put(15, (Object)EntityFlag.ALWAYS_SHOW_NAME);
        METADATA_FLAGS.put(16, (Object)EntityFlag.NO_AI);
        METADATA_FLAGS.put(17, (Object)EntityFlag.SILENT);
        METADATA_FLAGS.put(18, (Object)EntityFlag.WALL_CLIMBING);
        METADATA_FLAGS.put(19, (Object)EntityFlag.CAN_CLIMB);
        METADATA_FLAGS.put(20, (Object)EntityFlag.CAN_SWIM);
        METADATA_FLAGS.put(21, (Object)EntityFlag.CAN_FLY);
        METADATA_FLAGS.put(22, (Object)EntityFlag.CAN_WALK);
        METADATA_FLAGS.put(23, (Object)EntityFlag.RESTING);
        METADATA_FLAGS.put(24, (Object)EntityFlag.SITTING);
        METADATA_FLAGS.put(25, (Object)EntityFlag.ANGRY);
        METADATA_FLAGS.put(26, (Object)EntityFlag.INTERESTED);
        METADATA_FLAGS.put(27, (Object)EntityFlag.CHARGED);
        METADATA_FLAGS.put(28, (Object)EntityFlag.TAMED);
        METADATA_FLAGS.put(29, (Object)EntityFlag.ORPHANED);
        METADATA_FLAGS.put(30, (Object)EntityFlag.LEASHED);
        METADATA_FLAGS.put(31, (Object)EntityFlag.SHEARED);
        METADATA_FLAGS.put(32, (Object)EntityFlag.GLIDING);
        METADATA_FLAGS.put(33, (Object)EntityFlag.ELDER);
        METADATA_FLAGS.put(34, (Object)EntityFlag.MOVING);
        METADATA_FLAGS.put(35, (Object)EntityFlag.BREATHING);
        METADATA_FLAGS.put(36, (Object)EntityFlag.CHESTED);
        METADATA_FLAGS.put(37, (Object)EntityFlag.STACKABLE);
        METADATA_FLAGS.put(38, (Object)EntityFlag.SHOW_BOTTOM);
        METADATA_FLAGS.put(39, (Object)EntityFlag.STANDING);
        METADATA_FLAGS.put(40, (Object)EntityFlag.SHAKING);
        METADATA_FLAGS.put(41, (Object)EntityFlag.IDLING);
        METADATA_FLAGS.put(42, (Object)EntityFlag.CASTING);
        METADATA_FLAGS.put(43, (Object)EntityFlag.CHARGING);
        METADATA_FLAGS.put(44, (Object)EntityFlag.WASD_CONTROLLED);
        METADATA_FLAGS.put(45, (Object)EntityFlag.CAN_POWER_JUMP);
        METADATA_FLAGS.put(46, (Object)EntityFlag.LINGERING);
        METADATA_FLAGS.put(47, (Object)EntityFlag.HAS_COLLISION);
        METADATA_FLAGS.put(48, (Object)EntityFlag.HAS_GRAVITY);
        METADATA_FLAGS.put(49, (Object)EntityFlag.FIRE_IMMUNE);
        METADATA_FLAGS.put(50, (Object)EntityFlag.DANCING);
        METADATA_FLAGS.put(51, (Object)EntityFlag.ENCHANTED);
        METADATA_FLAGS.put(52, (Object)EntityFlag.RETURN_TRIDENT);
        METADATA_FLAGS.put(53, (Object)EntityFlag.CONTAINER_IS_PRIVATE);
        METADATA_FLAGS.put(55, (Object)EntityFlag.DAMAGE_NEARBY_MOBS);
        METADATA_FLAGS.put(56, (Object)EntityFlag.SWIMMING);
        METADATA_FLAGS.put(57, (Object)EntityFlag.BRIBED);
        METADATA_FLAGS.put(58, (Object)EntityFlag.IS_PREGNANT);
        METADATA_FLAGS.put(59, (Object)EntityFlag.LAYING_EGG);
        METADATA_TYPES.put(7, (Object)EntityData.Type.FLAGS);
        METADATA_TYPES.put(0, (Object)EntityData.Type.BYTE);
        METADATA_TYPES.put(1, (Object)EntityData.Type.SHORT);
        METADATA_TYPES.put(2, (Object)EntityData.Type.INT);
        METADATA_TYPES.put(3, (Object)EntityData.Type.FLOAT);
        METADATA_TYPES.put(4, (Object)EntityData.Type.STRING);
        METADATA_TYPES.put(5, (Object)EntityData.Type.NBT);
        METADATA_TYPES.put(6, (Object)EntityData.Type.VECTOR3I);
        METADATA_TYPES.put(7, (Object)EntityData.Type.LONG);
        METADATA_TYPES.put(8, (Object)EntityData.Type.VECTOR3F);
    }
}

