/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v313.serializer;

import com.flowpowered.math.vector.Vector3i;
import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.data.StructureEditorData;
import com.nukkitx.protocol.bedrock.data.StructureSettings;
import com.nukkitx.protocol.bedrock.packet.StructureBlockUpdatePacket;
import com.nukkitx.protocol.bedrock.v313.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;

public class StructureBlockUpdateSerializer_v313
implements PacketSerializer<StructureBlockUpdatePacket> {
    public static final StructureBlockUpdateSerializer_v313 INSTANCE = new StructureBlockUpdateSerializer_v313();

    public void serialize(ByteBuf buffer, StructureBlockUpdatePacket packet) {
        StructureEditorData editorData = packet.getEditorData();
        StructureSettings settings = editorData.getStructureSettings();
        BedrockUtils.writeBlockPosition(buffer, packet.getBlockPosition());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)editorData.getStructureBlockType());
        BedrockUtils.writeString(buffer, editorData.getName());
        BedrockUtils.writeString(buffer, editorData.getStructureDataField());
        BedrockUtils.writeBlockPosition(buffer, settings.getStructureOffset());
        BedrockUtils.writeBlockPosition(buffer, settings.getStructureSize());
        buffer.writeBoolean(!settings.isIgnoreEntities());
        buffer.writeBoolean(settings.isIgnoreBlocks());
        buffer.writeBoolean(editorData.isIncludePlayers());
        buffer.writeBoolean(false);
        buffer.writeFloatLE(settings.getIntegrityValue());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)settings.getIntegritySeed());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)settings.getMirror());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)settings.getRotation());
        buffer.writeBoolean(settings.isIgnoreEntities());
        buffer.writeBoolean(true);
        Vector3i min = packet.getBlockPosition().add(settings.getStructureOffset());
        BedrockUtils.writeVector3i(buffer, min);
        Vector3i max = min.add(settings.getStructureSize());
        BedrockUtils.writeVector3i(buffer, max);
        buffer.writeBoolean(editorData.isShowBoundingBox());
        buffer.writeBoolean(packet.isPowered());
    }

    public void deserialize(ByteBuf buffer, StructureBlockUpdatePacket packet) {
        packet.setBlockPosition(BedrockUtils.readBlockPosition(buffer));
        int structureType = VarInts.readUnsignedInt((ByteBuf)buffer);
        String name = BedrockUtils.readString(buffer);
        String dataField = BedrockUtils.readString(buffer);
        Vector3i offset = BedrockUtils.readBlockPosition(buffer);
        Vector3i size = BedrockUtils.readBlockPosition(buffer);
        buffer.readBoolean();
        boolean ignoreBlocks = !buffer.readBoolean();
        boolean includePlayers = buffer.readBoolean();
        buffer.readBoolean();
        float structureIntegrity = buffer.readFloatLE();
        int integritySeed = VarInts.readUnsignedInt((ByteBuf)buffer);
        int mirror = VarInts.readUnsignedInt((ByteBuf)buffer);
        int rotation = VarInts.readUnsignedInt((ByteBuf)buffer);
        boolean ignoreEntities = buffer.readBoolean();
        buffer.readBoolean();
        BedrockUtils.readVector3i(buffer);
        BedrockUtils.readVector3i(buffer);
        boolean boundingBoxVisible = buffer.readBoolean();
        StructureSettings settings = new StructureSettings("", ignoreEntities, ignoreBlocks, size, offset, -1L, (byte)rotation, (byte)mirror, structureIntegrity, integritySeed);
        StructureEditorData editorData = new StructureEditorData(name, dataField, includePlayers, boundingBoxVisible, structureType, settings);
        packet.setEditorData(editorData);
        packet.setPowered(buffer.readBoolean());
    }

    private StructureBlockUpdateSerializer_v313() {
    }
}

