/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v313.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.data.GamePublishSetting;
import com.nukkitx.protocol.bedrock.packet.StartGamePacket;
import com.nukkitx.protocol.bedrock.v313.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;
import java.util.Collection;

public class StartGameSerializer_v313
implements PacketSerializer<StartGamePacket> {
    public static final StartGameSerializer_v313 INSTANCE = new StartGameSerializer_v313();

    public void serialize(ByteBuf buffer, StartGamePacket packet) {
        VarInts.writeLong((ByteBuf)buffer, (long)packet.getUniqueEntityId());
        VarInts.writeUnsignedLong((ByteBuf)buffer, (long)packet.getRuntimeEntityId());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getPlayerGamemode());
        BedrockUtils.writeVector3f(buffer, packet.getPlayerPosition());
        BedrockUtils.writeVector2f(buffer, packet.getRotation());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getSeed());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getDimensionId());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getGeneratorId());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getLevelGamemode());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getDifficulty());
        BedrockUtils.writeBlockPosition(buffer, packet.getDefaultSpawn());
        buffer.writeBoolean(packet.isAcheivementsDisabled());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getTime());
        buffer.writeBoolean(packet.isEduLevel());
        buffer.writeBoolean(packet.isEduFeaturesEnabled());
        buffer.writeFloatLE(packet.getRainLevel());
        buffer.writeFloatLE(packet.getLightningLevel());
        buffer.writeBoolean(packet.isMultiplayerGame());
        buffer.writeBoolean(packet.isBroadcastingToLan());
        buffer.writeBoolean(packet.getXblBroadcastMode() != GamePublishSetting.NO_MULTI_PLAY);
        buffer.writeBoolean(packet.isCommandsEnabled());
        buffer.writeBoolean(packet.isTexturePacksRequired());
        BedrockUtils.writeArray(buffer, packet.getGamerules(), BedrockUtils::writeGameRule);
        buffer.writeBoolean(packet.isBonusChestEnabled());
        buffer.writeBoolean(packet.isStartingWithMap());
        buffer.writeBoolean(packet.isTrustingPlayers());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getDefaultPlayerPermission());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getXblBroadcastMode().ordinal());
        buffer.writeIntLE(packet.getServerChunkTickRange());
        buffer.writeBoolean(packet.getPlatformBroadcastMode() != GamePublishSetting.NO_MULTI_PLAY);
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getPlatformBroadcastMode().ordinal());
        buffer.writeBoolean(packet.getXblBroadcastMode() != GamePublishSetting.NO_MULTI_PLAY);
        buffer.writeBoolean(packet.isBehaviorPackLocked());
        buffer.writeBoolean(packet.isResourcePackLocked());
        buffer.writeBoolean(packet.isFromLockedWorldTemplate());
        buffer.writeBoolean(packet.isUsingMsaGamertagsOnly());
        buffer.writeBoolean(packet.isFromWorldTemplate());
        buffer.writeBoolean(packet.isWorldTemplateOptionLocked());
        BedrockUtils.writeString(buffer, packet.getLevelId());
        BedrockUtils.writeString(buffer, packet.getWorldName());
        BedrockUtils.writeString(buffer, packet.getPremiumWorldTemplateId());
        buffer.writeBoolean(packet.isTrial());
        buffer.writeLongLE(packet.getCurrentTick());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getEnchantmentSeed());
        if (packet.getCachedPalette() != null) {
            buffer.writeBytes(packet.getCachedPalette());
            packet.getCachedPalette().release();
        } else {
            Collection paletteEntries = packet.getPaletteEntries();
            VarInts.writeUnsignedInt((ByteBuf)buffer, (long)paletteEntries.size());
            for (StartGamePacket.BlockPaletteEntry entry : paletteEntries) {
                BedrockUtils.writeString(buffer, entry.getIdentifier());
                buffer.writeShortLE((int)entry.getMeta());
            }
        }
        BedrockUtils.writeString(buffer, packet.getMultiplayerCorrelationId());
    }

    public void deserialize(ByteBuf buffer, StartGamePacket packet) {
        packet.setUniqueEntityId(VarInts.readLong((ByteBuf)buffer));
        packet.setRuntimeEntityId(VarInts.readUnsignedLong((ByteBuf)buffer));
        packet.setPlayerGamemode(VarInts.readInt((ByteBuf)buffer));
        packet.setPlayerPosition(BedrockUtils.readVector3f(buffer));
        packet.setRotation(BedrockUtils.readVector2f(buffer));
        packet.setSeed(VarInts.readInt((ByteBuf)buffer));
        packet.setDimensionId(VarInts.readInt((ByteBuf)buffer));
        packet.setGeneratorId(VarInts.readInt((ByteBuf)buffer));
        packet.setLevelGamemode(VarInts.readInt((ByteBuf)buffer));
        packet.setDifficulty(VarInts.readInt((ByteBuf)buffer));
        packet.setDefaultSpawn(BedrockUtils.readBlockPosition(buffer));
        packet.setAcheivementsDisabled(buffer.readBoolean());
        packet.setTime(VarInts.readInt((ByteBuf)buffer));
        packet.setEduLevel(buffer.readBoolean());
        packet.setEduFeaturesEnabled(buffer.readBoolean());
        packet.setRainLevel(buffer.readFloatLE());
        packet.setLightningLevel(buffer.readFloatLE());
        packet.setMultiplayerGame(buffer.readBoolean());
        packet.setBroadcastingToLan(buffer.readBoolean());
        buffer.readBoolean();
        packet.setCommandsEnabled(buffer.readBoolean());
        packet.setTexturePacksRequired(buffer.readBoolean());
        BedrockUtils.readArray(buffer, packet.getGamerules(), BedrockUtils::readGameRule);
        packet.setBonusChestEnabled(buffer.readBoolean());
        packet.setStartingWithMap(buffer.readBoolean());
        packet.setTrustingPlayers(buffer.readBoolean());
        packet.setDefaultPlayerPermission(VarInts.readInt((ByteBuf)buffer));
        packet.setXblBroadcastMode(GamePublishSetting.byId((int)VarInts.readInt((ByteBuf)buffer)));
        packet.setServerChunkTickRange(buffer.readIntLE());
        buffer.readBoolean();
        packet.setPlatformBroadcastMode(GamePublishSetting.byId((int)VarInts.readInt((ByteBuf)buffer)));
        buffer.readBoolean();
        packet.setBehaviorPackLocked(buffer.readBoolean());
        packet.setResourcePackLocked(buffer.readBoolean());
        packet.setFromLockedWorldTemplate(buffer.readBoolean());
        packet.setUsingMsaGamertagsOnly(buffer.readBoolean());
        packet.setFromWorldTemplate(buffer.readBoolean());
        packet.setWorldTemplateOptionLocked(buffer.readBoolean());
        packet.setLevelId(BedrockUtils.readString(buffer));
        packet.setWorldName(BedrockUtils.readString(buffer));
        packet.setPremiumWorldTemplateId(BedrockUtils.readString(buffer));
        packet.setTrial(buffer.readBoolean());
        packet.setCurrentTick(buffer.readLongLE());
        packet.setEnchantmentSeed(VarInts.readInt((ByteBuf)buffer));
        BedrockUtils.readArray(buffer, packet.getPaletteEntries(), buf -> {
            String identifier = BedrockUtils.readString(buffer);
            short meta = buffer.readShortLE();
            return new StartGamePacket.BlockPaletteEntry(identifier, meta);
        });
        packet.setMultiplayerCorrelationId(BedrockUtils.readString(buffer));
    }

    private StartGameSerializer_v313() {
    }
}

