/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v313.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.packet.SetScoreboardIdentityPacket;
import com.nukkitx.protocol.bedrock.v313.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;
import java.util.UUID;

public class SetScoreboardIdentitySerializer_v313
implements PacketSerializer<SetScoreboardIdentityPacket> {
    public static final SetScoreboardIdentitySerializer_v313 INSTANCE = new SetScoreboardIdentitySerializer_v313();

    public void serialize(ByteBuf buffer, SetScoreboardIdentityPacket packet) {
        SetScoreboardIdentityPacket.Type type = packet.getType();
        buffer.writeByte(type.ordinal());
        BedrockUtils.writeArray(buffer, packet.getEntries(), (buf, entry) -> {
            VarInts.writeLong((ByteBuf)buffer, (long)entry.getScoreboardId());
            if (type == SetScoreboardIdentityPacket.Type.ADD) {
                BedrockUtils.writeUuid(buffer, entry.getUuid());
            }
        });
    }

    public void deserialize(ByteBuf buffer, SetScoreboardIdentityPacket packet) {
        SetScoreboardIdentityPacket.Type type = SetScoreboardIdentityPacket.Type.values()[buffer.readUnsignedByte()];
        packet.setType(type);
        BedrockUtils.readArray(buffer, packet.getEntries(), buf -> {
            long scoreboardId = VarInts.readLong((ByteBuf)buffer);
            UUID uuid = null;
            if (type == SetScoreboardIdentityPacket.Type.ADD) {
                uuid = BedrockUtils.readUuid(buffer);
            }
            return new SetScoreboardIdentityPacket.Entry(scoreboardId, uuid);
        });
    }

    private SetScoreboardIdentitySerializer_v313() {
    }
}

