/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v313.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.packet.ResourcePackDataInfoPacket;
import com.nukkitx.protocol.bedrock.v313.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;
import java.util.UUID;

public class ResourcePackDataInfoSerializer_v313
implements PacketSerializer<ResourcePackDataInfoPacket> {
    public static final ResourcePackDataInfoSerializer_v313 INSTANCE = new ResourcePackDataInfoSerializer_v313();

    public void serialize(ByteBuf buffer, ResourcePackDataInfoPacket packet) {
        String packInfo = packet.getPackId().toString() + (packet.getPackVersion() == null ? "" : '_' + packet.getPackVersion());
        BedrockUtils.writeString(buffer, packInfo);
        BedrockUtils.writeString(buffer, packet.getPackId().toString());
        buffer.writeIntLE((int)packet.getMaxChunkSize());
        buffer.writeIntLE((int)packet.getChunkCount());
        buffer.writeLongLE(packet.getCompressedPackSize());
        byte[] hash = packet.getHash();
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)hash.length);
        buffer.writeBytes(hash);
    }

    public void deserialize(ByteBuf buffer, ResourcePackDataInfoPacket packet) {
        String[] packInfo = BedrockUtils.readString(buffer).split("_");
        packet.setPackId(UUID.fromString(packInfo[0]));
        if (packInfo.length > 1) {
            packet.setPackVersion(packInfo[1]);
        }
        packet.setMaxChunkSize((long)buffer.readIntLE());
        packet.setChunkCount((long)buffer.readIntLE());
        packet.setCompressedPackSize(buffer.readLongLE());
        byte[] hash = new byte[VarInts.readUnsignedInt((ByteBuf)buffer)];
        buffer.readBytes(hash);
        packet.setHash(hash);
    }

    private ResourcePackDataInfoSerializer_v313() {
    }
}

