/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v313.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.data.SoundEvent;
import com.nukkitx.protocol.bedrock.packet.LevelSoundEventPacket;
import com.nukkitx.protocol.bedrock.v313.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import com.nukkitx.protocol.util.TIntHashBiMap;
import io.netty.buffer.ByteBuf;

public class LevelSoundEventSerializer_v313
implements PacketSerializer<LevelSoundEventPacket> {
    public static final LevelSoundEventSerializer_v313 INSTANCE = new LevelSoundEventSerializer_v313();
    private static final TIntHashBiMap<SoundEvent> sounds = new TIntHashBiMap();

    public void serialize(ByteBuf buffer, LevelSoundEventPacket packet) {
        buffer.writeByte(sounds.get((Object)packet.getSound()));
        BedrockUtils.writeVector3f(buffer, packet.getPosition());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getExtraData());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getPitch());
        buffer.writeBoolean(packet.isBabySound());
        buffer.writeBoolean(packet.isRelativeVolumeDisabled());
    }

    public void deserialize(ByteBuf buffer, LevelSoundEventPacket packet) {
        packet.setSound((SoundEvent)sounds.get((int)buffer.readUnsignedByte()));
        packet.setPosition(BedrockUtils.readVector3f(buffer));
        packet.setExtraData(VarInts.readInt((ByteBuf)buffer));
        packet.setPitch(VarInts.readInt((ByteBuf)buffer));
        packet.setBabySound(buffer.readBoolean());
        packet.setRelativeVolumeDisabled(buffer.readBoolean());
    }

    private LevelSoundEventSerializer_v313() {
    }

    static {
        sounds.put(0, (Object)SoundEvent.ITEM_USE_ON);
        sounds.put(1, (Object)SoundEvent.HIT);
        sounds.put(2, (Object)SoundEvent.STEP);
        sounds.put(3, (Object)SoundEvent.FLY);
        sounds.put(4, (Object)SoundEvent.JUMP);
        sounds.put(5, (Object)SoundEvent.BREAK);
        sounds.put(6, (Object)SoundEvent.PLACE);
        sounds.put(7, (Object)SoundEvent.HEAVY_STEP);
        sounds.put(8, (Object)SoundEvent.GALLOP);
        sounds.put(9, (Object)SoundEvent.FALL);
        sounds.put(10, (Object)SoundEvent.AMBIENT);
        sounds.put(11, (Object)SoundEvent.AMBIENT_BABY);
        sounds.put(12, (Object)SoundEvent.AMBIENT_IN_WATER);
        sounds.put(13, (Object)SoundEvent.BREATHE);
        sounds.put(14, (Object)SoundEvent.DEATH);
        sounds.put(15, (Object)SoundEvent.DEATH_IN_WATER);
        sounds.put(16, (Object)SoundEvent.DEATH_TO_ZOMBIE);
        sounds.put(17, (Object)SoundEvent.HURT);
        sounds.put(18, (Object)SoundEvent.HURT_IN_WATER);
        sounds.put(19, (Object)SoundEvent.MAD);
        sounds.put(20, (Object)SoundEvent.BOOST);
        sounds.put(21, (Object)SoundEvent.BOW);
        sounds.put(22, (Object)SoundEvent.SQUISH_BIG);
        sounds.put(23, (Object)SoundEvent.SQUISH_SMALL);
        sounds.put(24, (Object)SoundEvent.FALL_BIG);
        sounds.put(25, (Object)SoundEvent.FALL_SMALL);
        sounds.put(26, (Object)SoundEvent.SPLASH);
        sounds.put(27, (Object)SoundEvent.FIZZ);
        sounds.put(28, (Object)SoundEvent.FLAP);
        sounds.put(29, (Object)SoundEvent.SWIM);
        sounds.put(30, (Object)SoundEvent.DRINK);
        sounds.put(31, (Object)SoundEvent.EAT);
        sounds.put(32, (Object)SoundEvent.TAKEOFF);
        sounds.put(33, (Object)SoundEvent.SHAKE);
        sounds.put(34, (Object)SoundEvent.PLOP);
        sounds.put(35, (Object)SoundEvent.LAND);
        sounds.put(36, (Object)SoundEvent.SADDLE);
        sounds.put(37, (Object)SoundEvent.ARMOR);
        sounds.put(38, (Object)SoundEvent.MOB_ARMOR_STAND_PLACE);
        sounds.put(39, (Object)SoundEvent.ADD_CHEST);
        sounds.put(40, (Object)SoundEvent.THROW);
        sounds.put(41, (Object)SoundEvent.ATTACK);
        sounds.put(42, (Object)SoundEvent.ATTACK_NODAMAGE);
        sounds.put(43, (Object)SoundEvent.ATTACK_STRONG);
        sounds.put(44, (Object)SoundEvent.WARN);
        sounds.put(45, (Object)SoundEvent.SHEAR);
        sounds.put(46, (Object)SoundEvent.MILK);
        sounds.put(47, (Object)SoundEvent.THUNDER);
        sounds.put(48, (Object)SoundEvent.EXPLODE);
        sounds.put(49, (Object)SoundEvent.FIRE);
        sounds.put(50, (Object)SoundEvent.IGNITE);
        sounds.put(51, (Object)SoundEvent.FUSE);
        sounds.put(52, (Object)SoundEvent.STARE);
        sounds.put(53, (Object)SoundEvent.SPAWN);
        sounds.put(54, (Object)SoundEvent.SHOOT);
        sounds.put(55, (Object)SoundEvent.BREAK_BLOCK);
        sounds.put(56, (Object)SoundEvent.LAUNCH);
        sounds.put(57, (Object)SoundEvent.BLAST);
        sounds.put(58, (Object)SoundEvent.LARGE_BLAST);
        sounds.put(59, (Object)SoundEvent.TWINKLE);
        sounds.put(60, (Object)SoundEvent.REMEDY);
        sounds.put(61, (Object)SoundEvent.UNFECT);
        sounds.put(62, (Object)SoundEvent.LEVELUP);
        sounds.put(63, (Object)SoundEvent.BOW_HIT);
        sounds.put(64, (Object)SoundEvent.BULLET_HIT);
        sounds.put(65, (Object)SoundEvent.EXTINGUISH_FIRE);
        sounds.put(66, (Object)SoundEvent.ITEM_FIZZ);
        sounds.put(67, (Object)SoundEvent.CHEST_OPEN);
        sounds.put(68, (Object)SoundEvent.CHEST_CLOSED);
        sounds.put(69, (Object)SoundEvent.SHULKERBOX_OPEN);
        sounds.put(70, (Object)SoundEvent.SHULKERBOX_CLOSED);
        sounds.put(71, (Object)SoundEvent.ENDERCHEST_OPEN);
        sounds.put(72, (Object)SoundEvent.ENDERCHEST_CLOSED);
        sounds.put(73, (Object)SoundEvent.POWER_ON);
        sounds.put(74, (Object)SoundEvent.POWER_OFF);
        sounds.put(75, (Object)SoundEvent.ATTACH);
        sounds.put(76, (Object)SoundEvent.DETACH);
        sounds.put(77, (Object)SoundEvent.DENY);
        sounds.put(78, (Object)SoundEvent.TRIPOD);
        sounds.put(79, (Object)SoundEvent.POP);
        sounds.put(80, (Object)SoundEvent.DROP_SLOT);
        sounds.put(81, (Object)SoundEvent.NOTE);
        sounds.put(82, (Object)SoundEvent.THORNS);
        sounds.put(83, (Object)SoundEvent.PISTON_IN);
        sounds.put(84, (Object)SoundEvent.PISTON_OUT);
        sounds.put(85, (Object)SoundEvent.PORTAL);
        sounds.put(86, (Object)SoundEvent.WATER);
        sounds.put(87, (Object)SoundEvent.LAVA_POP);
        sounds.put(88, (Object)SoundEvent.LAVA);
        sounds.put(89, (Object)SoundEvent.BURP);
        sounds.put(90, (Object)SoundEvent.BUCKET_FILL_WATER);
        sounds.put(91, (Object)SoundEvent.BUCKET_FILL_LAVA);
        sounds.put(92, (Object)SoundEvent.BUCKET_EMPTY_WATER);
        sounds.put(93, (Object)SoundEvent.BUCKET_EMPTY_LAVA);
        sounds.put(94, (Object)SoundEvent.ARMOR_EQUIP_CHAIN);
        sounds.put(95, (Object)SoundEvent.ARMOR_EQUIP_DIAMOND);
        sounds.put(96, (Object)SoundEvent.ARMOR_EQUIP_GENERIC);
        sounds.put(97, (Object)SoundEvent.ARMOR_EQUIP_GOLD);
        sounds.put(98, (Object)SoundEvent.ARMOR_EQUIP_IRON);
        sounds.put(99, (Object)SoundEvent.ARMOR_EQUIP_LEATHER);
        sounds.put(100, (Object)SoundEvent.ARMOR_EQUIP_ELYTRA);
        sounds.put(101, (Object)SoundEvent.RECORD_13);
        sounds.put(102, (Object)SoundEvent.RECORD_CAT);
        sounds.put(103, (Object)SoundEvent.RECORD_BLOCKS);
        sounds.put(104, (Object)SoundEvent.RECORD_CHIRP);
        sounds.put(105, (Object)SoundEvent.RECORD_FAR);
        sounds.put(106, (Object)SoundEvent.RECORD_MALL);
        sounds.put(107, (Object)SoundEvent.RECORD_MELLOHI);
        sounds.put(108, (Object)SoundEvent.RECORD_STAL);
        sounds.put(109, (Object)SoundEvent.RECORD_STRAD);
        sounds.put(110, (Object)SoundEvent.RECORD_WARD);
        sounds.put(111, (Object)SoundEvent.RECORD_11);
        sounds.put(112, (Object)SoundEvent.RECORD_WAIT);
        sounds.put(113, (Object)SoundEvent.STOP_RECORD);
        sounds.put(114, (Object)SoundEvent.FLOP);
        sounds.put(115, (Object)SoundEvent.ELDERGUARDIAN_CURSE);
        sounds.put(116, (Object)SoundEvent.MOB_WARNING);
        sounds.put(117, (Object)SoundEvent.MOB_WARNING_BABY);
        sounds.put(118, (Object)SoundEvent.TELEPORT);
        sounds.put(119, (Object)SoundEvent.SHULKER_OPEN);
        sounds.put(120, (Object)SoundEvent.SHULKER_CLOSE);
        sounds.put(121, (Object)SoundEvent.HAGGLE);
        sounds.put(122, (Object)SoundEvent.HAGGLE_YES);
        sounds.put(123, (Object)SoundEvent.HAGGLE_NO);
        sounds.put(124, (Object)SoundEvent.HAGGLE_IDLE);
        sounds.put(125, (Object)SoundEvent.CHORUSGROW);
        sounds.put(126, (Object)SoundEvent.CHORUSDEATH);
        sounds.put(127, (Object)SoundEvent.GLASS);
        sounds.put(128, (Object)SoundEvent.POTION_BREWED);
        sounds.put(129, (Object)SoundEvent.CAST_SPELL);
        sounds.put(130, (Object)SoundEvent.PREPARE_ATTACK);
        sounds.put(131, (Object)SoundEvent.PREPARE_SUMMON);
        sounds.put(132, (Object)SoundEvent.PREPARE_WOLOLO);
        sounds.put(133, (Object)SoundEvent.FANG);
        sounds.put(134, (Object)SoundEvent.CHARGE);
        sounds.put(135, (Object)SoundEvent.CAMERA_TAKE_PICTURE);
        sounds.put(136, (Object)SoundEvent.LEASHKNOT_PLACE);
        sounds.put(137, (Object)SoundEvent.LEASHKNOT_BREAK);
        sounds.put(138, (Object)SoundEvent.GROWL);
        sounds.put(139, (Object)SoundEvent.WHINE);
        sounds.put(140, (Object)SoundEvent.PANT);
        sounds.put(141, (Object)SoundEvent.PURR);
        sounds.put(142, (Object)SoundEvent.PURREOW);
        sounds.put(143, (Object)SoundEvent.DEATH_MIN_VOLUME);
        sounds.put(144, (Object)SoundEvent.DEATH_MID_VOLUME);
        sounds.put(145, (Object)SoundEvent.IMITATE_BLAZE);
        sounds.put(146, (Object)SoundEvent.IMITATE_CAVE_SPIDER);
        sounds.put(147, (Object)SoundEvent.IMITATE_CREEPER);
        sounds.put(148, (Object)SoundEvent.IMITATE_ELDER_GUARDIAN);
        sounds.put(149, (Object)SoundEvent.IMITATE_ENDER_DRAGON);
        sounds.put(150, (Object)SoundEvent.IMITATE_ENDERMAN);
        sounds.put(152, (Object)SoundEvent.IMITATE_EVOCATION_ILLAGER);
        sounds.put(153, (Object)SoundEvent.IMITATE_GHAST);
        sounds.put(154, (Object)SoundEvent.IMITATE_HUSK);
        sounds.put(155, (Object)SoundEvent.IMITATE_ILLUSION_ILLAGER);
        sounds.put(156, (Object)SoundEvent.IMITATE_MAGMA_CUBE);
        sounds.put(157, (Object)SoundEvent.IMITATE_POLAR_BEAR);
        sounds.put(158, (Object)SoundEvent.IMITATE_SHULKER);
        sounds.put(159, (Object)SoundEvent.IMITATE_SILVERFISH);
        sounds.put(160, (Object)SoundEvent.IMITATE_SKELETON);
        sounds.put(161, (Object)SoundEvent.IMITATE_SLIME);
        sounds.put(162, (Object)SoundEvent.IMITATE_SPIDER);
        sounds.put(163, (Object)SoundEvent.IMITATE_STRAY);
        sounds.put(164, (Object)SoundEvent.IMITATE_VEX);
        sounds.put(165, (Object)SoundEvent.IMITATE_VINDICATION_ILLAGER);
        sounds.put(166, (Object)SoundEvent.IMITATE_WITCH);
        sounds.put(167, (Object)SoundEvent.IMITATE_WITHER);
        sounds.put(168, (Object)SoundEvent.IMITATE_WITHER_SKELETON);
        sounds.put(169, (Object)SoundEvent.IMITATE_WOLF);
        sounds.put(170, (Object)SoundEvent.IMITATE_ZOMBIE);
        sounds.put(171, (Object)SoundEvent.IMITATE_ZOMBIE_PIGMAN);
        sounds.put(172, (Object)SoundEvent.IMITATE_ZOMBIE_VILLAGER);
        sounds.put(173, (Object)SoundEvent.BLOCK_END_PORTAL_FRAME_FILL);
        sounds.put(174, (Object)SoundEvent.BLOCK_END_PORTAL_SPAWN);
        sounds.put(175, (Object)SoundEvent.RANDOM_ANVIL_USE);
        sounds.put(176, (Object)SoundEvent.BOTTLE_DRAGONBREATH);
        sounds.put(177, (Object)SoundEvent.PORTAL_TRAVEL);
        sounds.put(178, (Object)SoundEvent.ITEM_TRIDENT_HIT);
        sounds.put(179, (Object)SoundEvent.ITEM_TRIDENT_RETURN);
        sounds.put(180, (Object)SoundEvent.ITEM_TRIDENT_RIPTIDE_1);
        sounds.put(181, (Object)SoundEvent.ITEM_TRIDENT_RIPTIDE_2);
        sounds.put(182, (Object)SoundEvent.ITEM_TRIDENT_RIPTIDE_3);
        sounds.put(183, (Object)SoundEvent.ITEM_TRIDENT_THROW);
        sounds.put(184, (Object)SoundEvent.ITEM_TRIDENT_THUNDER);
        sounds.put(185, (Object)SoundEvent.ITEM_TRIDENT_HIT_GROUND);
        sounds.put(186, (Object)SoundEvent.DEFAULT);
        sounds.put(188, (Object)SoundEvent.ELEMCONSTRUCT_OPEN);
        sounds.put(189, (Object)SoundEvent.ICEBOMB_HIT);
        sounds.put(190, (Object)SoundEvent.BALLOONPOP);
        sounds.put(191, (Object)SoundEvent.LT_REACTION_ICEBOMB);
        sounds.put(192, (Object)SoundEvent.LT_REACTION_BLEACH);
        sounds.put(193, (Object)SoundEvent.LT_REACTION_EPASTE);
        sounds.put(194, (Object)SoundEvent.LT_REACTION_EPASTE2);
        sounds.put(199, (Object)SoundEvent.LT_REACTION_FERTILIZER);
        sounds.put(200, (Object)SoundEvent.LT_REACTION_FIREBALL);
        sounds.put(201, (Object)SoundEvent.LT_REACTION_MGSALT);
        sounds.put(202, (Object)SoundEvent.LT_REACTION_MISCFIRE);
        sounds.put(203, (Object)SoundEvent.LT_REACTION_FIRE);
        sounds.put(204, (Object)SoundEvent.LT_REACTION_MISCEXPLOSION);
        sounds.put(205, (Object)SoundEvent.LT_REACTION_MISCMYSTICAL);
        sounds.put(206, (Object)SoundEvent.LT_REACTION_MISCMYSTICAL2);
        sounds.put(207, (Object)SoundEvent.LT_REACTION_PRODUCT);
        sounds.put(208, (Object)SoundEvent.SPARKLER_USE);
        sounds.put(209, (Object)SoundEvent.GLOWSTICK_USE);
        sounds.put(210, (Object)SoundEvent.SPARKLER_ACTIVE);
        sounds.put(211, (Object)SoundEvent.CONVERT_TO_DROWNED);
        sounds.put(212, (Object)SoundEvent.BUCKET_FILL_FISH);
        sounds.put(213, (Object)SoundEvent.BUCKET_EMPTY_FISH);
        sounds.put(214, (Object)SoundEvent.UNDEFINED);
    }
}

