/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v313.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.packet.LevelEventPacket;
import com.nukkitx.protocol.bedrock.v313.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import com.nukkitx.protocol.util.TIntHashBiMap;
import io.netty.buffer.ByteBuf;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class LevelEventSerializer_v313
implements PacketSerializer<LevelEventPacket> {
    public static final LevelEventSerializer_v313 INSTANCE = new LevelEventSerializer_v313();
    private static final InternalLogger log = InternalLoggerFactory.getInstance(LevelEventSerializer_v313.class);
    private static final TIntHashBiMap<LevelEventPacket.Event> events = new TIntHashBiMap();

    public void serialize(ByteBuf buffer, LevelEventPacket packet) {
        VarInts.writeInt((ByteBuf)buffer, (int)events.get((Object)packet.getEvent()));
        BedrockUtils.writeVector3f(buffer, packet.getPosition());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getData());
    }

    public void deserialize(ByteBuf buffer, LevelEventPacket packet) {
        int eventId = VarInts.readInt((ByteBuf)buffer);
        packet.setEvent((LevelEventPacket.Event)events.get(eventId));
        if (packet.getEvent() == null) {
            log.debug("Unknown Level Event {} received", (Object)eventId);
        }
        packet.setPosition(BedrockUtils.readVector3f(buffer));
        packet.setData(VarInts.readInt((ByteBuf)buffer));
    }

    private LevelEventSerializer_v313() {
    }

    static {
        events.put(1000, (Object)LevelEventPacket.Event.SOUND_CLICK);
        events.put(1001, (Object)LevelEventPacket.Event.SOUND_CLICK_FAIL);
        events.put(1002, (Object)LevelEventPacket.Event.SOUND_SHOOT);
        events.put(1003, (Object)LevelEventPacket.Event.SOUND_DOOR);
        events.put(1004, (Object)LevelEventPacket.Event.SOUND_FIZZ);
        events.put(1005, (Object)LevelEventPacket.Event.SOUND_IGNITE);
        events.put(1007, (Object)LevelEventPacket.Event.SOUND_GHAST);
        events.put(1008, (Object)LevelEventPacket.Event.SOUND_GHAST_SHOOT);
        events.put(1009, (Object)LevelEventPacket.Event.SOUND_BLAZE_SHOOT);
        events.put(1010, (Object)LevelEventPacket.Event.SOUND_DOOR_BUMP);
        events.put(1012, (Object)LevelEventPacket.Event.SOUND_DOOR_CRASH);
        events.put(1018, (Object)LevelEventPacket.Event.SOUND_ENDERMAN_TELEPORT);
        events.put(1020, (Object)LevelEventPacket.Event.SOUND_ANVIL_BREAK);
        events.put(1021, (Object)LevelEventPacket.Event.SOUND_ANVIL_USE);
        events.put(1022, (Object)LevelEventPacket.Event.SOUND_ANVIL_FALL);
        events.put(1030, (Object)LevelEventPacket.Event.SOUND_POP);
        events.put(1032, (Object)LevelEventPacket.Event.SOUND_PORTAL);
        events.put(1040, (Object)LevelEventPacket.Event.SOUND_ITEMFRAME_ADD_ITEM);
        events.put(1041, (Object)LevelEventPacket.Event.SOUND_ITEMFRAME_REMOVE);
        events.put(1042, (Object)LevelEventPacket.Event.SOUND_ITEMFRAME_PLACE);
        events.put(1043, (Object)LevelEventPacket.Event.SOUND_ITEMFRAME_REMOVE_ITEM);
        events.put(1044, (Object)LevelEventPacket.Event.SOUND_ITEMFRAME_ROTATE_ITEM);
        events.put(1050, (Object)LevelEventPacket.Event.SOUND_CAMERA);
        events.put(1051, (Object)LevelEventPacket.Event.SOUND_ORB);
        events.put(1052, (Object)LevelEventPacket.Event.SOUND_TOTEM);
        events.put(1060, (Object)LevelEventPacket.Event.SOUND_ARMOR_STAND_BREAK);
        events.put(1061, (Object)LevelEventPacket.Event.SOUND_ARMOR_STAND_HIT);
        events.put(1062, (Object)LevelEventPacket.Event.SOUND_ARMOR_STAND_FALL);
        events.put(1063, (Object)LevelEventPacket.Event.SOUND_ARMOR_STAND_PLACE);
        events.put(2000, (Object)LevelEventPacket.Event.PARTICLE_SHOOT);
        events.put(2001, (Object)LevelEventPacket.Event.PARTICLE_DESTROY);
        events.put(2002, (Object)LevelEventPacket.Event.PARTICLE_SPLASH);
        events.put(2003, (Object)LevelEventPacket.Event.PARTICLE_EYE_DESPAWN);
        events.put(2004, (Object)LevelEventPacket.Event.PARTICLE_SPAWN);
        events.put(2006, (Object)LevelEventPacket.Event.GUARDIAN_CURSE);
        events.put(2008, (Object)LevelEventPacket.Event.PARTICLE_BLOCK_FORCE_FIELD);
        events.put(2014, (Object)LevelEventPacket.Event.PARTICLE_PUNCH_BLOCK);
        events.put(2015, (Object)LevelEventPacket.Event.PARTICLE_WATER_SPLASH);
        events.put(3001, (Object)LevelEventPacket.Event.START_RAIN);
        events.put(3002, (Object)LevelEventPacket.Event.START_THUNDER);
        events.put(3003, (Object)LevelEventPacket.Event.STOP_RAIN);
        events.put(3004, (Object)LevelEventPacket.Event.STOP_THUNDER);
        events.put(3005, (Object)LevelEventPacket.Event.PAUSE_GAME);
        events.put(3500, (Object)LevelEventPacket.Event.REDSTONE_TRIGGER);
        events.put(3501, (Object)LevelEventPacket.Event.CAULDRON_EXPLODE);
        events.put(3502, (Object)LevelEventPacket.Event.CAULDRON_DYE_ARMOR);
        events.put(3503, (Object)LevelEventPacket.Event.CAULDRON_CLEAN_ARMOR);
        events.put(3504, (Object)LevelEventPacket.Event.CAULDRON_FILL_POTION);
        events.put(3505, (Object)LevelEventPacket.Event.CAULDRON_TAKE_POTION);
        events.put(3506, (Object)LevelEventPacket.Event.CAULDRON_FILL_WATER);
        events.put(3507, (Object)LevelEventPacket.Event.CAULDRON_TAKE_WATER);
        events.put(3508, (Object)LevelEventPacket.Event.CAULDRON_ADD_DYE);
        events.put(3509, (Object)LevelEventPacket.Event.CAULDRON_CLEAN_BANNER);
        events.put(3600, (Object)LevelEventPacket.Event.BLOCK_START_BREAK);
        events.put(3601, (Object)LevelEventPacket.Event.BLOCK_STOP_BREAK);
        events.put(4000, (Object)LevelEventPacket.Event.SET_DATA);
        events.put(9800, (Object)LevelEventPacket.Event.PLAYERS_SLEEPING);
    }
}

