/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v313.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.data.ContainerId;
import com.nukkitx.protocol.bedrock.data.ItemData;
import com.nukkitx.protocol.bedrock.packet.InventoryContentPacket;
import com.nukkitx.protocol.bedrock.v313.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;

public class InventoryContentSerializer_v313
implements PacketSerializer<InventoryContentPacket> {
    public static final InventoryContentSerializer_v313 INSTANCE = new InventoryContentSerializer_v313();

    public void serialize(ByteBuf buffer, InventoryContentPacket packet) {
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)packet.getContainerId().id());
        ItemData[] contents = packet.getContents();
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)contents.length);
        for (ItemData content : contents) {
            BedrockUtils.writeItemData(buffer, content);
        }
    }

    public void deserialize(ByteBuf buffer, InventoryContentPacket packet) {
        packet.setContainerId(ContainerId.byId((int)VarInts.readUnsignedInt((ByteBuf)buffer)));
        ItemData[] contents = new ItemData[VarInts.readUnsignedInt((ByteBuf)buffer)];
        for (int i = 0; i < contents.length; ++i) {
            contents[i] = BedrockUtils.readItemData(buffer);
        }
        packet.setContents(contents);
    }

    private InventoryContentSerializer_v313() {
    }
}

