/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v313.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.packet.EntityEventPacket;
import com.nukkitx.protocol.serializer.PacketSerializer;
import com.nukkitx.protocol.util.TIntHashBiMap;
import io.netty.buffer.ByteBuf;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class EntityEventSerializer_v313
implements PacketSerializer<EntityEventPacket> {
    public static final EntityEventSerializer_v313 INSTANCE = new EntityEventSerializer_v313();
    private static final TIntHashBiMap<EntityEventPacket.Event> events = new TIntHashBiMap();
    private static final InternalLogger log = InternalLoggerFactory.getInstance(EntityEventSerializer_v313.class);

    public void serialize(ByteBuf buffer, EntityEventPacket packet) {
        VarInts.writeUnsignedLong((ByteBuf)buffer, (long)packet.getRuntimeEntityId());
        buffer.writeByte(events.get((Object)packet.getEvent()));
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getData());
    }

    public void deserialize(ByteBuf buffer, EntityEventPacket packet) {
        packet.setRuntimeEntityId(VarInts.readUnsignedLong((ByteBuf)buffer));
        short event = buffer.readUnsignedByte();
        packet.setEvent((EntityEventPacket.Event)events.get((int)event));
        packet.setData(VarInts.readInt((ByteBuf)buffer));
        if (packet.getEvent() == null) {
            log.debug("Unknown EntityEvent {} in packet {}", (Object)event, (Object)packet);
        }
    }

    private EntityEventSerializer_v313() {
    }

    static {
        events.put(2, (Object)EntityEventPacket.Event.HURT_ANIMATION);
        events.put(3, (Object)EntityEventPacket.Event.DEATH_ANIMATION);
        events.put(4, (Object)EntityEventPacket.Event.ARM_SWING);
        events.put(6, (Object)EntityEventPacket.Event.TAME_FAIL);
        events.put(7, (Object)EntityEventPacket.Event.TAME_SUCCESS);
        events.put(8, (Object)EntityEventPacket.Event.SHAKE_WET);
        events.put(9, (Object)EntityEventPacket.Event.USE_ITEM);
        events.put(10, (Object)EntityEventPacket.Event.EAT_BLOCK_ANIMATION);
        events.put(11, (Object)EntityEventPacket.Event.FISH_HOOK_BUBBLE);
        events.put(12, (Object)EntityEventPacket.Event.FISH_HOOK_POSITION);
        events.put(13, (Object)EntityEventPacket.Event.FISH_HOOK_HOOK);
        events.put(14, (Object)EntityEventPacket.Event.FISH_HOOK_LURED);
        events.put(15, (Object)EntityEventPacket.Event.SQUID_INK_CLOUD);
        events.put(16, (Object)EntityEventPacket.Event.ZOMBIE_VILLAGER_CURE);
        events.put(18, (Object)EntityEventPacket.Event.RESPAWN);
        events.put(19, (Object)EntityEventPacket.Event.IRON_GOLEM_OFFER_FLOWER);
        events.put(20, (Object)EntityEventPacket.Event.IRON_GOLEM_WITHDRAW_FLOWER);
        events.put(21, (Object)EntityEventPacket.Event.LOVE_PARTICLES);
        events.put(22, (Object)EntityEventPacket.Event.VILLAGER_HURT);
        events.put(23, (Object)EntityEventPacket.Event.VILLAGER_STOP_TRADING);
        events.put(24, (Object)EntityEventPacket.Event.WITCH_SPELL_PARTICLES);
        events.put(25, (Object)EntityEventPacket.Event.FIREWORK_PARTICLES);
        events.put(27, (Object)EntityEventPacket.Event.SILVERFISH_MERGE_WITH_STONE);
        events.put(28, (Object)EntityEventPacket.Event.GUARDIAN_ATTACK_ANIMATION);
        events.put(29, (Object)EntityEventPacket.Event.WITCH_DRINK_POTION);
        events.put(30, (Object)EntityEventPacket.Event.WITCH_THROW_POTION);
        events.put(31, (Object)EntityEventPacket.Event.MINECART_TNT_PRIME_FUSE);
        events.put(34, (Object)EntityEventPacket.Event.PLAYER_ADD_XP_LEVELS);
        events.put(35, (Object)EntityEventPacket.Event.ELDER_GUARDIAN_CURSE);
        events.put(36, (Object)EntityEventPacket.Event.AGENT_ARM_SWING);
        events.put(37, (Object)EntityEventPacket.Event.ENDER_DRAGON_DEATH);
        events.put(38, (Object)EntityEventPacket.Event.DUST_PARTICLES);
        events.put(39, (Object)EntityEventPacket.Event.ARROW_SHAKE);
        events.put(57, (Object)EntityEventPacket.Event.EATING_ITEM);
        events.put(60, (Object)EntityEventPacket.Event.BABY_ANIMAL_FEED);
        events.put(61, (Object)EntityEventPacket.Event.DEATH_SMOKE_CLOUD);
        events.put(62, (Object)EntityEventPacket.Event.COMPLETE_TRADE);
        events.put(63, (Object)EntityEventPacket.Event.REMOVE_LEASH);
        events.put(64, (Object)EntityEventPacket.Event.CARAVAN);
        events.put(65, (Object)EntityEventPacket.Event.CONSUME_TOTEM);
        events.put(66, (Object)EntityEventPacket.Event.CHECK_TREASURE_HUNTER_ACHIEVEMENT);
        events.put(67, (Object)EntityEventPacket.Event.ENTITY_SPAWN);
        events.put(68, (Object)EntityEventPacket.Event.DRAGON_FLAMING);
        events.put(69, (Object)EntityEventPacket.Event.MERGE_ITEMS);
        events.put(71, (Object)EntityEventPacket.Event.BALLOON_POP);
        events.put(72, (Object)EntityEventPacket.Event.FIND_TREASURE_BRIBE);
    }
}

