/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v313.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.data.MapDecoration;
import com.nukkitx.protocol.bedrock.data.MapTrackedObject;
import com.nukkitx.protocol.bedrock.packet.ClientboundMapItemDataPacket;
import com.nukkitx.protocol.bedrock.v313.BedrockUtils;
import com.nukkitx.protocol.serializer.PacketSerializer;
import gnu.trove.list.TLongList;
import io.netty.buffer.ByteBuf;
import java.util.List;

public class ClientboundMapItemDataSerializer_v313
implements PacketSerializer<ClientboundMapItemDataPacket> {
    public static final ClientboundMapItemDataSerializer_v313 INSTANCE = new ClientboundMapItemDataSerializer_v313();

    public void serialize(ByteBuf buffer, ClientboundMapItemDataPacket packet) {
        TLongList trackedEntityIds;
        VarInts.writeLong((ByteBuf)buffer, (long)packet.getUniqueMapId());
        int type = 0;
        int[] colors = packet.getColors();
        if (colors != null && colors.length > 0) {
            type |= 2;
        }
        List decorations = packet.getDecorations();
        List trackedObjects = packet.getTrackedObjects();
        if (!decorations.isEmpty() && !trackedObjects.isEmpty()) {
            type |= 4;
        }
        if (!(trackedEntityIds = packet.getTrackedEntityIds()).isEmpty()) {
            type |= 8;
        }
        VarInts.writeUnsignedInt((ByteBuf)buffer, (long)type);
        buffer.writeByte(packet.getDimensionId());
        if ((type & 8) != 0) {
            VarInts.writeUnsignedInt((ByteBuf)buffer, (long)trackedEntityIds.size());
            for (long trackedEntityId : trackedEntityIds.toArray()) {
                VarInts.writeLong((ByteBuf)buffer, (long)trackedEntityId);
            }
        }
        if ((type & 0xE) != 0) {
            buffer.writeByte(packet.getScale());
        }
        if ((type & 4) != 0) {
            VarInts.writeUnsignedInt((ByteBuf)buffer, (long)trackedObjects.size());
            for (MapTrackedObject object2 : trackedObjects) {
                switch (object2.getType()) {
                    case BLOCK: {
                        buffer.writeIntLE(object2.getType().ordinal());
                        BedrockUtils.writeBlockPosition(buffer, object2.getPosition());
                        break;
                    }
                    case ENTITY: {
                        buffer.writeIntLE(object2.getType().ordinal());
                        VarInts.writeLong((ByteBuf)buffer, (long)object2.getEntityId());
                    }
                }
            }
            VarInts.writeUnsignedInt((ByteBuf)buffer, (long)decorations.size());
            for (MapDecoration decoration : decorations) {
                buffer.writeByte(decoration.getImage());
                buffer.writeByte(decoration.getRotation());
                buffer.writeByte(decoration.getXOffset());
                buffer.writeByte(decoration.getYOffset());
                BedrockUtils.writeString(buffer, decoration.getLabel());
                VarInts.writeUnsignedInt((ByteBuf)buffer, (long)decoration.getColor());
            }
        }
        if ((type & 2) != 0) {
            VarInts.writeInt((ByteBuf)buffer, (int)packet.getWidth());
            VarInts.writeInt((ByteBuf)buffer, (int)packet.getHeight());
            VarInts.writeInt((ByteBuf)buffer, (int)packet.getXOffset());
            VarInts.writeInt((ByteBuf)buffer, (int)packet.getYOffset());
            VarInts.writeUnsignedInt((ByteBuf)buffer, (long)colors.length);
            for (int color : colors) {
                VarInts.writeUnsignedInt((ByteBuf)buffer, (long)color);
            }
        }
    }

    public void deserialize(ByteBuf buffer, ClientboundMapItemDataPacket packet) {
        int i;
        int length;
        packet.setUniqueMapId(VarInts.readLong((ByteBuf)buffer));
        int type = VarInts.readUnsignedInt((ByteBuf)buffer);
        packet.setDimensionId((int)buffer.readUnsignedByte());
        if ((type & 8) != 0) {
            TLongList trackedEntityIds = packet.getTrackedEntityIds();
            length = VarInts.readUnsignedInt((ByteBuf)buffer);
            for (i = 0; i < length; ++i) {
                trackedEntityIds.add(VarInts.readLong((ByteBuf)buffer));
            }
        }
        if ((type & 0xE) != 0) {
            packet.setScale((int)buffer.readUnsignedByte());
        }
        if ((type & 4) != 0) {
            List trackedObjects = packet.getTrackedObjects();
            length = VarInts.readUnsignedInt((ByteBuf)buffer);
            block5: for (i = 0; i < length; ++i) {
                MapTrackedObject.Type objectType = MapTrackedObject.Type.values()[buffer.readIntLE()];
                switch (objectType) {
                    case BLOCK: {
                        trackedObjects.add(new MapTrackedObject(BedrockUtils.readBlockPosition(buffer)));
                        continue block5;
                    }
                    case ENTITY: {
                        trackedObjects.add(new MapTrackedObject(VarInts.readLong((ByteBuf)buffer)));
                    }
                }
            }
            List decorations = packet.getDecorations();
            length = VarInts.readUnsignedInt((ByteBuf)buffer);
            for (int i2 = 0; i2 < length; ++i2) {
                short image = buffer.readUnsignedByte();
                short rotation = buffer.readUnsignedByte();
                short xOffset = buffer.readUnsignedByte();
                short yOffset = buffer.readUnsignedByte();
                String label = BedrockUtils.readString(buffer);
                int color = VarInts.readUnsignedInt((ByteBuf)buffer);
                decorations.add(new MapDecoration((int)image, (int)rotation, (int)xOffset, (int)yOffset, label, color));
            }
        }
        if ((type & 2) != 0) {
            packet.setWidth(VarInts.readInt((ByteBuf)buffer));
            packet.setHeight(VarInts.readInt((ByteBuf)buffer));
            packet.setXOffset(VarInts.readInt((ByteBuf)buffer));
            packet.setYOffset(VarInts.readInt((ByteBuf)buffer));
            int length2 = VarInts.readUnsignedInt((ByteBuf)buffer);
            int[] colors = new int[length2];
            for (i = 0; i < length2; ++i) {
                colors[i] = VarInts.readUnsignedInt((ByteBuf)buffer);
            }
            packet.setColors(colors);
        }
    }

    private ClientboundMapItemDataSerializer_v313() {
    }
}

