/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.packet;

import com.flowpowered.math.vector.Vector2f;
import com.flowpowered.math.vector.Vector3f;
import com.flowpowered.math.vector.Vector3i;
import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.data.GamePublishSetting;
import com.nukkitx.protocol.bedrock.data.GameRule;
import com.nukkitx.protocol.bedrock.handler.BedrockPacketHandler;
import io.netty.buffer.ByteBuf;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartGamePacket
extends BedrockPacket {
    private final List<GameRule> gamerules = new ArrayList<GameRule>();
    private long uniqueEntityId;
    private long runtimeEntityId;
    private int playerGamemode;
    private Vector3f playerPosition;
    private Vector2f rotation;
    private int seed;
    private int dimensionId;
    private int generatorId;
    private int levelGamemode;
    private int difficulty;
    private Vector3i defaultSpawn;
    private boolean acheivementsDisabled;
    private int time;
    private boolean eduLevel;
    private boolean eduFeaturesEnabled;
    private float rainLevel;
    private float lightningLevel;
    private boolean platformLockedContentConfirmed;
    private boolean multiplayerGame;
    private boolean broadcastingToLan;
    private GamePublishSetting xblBroadcastMode;
    private GamePublishSetting platformBroadcastMode;
    private boolean commandsEnabled;
    private boolean texturePacksRequired;
    private boolean bonusChestEnabled;
    private boolean startingWithMap;
    private boolean trustingPlayers;
    private int defaultPlayerPermission;
    private int serverChunkTickRange;
    private boolean behaviorPackLocked;
    private boolean resourcePackLocked;
    private boolean fromLockedWorldTemplate;
    private boolean usingMsaGamertagsOnly;
    private boolean fromWorldTemplate;
    private boolean worldTemplateOptionLocked;
    private boolean onlySpawningV1Villagers;
    private String levelId;
    private String worldName;
    private String premiumWorldTemplateId;
    private boolean trial;
    private long currentTick;
    private int enchantmentSeed;
    private ByteBuf cachedPalette;
    private Collection<BlockPaletteEntry> paletteEntries = new ArrayDeque<BlockPaletteEntry>();
    private Collection<ItemEntry> itemEntries = new ArrayDeque<ItemEntry>();
    private String multiplayerCorrelationId;

    @Override
    public final boolean handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    public List<GameRule> getGamerules() {
        return this.gamerules;
    }

    public long getUniqueEntityId() {
        return this.uniqueEntityId;
    }

    public long getRuntimeEntityId() {
        return this.runtimeEntityId;
    }

    public int getPlayerGamemode() {
        return this.playerGamemode;
    }

    public Vector3f getPlayerPosition() {
        return this.playerPosition;
    }

    public Vector2f getRotation() {
        return this.rotation;
    }

    public int getSeed() {
        return this.seed;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public int getGeneratorId() {
        return this.generatorId;
    }

    public int getLevelGamemode() {
        return this.levelGamemode;
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public Vector3i getDefaultSpawn() {
        return this.defaultSpawn;
    }

    public boolean isAcheivementsDisabled() {
        return this.acheivementsDisabled;
    }

    public int getTime() {
        return this.time;
    }

    public boolean isEduLevel() {
        return this.eduLevel;
    }

    public boolean isEduFeaturesEnabled() {
        return this.eduFeaturesEnabled;
    }

    public float getRainLevel() {
        return this.rainLevel;
    }

    public float getLightningLevel() {
        return this.lightningLevel;
    }

    public boolean isPlatformLockedContentConfirmed() {
        return this.platformLockedContentConfirmed;
    }

    public boolean isMultiplayerGame() {
        return this.multiplayerGame;
    }

    public boolean isBroadcastingToLan() {
        return this.broadcastingToLan;
    }

    public GamePublishSetting getXblBroadcastMode() {
        return this.xblBroadcastMode;
    }

    public GamePublishSetting getPlatformBroadcastMode() {
        return this.platformBroadcastMode;
    }

    public boolean isCommandsEnabled() {
        return this.commandsEnabled;
    }

    public boolean isTexturePacksRequired() {
        return this.texturePacksRequired;
    }

    public boolean isBonusChestEnabled() {
        return this.bonusChestEnabled;
    }

    public boolean isStartingWithMap() {
        return this.startingWithMap;
    }

    public boolean isTrustingPlayers() {
        return this.trustingPlayers;
    }

    public int getDefaultPlayerPermission() {
        return this.defaultPlayerPermission;
    }

    public int getServerChunkTickRange() {
        return this.serverChunkTickRange;
    }

    public boolean isBehaviorPackLocked() {
        return this.behaviorPackLocked;
    }

    public boolean isResourcePackLocked() {
        return this.resourcePackLocked;
    }

    public boolean isFromLockedWorldTemplate() {
        return this.fromLockedWorldTemplate;
    }

    public boolean isUsingMsaGamertagsOnly() {
        return this.usingMsaGamertagsOnly;
    }

    public boolean isFromWorldTemplate() {
        return this.fromWorldTemplate;
    }

    public boolean isWorldTemplateOptionLocked() {
        return this.worldTemplateOptionLocked;
    }

    public boolean isOnlySpawningV1Villagers() {
        return this.onlySpawningV1Villagers;
    }

    public String getLevelId() {
        return this.levelId;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public String getPremiumWorldTemplateId() {
        return this.premiumWorldTemplateId;
    }

    public boolean isTrial() {
        return this.trial;
    }

    public long getCurrentTick() {
        return this.currentTick;
    }

    public int getEnchantmentSeed() {
        return this.enchantmentSeed;
    }

    public ByteBuf getCachedPalette() {
        return this.cachedPalette;
    }

    public Collection<BlockPaletteEntry> getPaletteEntries() {
        return this.paletteEntries;
    }

    public Collection<ItemEntry> getItemEntries() {
        return this.itemEntries;
    }

    public String getMultiplayerCorrelationId() {
        return this.multiplayerCorrelationId;
    }

    public void setUniqueEntityId(long uniqueEntityId) {
        this.uniqueEntityId = uniqueEntityId;
    }

    public void setRuntimeEntityId(long runtimeEntityId) {
        this.runtimeEntityId = runtimeEntityId;
    }

    public void setPlayerGamemode(int playerGamemode) {
        this.playerGamemode = playerGamemode;
    }

    public void setPlayerPosition(Vector3f playerPosition) {
        this.playerPosition = playerPosition;
    }

    public void setRotation(Vector2f rotation) {
        this.rotation = rotation;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public void setDimensionId(int dimensionId) {
        this.dimensionId = dimensionId;
    }

    public void setGeneratorId(int generatorId) {
        this.generatorId = generatorId;
    }

    public void setLevelGamemode(int levelGamemode) {
        this.levelGamemode = levelGamemode;
    }

    public void setDifficulty(int difficulty) {
        this.difficulty = difficulty;
    }

    public void setDefaultSpawn(Vector3i defaultSpawn) {
        this.defaultSpawn = defaultSpawn;
    }

    public void setAcheivementsDisabled(boolean acheivementsDisabled) {
        this.acheivementsDisabled = acheivementsDisabled;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public void setEduLevel(boolean eduLevel) {
        this.eduLevel = eduLevel;
    }

    public void setEduFeaturesEnabled(boolean eduFeaturesEnabled) {
        this.eduFeaturesEnabled = eduFeaturesEnabled;
    }

    public void setRainLevel(float rainLevel) {
        this.rainLevel = rainLevel;
    }

    public void setLightningLevel(float lightningLevel) {
        this.lightningLevel = lightningLevel;
    }

    public void setPlatformLockedContentConfirmed(boolean platformLockedContentConfirmed) {
        this.platformLockedContentConfirmed = platformLockedContentConfirmed;
    }

    public void setMultiplayerGame(boolean multiplayerGame) {
        this.multiplayerGame = multiplayerGame;
    }

    public void setBroadcastingToLan(boolean broadcastingToLan) {
        this.broadcastingToLan = broadcastingToLan;
    }

    public void setXblBroadcastMode(GamePublishSetting xblBroadcastMode) {
        this.xblBroadcastMode = xblBroadcastMode;
    }

    public void setPlatformBroadcastMode(GamePublishSetting platformBroadcastMode) {
        this.platformBroadcastMode = platformBroadcastMode;
    }

    public void setCommandsEnabled(boolean commandsEnabled) {
        this.commandsEnabled = commandsEnabled;
    }

    public void setTexturePacksRequired(boolean texturePacksRequired) {
        this.texturePacksRequired = texturePacksRequired;
    }

    public void setBonusChestEnabled(boolean bonusChestEnabled) {
        this.bonusChestEnabled = bonusChestEnabled;
    }

    public void setStartingWithMap(boolean startingWithMap) {
        this.startingWithMap = startingWithMap;
    }

    public void setTrustingPlayers(boolean trustingPlayers) {
        this.trustingPlayers = trustingPlayers;
    }

    public void setDefaultPlayerPermission(int defaultPlayerPermission) {
        this.defaultPlayerPermission = defaultPlayerPermission;
    }

    public void setServerChunkTickRange(int serverChunkTickRange) {
        this.serverChunkTickRange = serverChunkTickRange;
    }

    public void setBehaviorPackLocked(boolean behaviorPackLocked) {
        this.behaviorPackLocked = behaviorPackLocked;
    }

    public void setResourcePackLocked(boolean resourcePackLocked) {
        this.resourcePackLocked = resourcePackLocked;
    }

    public void setFromLockedWorldTemplate(boolean fromLockedWorldTemplate) {
        this.fromLockedWorldTemplate = fromLockedWorldTemplate;
    }

    public void setUsingMsaGamertagsOnly(boolean usingMsaGamertagsOnly) {
        this.usingMsaGamertagsOnly = usingMsaGamertagsOnly;
    }

    public void setFromWorldTemplate(boolean fromWorldTemplate) {
        this.fromWorldTemplate = fromWorldTemplate;
    }

    public void setWorldTemplateOptionLocked(boolean worldTemplateOptionLocked) {
        this.worldTemplateOptionLocked = worldTemplateOptionLocked;
    }

    public void setOnlySpawningV1Villagers(boolean onlySpawningV1Villagers) {
        this.onlySpawningV1Villagers = onlySpawningV1Villagers;
    }

    public void setLevelId(String levelId) {
        this.levelId = levelId;
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    public void setPremiumWorldTemplateId(String premiumWorldTemplateId) {
        this.premiumWorldTemplateId = premiumWorldTemplateId;
    }

    public void setTrial(boolean trial) {
        this.trial = trial;
    }

    public void setCurrentTick(long currentTick) {
        this.currentTick = currentTick;
    }

    public void setEnchantmentSeed(int enchantmentSeed) {
        this.enchantmentSeed = enchantmentSeed;
    }

    public void setCachedPalette(ByteBuf cachedPalette) {
        this.cachedPalette = cachedPalette;
    }

    public void setPaletteEntries(Collection<BlockPaletteEntry> paletteEntries) {
        this.paletteEntries = paletteEntries;
    }

    public void setItemEntries(Collection<ItemEntry> itemEntries) {
        this.itemEntries = itemEntries;
    }

    public void setMultiplayerCorrelationId(String multiplayerCorrelationId) {
        this.multiplayerCorrelationId = multiplayerCorrelationId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StartGamePacket)) {
            return false;
        }
        StartGamePacket other = (StartGamePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<GameRule> this$gamerules = this.getGamerules();
        List<GameRule> other$gamerules = other.getGamerules();
        if (this$gamerules == null ? other$gamerules != null : !((Object)this$gamerules).equals(other$gamerules)) {
            return false;
        }
        if (this.getUniqueEntityId() != other.getUniqueEntityId()) {
            return false;
        }
        if (this.getRuntimeEntityId() != other.getRuntimeEntityId()) {
            return false;
        }
        if (this.getPlayerGamemode() != other.getPlayerGamemode()) {
            return false;
        }
        Vector3f this$playerPosition = this.getPlayerPosition();
        Vector3f other$playerPosition = other.getPlayerPosition();
        if (this$playerPosition == null ? other$playerPosition != null : !this$playerPosition.equals(other$playerPosition)) {
            return false;
        }
        Vector2f this$rotation = this.getRotation();
        Vector2f other$rotation = other.getRotation();
        if (this$rotation == null ? other$rotation != null : !this$rotation.equals(other$rotation)) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        if (this.getDimensionId() != other.getDimensionId()) {
            return false;
        }
        if (this.getGeneratorId() != other.getGeneratorId()) {
            return false;
        }
        if (this.getLevelGamemode() != other.getLevelGamemode()) {
            return false;
        }
        if (this.getDifficulty() != other.getDifficulty()) {
            return false;
        }
        Vector3i this$defaultSpawn = this.getDefaultSpawn();
        Vector3i other$defaultSpawn = other.getDefaultSpawn();
        if (this$defaultSpawn == null ? other$defaultSpawn != null : !this$defaultSpawn.equals(other$defaultSpawn)) {
            return false;
        }
        if (this.isAcheivementsDisabled() != other.isAcheivementsDisabled()) {
            return false;
        }
        if (this.getTime() != other.getTime()) {
            return false;
        }
        if (this.isEduLevel() != other.isEduLevel()) {
            return false;
        }
        if (this.isEduFeaturesEnabled() != other.isEduFeaturesEnabled()) {
            return false;
        }
        if (Float.compare(this.getRainLevel(), other.getRainLevel()) != 0) {
            return false;
        }
        if (Float.compare(this.getLightningLevel(), other.getLightningLevel()) != 0) {
            return false;
        }
        if (this.isPlatformLockedContentConfirmed() != other.isPlatformLockedContentConfirmed()) {
            return false;
        }
        if (this.isMultiplayerGame() != other.isMultiplayerGame()) {
            return false;
        }
        if (this.isBroadcastingToLan() != other.isBroadcastingToLan()) {
            return false;
        }
        GamePublishSetting this$xblBroadcastMode = this.getXblBroadcastMode();
        GamePublishSetting other$xblBroadcastMode = other.getXblBroadcastMode();
        if (this$xblBroadcastMode == null ? other$xblBroadcastMode != null : !((Object)((Object)this$xblBroadcastMode)).equals((Object)other$xblBroadcastMode)) {
            return false;
        }
        GamePublishSetting this$platformBroadcastMode = this.getPlatformBroadcastMode();
        GamePublishSetting other$platformBroadcastMode = other.getPlatformBroadcastMode();
        if (this$platformBroadcastMode == null ? other$platformBroadcastMode != null : !((Object)((Object)this$platformBroadcastMode)).equals((Object)other$platformBroadcastMode)) {
            return false;
        }
        if (this.isCommandsEnabled() != other.isCommandsEnabled()) {
            return false;
        }
        if (this.isTexturePacksRequired() != other.isTexturePacksRequired()) {
            return false;
        }
        if (this.isBonusChestEnabled() != other.isBonusChestEnabled()) {
            return false;
        }
        if (this.isStartingWithMap() != other.isStartingWithMap()) {
            return false;
        }
        if (this.isTrustingPlayers() != other.isTrustingPlayers()) {
            return false;
        }
        if (this.getDefaultPlayerPermission() != other.getDefaultPlayerPermission()) {
            return false;
        }
        if (this.getServerChunkTickRange() != other.getServerChunkTickRange()) {
            return false;
        }
        if (this.isBehaviorPackLocked() != other.isBehaviorPackLocked()) {
            return false;
        }
        if (this.isResourcePackLocked() != other.isResourcePackLocked()) {
            return false;
        }
        if (this.isFromLockedWorldTemplate() != other.isFromLockedWorldTemplate()) {
            return false;
        }
        if (this.isUsingMsaGamertagsOnly() != other.isUsingMsaGamertagsOnly()) {
            return false;
        }
        if (this.isFromWorldTemplate() != other.isFromWorldTemplate()) {
            return false;
        }
        if (this.isWorldTemplateOptionLocked() != other.isWorldTemplateOptionLocked()) {
            return false;
        }
        if (this.isOnlySpawningV1Villagers() != other.isOnlySpawningV1Villagers()) {
            return false;
        }
        String this$levelId = this.getLevelId();
        String other$levelId = other.getLevelId();
        if (this$levelId == null ? other$levelId != null : !this$levelId.equals(other$levelId)) {
            return false;
        }
        String this$worldName = this.getWorldName();
        String other$worldName = other.getWorldName();
        if (this$worldName == null ? other$worldName != null : !this$worldName.equals(other$worldName)) {
            return false;
        }
        String this$premiumWorldTemplateId = this.getPremiumWorldTemplateId();
        String other$premiumWorldTemplateId = other.getPremiumWorldTemplateId();
        if (this$premiumWorldTemplateId == null ? other$premiumWorldTemplateId != null : !this$premiumWorldTemplateId.equals(other$premiumWorldTemplateId)) {
            return false;
        }
        if (this.isTrial() != other.isTrial()) {
            return false;
        }
        if (this.getCurrentTick() != other.getCurrentTick()) {
            return false;
        }
        if (this.getEnchantmentSeed() != other.getEnchantmentSeed()) {
            return false;
        }
        ByteBuf this$cachedPalette = this.getCachedPalette();
        ByteBuf other$cachedPalette = other.getCachedPalette();
        if (this$cachedPalette == null ? other$cachedPalette != null : !this$cachedPalette.equals(other$cachedPalette)) {
            return false;
        }
        Collection<BlockPaletteEntry> this$paletteEntries = this.getPaletteEntries();
        Collection<BlockPaletteEntry> other$paletteEntries = other.getPaletteEntries();
        if (this$paletteEntries == null ? other$paletteEntries != null : !((Object)this$paletteEntries).equals(other$paletteEntries)) {
            return false;
        }
        Collection<ItemEntry> this$itemEntries = this.getItemEntries();
        Collection<ItemEntry> other$itemEntries = other.getItemEntries();
        if (this$itemEntries == null ? other$itemEntries != null : !((Object)this$itemEntries).equals(other$itemEntries)) {
            return false;
        }
        String this$multiplayerCorrelationId = this.getMultiplayerCorrelationId();
        String other$multiplayerCorrelationId = other.getMultiplayerCorrelationId();
        return !(this$multiplayerCorrelationId == null ? other$multiplayerCorrelationId != null : !this$multiplayerCorrelationId.equals(other$multiplayerCorrelationId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StartGamePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<GameRule> $gamerules = this.getGamerules();
        result = result * 59 + ($gamerules == null ? 43 : ((Object)$gamerules).hashCode());
        long $uniqueEntityId = this.getUniqueEntityId();
        result = result * 59 + (int)($uniqueEntityId >>> 32 ^ $uniqueEntityId);
        long $runtimeEntityId = this.getRuntimeEntityId();
        result = result * 59 + (int)($runtimeEntityId >>> 32 ^ $runtimeEntityId);
        result = result * 59 + this.getPlayerGamemode();
        Vector3f $playerPosition = this.getPlayerPosition();
        result = result * 59 + ($playerPosition == null ? 43 : $playerPosition.hashCode());
        Vector2f $rotation = this.getRotation();
        result = result * 59 + ($rotation == null ? 43 : $rotation.hashCode());
        result = result * 59 + this.getSeed();
        result = result * 59 + this.getDimensionId();
        result = result * 59 + this.getGeneratorId();
        result = result * 59 + this.getLevelGamemode();
        result = result * 59 + this.getDifficulty();
        Vector3i $defaultSpawn = this.getDefaultSpawn();
        result = result * 59 + ($defaultSpawn == null ? 43 : $defaultSpawn.hashCode());
        result = result * 59 + (this.isAcheivementsDisabled() ? 79 : 97);
        result = result * 59 + this.getTime();
        result = result * 59 + (this.isEduLevel() ? 79 : 97);
        result = result * 59 + (this.isEduFeaturesEnabled() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getRainLevel());
        result = result * 59 + Float.floatToIntBits(this.getLightningLevel());
        result = result * 59 + (this.isPlatformLockedContentConfirmed() ? 79 : 97);
        result = result * 59 + (this.isMultiplayerGame() ? 79 : 97);
        result = result * 59 + (this.isBroadcastingToLan() ? 79 : 97);
        GamePublishSetting $xblBroadcastMode = this.getXblBroadcastMode();
        result = result * 59 + ($xblBroadcastMode == null ? 43 : ((Object)((Object)$xblBroadcastMode)).hashCode());
        GamePublishSetting $platformBroadcastMode = this.getPlatformBroadcastMode();
        result = result * 59 + ($platformBroadcastMode == null ? 43 : ((Object)((Object)$platformBroadcastMode)).hashCode());
        result = result * 59 + (this.isCommandsEnabled() ? 79 : 97);
        result = result * 59 + (this.isTexturePacksRequired() ? 79 : 97);
        result = result * 59 + (this.isBonusChestEnabled() ? 79 : 97);
        result = result * 59 + (this.isStartingWithMap() ? 79 : 97);
        result = result * 59 + (this.isTrustingPlayers() ? 79 : 97);
        result = result * 59 + this.getDefaultPlayerPermission();
        result = result * 59 + this.getServerChunkTickRange();
        result = result * 59 + (this.isBehaviorPackLocked() ? 79 : 97);
        result = result * 59 + (this.isResourcePackLocked() ? 79 : 97);
        result = result * 59 + (this.isFromLockedWorldTemplate() ? 79 : 97);
        result = result * 59 + (this.isUsingMsaGamertagsOnly() ? 79 : 97);
        result = result * 59 + (this.isFromWorldTemplate() ? 79 : 97);
        result = result * 59 + (this.isWorldTemplateOptionLocked() ? 79 : 97);
        result = result * 59 + (this.isOnlySpawningV1Villagers() ? 79 : 97);
        String $levelId = this.getLevelId();
        result = result * 59 + ($levelId == null ? 43 : $levelId.hashCode());
        String $worldName = this.getWorldName();
        result = result * 59 + ($worldName == null ? 43 : $worldName.hashCode());
        String $premiumWorldTemplateId = this.getPremiumWorldTemplateId();
        result = result * 59 + ($premiumWorldTemplateId == null ? 43 : $premiumWorldTemplateId.hashCode());
        result = result * 59 + (this.isTrial() ? 79 : 97);
        long $currentTick = this.getCurrentTick();
        result = result * 59 + (int)($currentTick >>> 32 ^ $currentTick);
        result = result * 59 + this.getEnchantmentSeed();
        ByteBuf $cachedPalette = this.getCachedPalette();
        result = result * 59 + ($cachedPalette == null ? 43 : $cachedPalette.hashCode());
        Collection<BlockPaletteEntry> $paletteEntries = this.getPaletteEntries();
        result = result * 59 + ($paletteEntries == null ? 43 : ((Object)$paletteEntries).hashCode());
        Collection<ItemEntry> $itemEntries = this.getItemEntries();
        result = result * 59 + ($itemEntries == null ? 43 : ((Object)$itemEntries).hashCode());
        String $multiplayerCorrelationId = this.getMultiplayerCorrelationId();
        result = result * 59 + ($multiplayerCorrelationId == null ? 43 : $multiplayerCorrelationId.hashCode());
        return result;
    }

    public String toString() {
        return "StartGamePacket(gamerules=" + this.getGamerules() + ", uniqueEntityId=" + this.getUniqueEntityId() + ", runtimeEntityId=" + this.getRuntimeEntityId() + ", playerGamemode=" + this.getPlayerGamemode() + ", playerPosition=" + this.getPlayerPosition() + ", rotation=" + this.getRotation() + ", seed=" + this.getSeed() + ", dimensionId=" + this.getDimensionId() + ", generatorId=" + this.getGeneratorId() + ", levelGamemode=" + this.getLevelGamemode() + ", difficulty=" + this.getDifficulty() + ", defaultSpawn=" + this.getDefaultSpawn() + ", acheivementsDisabled=" + this.isAcheivementsDisabled() + ", time=" + this.getTime() + ", eduLevel=" + this.isEduLevel() + ", eduFeaturesEnabled=" + this.isEduFeaturesEnabled() + ", rainLevel=" + this.getRainLevel() + ", lightningLevel=" + this.getLightningLevel() + ", platformLockedContentConfirmed=" + this.isPlatformLockedContentConfirmed() + ", multiplayerGame=" + this.isMultiplayerGame() + ", broadcastingToLan=" + this.isBroadcastingToLan() + ", xblBroadcastMode=" + (Object)((Object)this.getXblBroadcastMode()) + ", platformBroadcastMode=" + (Object)((Object)this.getPlatformBroadcastMode()) + ", commandsEnabled=" + this.isCommandsEnabled() + ", texturePacksRequired=" + this.isTexturePacksRequired() + ", bonusChestEnabled=" + this.isBonusChestEnabled() + ", startingWithMap=" + this.isStartingWithMap() + ", trustingPlayers=" + this.isTrustingPlayers() + ", defaultPlayerPermission=" + this.getDefaultPlayerPermission() + ", serverChunkTickRange=" + this.getServerChunkTickRange() + ", behaviorPackLocked=" + this.isBehaviorPackLocked() + ", resourcePackLocked=" + this.isResourcePackLocked() + ", fromLockedWorldTemplate=" + this.isFromLockedWorldTemplate() + ", usingMsaGamertagsOnly=" + this.isUsingMsaGamertagsOnly() + ", fromWorldTemplate=" + this.isFromWorldTemplate() + ", worldTemplateOptionLocked=" + this.isWorldTemplateOptionLocked() + ", onlySpawningV1Villagers=" + this.isOnlySpawningV1Villagers() + ", levelId=" + this.getLevelId() + ", worldName=" + this.getWorldName() + ", premiumWorldTemplateId=" + this.getPremiumWorldTemplateId() + ", trial=" + this.isTrial() + ", currentTick=" + this.getCurrentTick() + ", enchantmentSeed=" + this.getEnchantmentSeed() + ", cachedPalette=" + this.getCachedPalette() + ", multiplayerCorrelationId=" + this.getMultiplayerCorrelationId() + ")";
    }

    public static final class ItemEntry {
        private final String identifier;
        private final short id;

        public ItemEntry(String identifier, short id) {
            this.identifier = identifier;
            this.id = id;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public short getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ItemEntry)) {
                return false;
            }
            ItemEntry other = (ItemEntry)o;
            String this$identifier = this.getIdentifier();
            String other$identifier = other.getIdentifier();
            if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
                return false;
            }
            return this.getId() == other.getId();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            result = result * 59 + this.getId();
            return result;
        }

        public String toString() {
            return "StartGamePacket.ItemEntry(identifier=" + this.getIdentifier() + ", id=" + this.getId() + ")";
        }
    }

    public static final class BlockPaletteEntry {
        private final String identifier;
        private final short meta;
        private final short legacyId;

        public BlockPaletteEntry(String identifier, short meta) {
            this.identifier = identifier;
            this.meta = meta;
            this.legacyId = (short)-1;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public short getMeta() {
            return this.meta;
        }

        public short getLegacyId() {
            return this.legacyId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BlockPaletteEntry)) {
                return false;
            }
            BlockPaletteEntry other = (BlockPaletteEntry)o;
            String this$identifier = this.getIdentifier();
            String other$identifier = other.getIdentifier();
            if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
                return false;
            }
            if (this.getMeta() != other.getMeta()) {
                return false;
            }
            return this.getLegacyId() == other.getLegacyId();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            result = result * 59 + this.getMeta();
            result = result * 59 + this.getLegacyId();
            return result;
        }

        public String toString() {
            return "StartGamePacket.BlockPaletteEntry(identifier=" + this.getIdentifier() + ", meta=" + this.getMeta() + ", legacyId=" + this.getLegacyId() + ")";
        }

        public BlockPaletteEntry(String identifier, short meta, short legacyId) {
            this.identifier = identifier;
            this.meta = meta;
            this.legacyId = legacyId;
        }
    }
}

