/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.packet;

import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.handler.BedrockPacketHandler;
import java.util.Arrays;
import java.util.UUID;

public class ResourcePackDataInfoPacket
extends BedrockPacket {
    private UUID packId;
    private String packVersion;
    private long maxChunkSize;
    private long chunkCount;
    private long compressedPackSize;
    private byte[] hash;
    private boolean premium;
    private Type type;

    @Override
    public final boolean handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    public UUID getPackId() {
        return this.packId;
    }

    public String getPackVersion() {
        return this.packVersion;
    }

    public long getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public long getChunkCount() {
        return this.chunkCount;
    }

    public long getCompressedPackSize() {
        return this.compressedPackSize;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public boolean isPremium() {
        return this.premium;
    }

    public Type getType() {
        return this.type;
    }

    public void setPackId(UUID packId) {
        this.packId = packId;
    }

    public void setPackVersion(String packVersion) {
        this.packVersion = packVersion;
    }

    public void setMaxChunkSize(long maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
    }

    public void setChunkCount(long chunkCount) {
        this.chunkCount = chunkCount;
    }

    public void setCompressedPackSize(long compressedPackSize) {
        this.compressedPackSize = compressedPackSize;
    }

    public void setHash(byte[] hash) {
        this.hash = hash;
    }

    public void setPremium(boolean premium) {
        this.premium = premium;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String toString() {
        return "ResourcePackDataInfoPacket(packId=" + this.getPackId() + ", packVersion=" + this.getPackVersion() + ", maxChunkSize=" + this.getMaxChunkSize() + ", chunkCount=" + this.getChunkCount() + ", compressedPackSize=" + this.getCompressedPackSize() + ", hash=" + Arrays.toString(this.getHash()) + ", premium=" + this.isPremium() + ", type=" + (Object)((Object)this.getType()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourcePackDataInfoPacket)) {
            return false;
        }
        ResourcePackDataInfoPacket other = (ResourcePackDataInfoPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UUID this$packId = this.getPackId();
        UUID other$packId = other.getPackId();
        if (this$packId == null ? other$packId != null : !((Object)this$packId).equals(other$packId)) {
            return false;
        }
        String this$packVersion = this.getPackVersion();
        String other$packVersion = other.getPackVersion();
        if (this$packVersion == null ? other$packVersion != null : !this$packVersion.equals(other$packVersion)) {
            return false;
        }
        if (this.getMaxChunkSize() != other.getMaxChunkSize()) {
            return false;
        }
        if (this.getChunkCount() != other.getChunkCount()) {
            return false;
        }
        if (this.getCompressedPackSize() != other.getCompressedPackSize()) {
            return false;
        }
        if (!Arrays.equals(this.getHash(), other.getHash())) {
            return false;
        }
        if (this.isPremium() != other.isPremium()) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourcePackDataInfoPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UUID $packId = this.getPackId();
        result = result * 59 + ($packId == null ? 43 : ((Object)$packId).hashCode());
        String $packVersion = this.getPackVersion();
        result = result * 59 + ($packVersion == null ? 43 : $packVersion.hashCode());
        long $maxChunkSize = this.getMaxChunkSize();
        result = result * 59 + (int)($maxChunkSize >>> 32 ^ $maxChunkSize);
        long $chunkCount = this.getChunkCount();
        result = result * 59 + (int)($chunkCount >>> 32 ^ $chunkCount);
        long $compressedPackSize = this.getCompressedPackSize();
        result = result * 59 + (int)($compressedPackSize >>> 32 ^ $compressedPackSize);
        result = result * 59 + Arrays.hashCode(this.getHash());
        result = result * 59 + (this.isPremium() ? 79 : 97);
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public static enum Type {
        INVALID,
        RESOURCE,
        BEHAVIOR,
        WORLD_TEMPLATE,
        ADDON,
        SKINS,
        CACHED,
        COPY_PROTECTED;

    }
}

