/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.handler;

import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.BedrockSession;
import com.nukkitx.protocol.bedrock.handler.BatchHandler;
import com.nukkitx.protocol.bedrock.handler.BedrockPacketHandler;
import io.netty.buffer.ByteBuf;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collection;

public class DefaultBatchHandler
implements BatchHandler {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(DefaultBatchHandler.class);
    public static final DefaultBatchHandler INSTANCE = new DefaultBatchHandler();

    @Override
    public void handle(BedrockSession session, ByteBuf compressed, Collection<BedrockPacket> packets) {
        for (BedrockPacket packet : packets) {
            BedrockPacketHandler handler;
            if (session.isLogging() && log.isTraceEnabled()) {
                log.trace("Inbound {}: {}", (Object)session.getAddress(), (Object)packet);
            }
            if ((handler = session.getPacketHandler()) != null && packet.handle(handler)) continue;
            log.debug("Unhandled packet for {}: {}", (Object)session.getAddress(), (Object)packet);
        }
    }

    private DefaultBatchHandler() {
    }
}

