/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.data.event;

import com.nukkitx.protocol.bedrock.data.event.EventData;
import com.nukkitx.protocol.bedrock.data.event.EventDataType;

public final class BossKilledEventData
implements EventData {
    private final long bossUniqueEntityId;
    private final int playerPartySize;
    private final int legacyEntityTypeId;

    @Override
    public EventDataType getType() {
        return EventDataType.BOSS_KILLED;
    }

    public BossKilledEventData(long bossUniqueEntityId, int playerPartySize, int legacyEntityTypeId) {
        this.bossUniqueEntityId = bossUniqueEntityId;
        this.playerPartySize = playerPartySize;
        this.legacyEntityTypeId = legacyEntityTypeId;
    }

    public long getBossUniqueEntityId() {
        return this.bossUniqueEntityId;
    }

    public int getPlayerPartySize() {
        return this.playerPartySize;
    }

    public int getLegacyEntityTypeId() {
        return this.legacyEntityTypeId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BossKilledEventData)) {
            return false;
        }
        BossKilledEventData other = (BossKilledEventData)o;
        if (this.getBossUniqueEntityId() != other.getBossUniqueEntityId()) {
            return false;
        }
        if (this.getPlayerPartySize() != other.getPlayerPartySize()) {
            return false;
        }
        return this.getLegacyEntityTypeId() == other.getLegacyEntityTypeId();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $bossUniqueEntityId = this.getBossUniqueEntityId();
        result = result * 59 + (int)($bossUniqueEntityId >>> 32 ^ $bossUniqueEntityId);
        result = result * 59 + this.getPlayerPartySize();
        result = result * 59 + this.getLegacyEntityTypeId();
        return result;
    }

    public String toString() {
        return "BossKilledEventData(bossUniqueEntityId=" + this.getBossUniqueEntityId() + ", playerPartySize=" + this.getPlayerPartySize() + ", legacyEntityTypeId=" + this.getLegacyEntityTypeId() + ")";
    }
}

