/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.data;

import com.flowpowered.math.vector.Vector3i;

public final class StructureSettings {
    private final String paletteName;
    private final boolean ignoreEntities;
    private final boolean ignoreBlocks;
    private final Vector3i structureSize;
    private final Vector3i structureOffset;
    private final long lastTouchedByEntityId;
    private final byte rotation;
    private final byte mirror;
    private final float integrityValue;
    private final int integritySeed;

    public StructureSettings(String paletteName, boolean ignoreEntities, boolean ignoreBlocks, Vector3i structureSize, Vector3i structureOffset, long lastTouchedByEntityId, byte rotation, byte mirror, float integrityValue, int integritySeed) {
        this.paletteName = paletteName;
        this.ignoreEntities = ignoreEntities;
        this.ignoreBlocks = ignoreBlocks;
        this.structureSize = structureSize;
        this.structureOffset = structureOffset;
        this.lastTouchedByEntityId = lastTouchedByEntityId;
        this.rotation = rotation;
        this.mirror = mirror;
        this.integrityValue = integrityValue;
        this.integritySeed = integritySeed;
    }

    public String getPaletteName() {
        return this.paletteName;
    }

    public boolean isIgnoreEntities() {
        return this.ignoreEntities;
    }

    public boolean isIgnoreBlocks() {
        return this.ignoreBlocks;
    }

    public Vector3i getStructureSize() {
        return this.structureSize;
    }

    public Vector3i getStructureOffset() {
        return this.structureOffset;
    }

    public long getLastTouchedByEntityId() {
        return this.lastTouchedByEntityId;
    }

    public byte getRotation() {
        return this.rotation;
    }

    public byte getMirror() {
        return this.mirror;
    }

    public float getIntegrityValue() {
        return this.integrityValue;
    }

    public int getIntegritySeed() {
        return this.integritySeed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StructureSettings)) {
            return false;
        }
        StructureSettings other = (StructureSettings)o;
        String this$paletteName = this.getPaletteName();
        String other$paletteName = other.getPaletteName();
        if (this$paletteName == null ? other$paletteName != null : !this$paletteName.equals(other$paletteName)) {
            return false;
        }
        if (this.isIgnoreEntities() != other.isIgnoreEntities()) {
            return false;
        }
        if (this.isIgnoreBlocks() != other.isIgnoreBlocks()) {
            return false;
        }
        Vector3i this$structureSize = this.getStructureSize();
        Vector3i other$structureSize = other.getStructureSize();
        if (this$structureSize == null ? other$structureSize != null : !this$structureSize.equals(other$structureSize)) {
            return false;
        }
        Vector3i this$structureOffset = this.getStructureOffset();
        Vector3i other$structureOffset = other.getStructureOffset();
        if (this$structureOffset == null ? other$structureOffset != null : !this$structureOffset.equals(other$structureOffset)) {
            return false;
        }
        if (this.getLastTouchedByEntityId() != other.getLastTouchedByEntityId()) {
            return false;
        }
        if (this.getRotation() != other.getRotation()) {
            return false;
        }
        if (this.getMirror() != other.getMirror()) {
            return false;
        }
        if (Float.compare(this.getIntegrityValue(), other.getIntegrityValue()) != 0) {
            return false;
        }
        return this.getIntegritySeed() == other.getIntegritySeed();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $paletteName = this.getPaletteName();
        result = result * 59 + ($paletteName == null ? 43 : $paletteName.hashCode());
        result = result * 59 + (this.isIgnoreEntities() ? 79 : 97);
        result = result * 59 + (this.isIgnoreBlocks() ? 79 : 97);
        Vector3i $structureSize = this.getStructureSize();
        result = result * 59 + ($structureSize == null ? 43 : $structureSize.hashCode());
        Vector3i $structureOffset = this.getStructureOffset();
        result = result * 59 + ($structureOffset == null ? 43 : $structureOffset.hashCode());
        long $lastTouchedByEntityId = this.getLastTouchedByEntityId();
        result = result * 59 + (int)($lastTouchedByEntityId >>> 32 ^ $lastTouchedByEntityId);
        result = result * 59 + this.getRotation();
        result = result * 59 + this.getMirror();
        result = result * 59 + Float.floatToIntBits(this.getIntegrityValue());
        result = result * 59 + this.getIntegritySeed();
        return result;
    }

    public String toString() {
        return "StructureSettings(paletteName=" + this.getPaletteName() + ", ignoreEntities=" + this.isIgnoreEntities() + ", ignoreBlocks=" + this.isIgnoreBlocks() + ", structureSize=" + this.getStructureSize() + ", structureOffset=" + this.getStructureOffset() + ", lastTouchedByEntityId=" + this.getLastTouchedByEntityId() + ", rotation=" + this.getRotation() + ", mirror=" + this.getMirror() + ", integrityValue=" + this.getIntegrityValue() + ", integritySeed=" + this.getIntegritySeed() + ")";
    }
}

